/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.XmlEntry;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.w3c.dom.Element;

public class XmlPresentationProvider
extends TimeGraphPresentationProvider {
    private static final long[] COLOR_SEED;
    private static final int COLOR_MASK = 0xFFFFFF;
    private List<StateItem> stateValues = new ArrayList<StateItem>();
    private Map<Integer, Integer> stateIndex = new HashMap<Integer, Integer>();
    private StateItem[] stateTable = new StateItem[0];

    static {
        long[] lArray = new long[8];
        lArray[0] = 255L;
        lArray[1] = 0xFF0000L;
        lArray[2] = 65280L;
        lArray[3] = 0xFF00FFL;
        lArray[4] = 65535L;
        lArray[5] = 0xFFFF00L;
        lArray[7] = 15758080L;
        COLOR_SEED = lArray;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            Integer index;
            TimeEvent tcEvent = (TimeEvent)event;
            XmlEntry entry = (XmlEntry)event.getEntry();
            int value = tcEvent.getValue();
            if (entry.getType() == XmlEntry.EntryDisplayType.DISPLAY && (index = this.stateIndex.get(value)) != null) {
                return index;
            }
        }
        return -1;
    }

    public StateItem[] getStateTable() {
        return this.stateTable;
    }

    public String getEventName(ITimeEvent event) {
        if (event instanceof TimeEvent && ((TimeEvent)event).hasValue()) {
            Integer index;
            TimeEvent tcEvent = (TimeEvent)event;
            XmlEntry entry = (XmlEntry)event.getEntry();
            int value = tcEvent.getValue();
            if (entry.getType() == XmlEntry.EntryDisplayType.DISPLAY && (index = this.stateIndex.get(value)) != null) {
                String rgb = this.stateValues.get(index).getStateString();
                return rgb;
            }
            return null;
        }
        return Messages.XmlPresentationProvider_MultipleStates;
    }

    public Map<String, String> getEventHoverToolTipInfo(ITimeEvent event, long hoverTime) {
        return Collections.EMPTY_MAP;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
    }

    public void postDrawEntry(ITimeGraphEntry entry, Rectangle bounds, GC gc) {
    }

    public synchronized void loadNewStates(@NonNull Element viewElement) {
        this.stateValues.clear();
        this.stateIndex.clear();
        List states = TmfXmlUtils.getChildElements((Element)viewElement, (String)"definedValue");
        for (Element state : states) {
            int value = Integer.parseInt(state.getAttribute("value"));
            String name = state.getAttribute("name");
            String color = state.getAttribute("color");
            this.addOrUpdateState(value, name, color);
        }
        this.stateTable = this.stateValues.toArray(new StateItem[this.stateValues.size()]);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XmlPresentationProvider.this.fireColorSettingsChanged();
            }
        });
    }

    public synchronized int addState(String name) {
        int value = 10000;
        while (this.stateIndex.get(value) != null) {
            ++value;
        }
        this.addOrUpdateState(value, name, "");
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                XmlPresentationProvider.this.fireColorSettingsChanged();
            }
        });
        return value;
    }

    private synchronized void addOrUpdateState(int value, String name, String color) {
        if (value < 0) {
            return;
        }
        RGB colorRGB = color.startsWith("#") ? XmlPresentationProvider.parseColor(color) : XmlPresentationProvider.calcColor(name);
        StateItem item = new StateItem(colorRGB, name);
        Integer index = this.stateIndex.get(value);
        if (index == null) {
            this.stateIndex.put(value, this.stateValues.size());
            this.stateValues.add(item);
        } else {
            this.stateValues.set(index, item);
        }
        this.stateTable = this.stateValues.toArray(new StateItem[this.stateValues.size()]);
    }

    private static RGB parseColor(String color) {
        Integer hex = Integer.parseInt(color.substring(1), 16);
        int hex1 = hex % 256;
        int hex2 = hex / 256 % 256;
        int hex3 = hex / 65536 % 256;
        RGB colorRGB = new RGB(hex3, hex2, hex1);
        return colorRGB;
    }

    private static RGB calcColor(String name) {
        long hash = name.hashCode();
        long base = COLOR_SEED[(int)(Math.abs(hash) % (long)COLOR_SEED.length)];
        int x = (int)(hash & 0xFFFFFFL ^ base);
        int r = x >> 16 & 0xFF;
        int g = x >> 8 & 0xFF;
        int b = x & 0xFF;
        return new RGB(r, g, b);
    }

    public boolean hasIndex(int status) {
        return this.stateIndex.containsKey(status);
    }
}

