/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts.barcharts;

import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfChartTimeStampFormat;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.barcharts.TmfHistogramTooltipProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.linecharts.TmfCommonXLineChartViewer;
import org.swtchart.Chart;
import org.swtchart.IAxisTick;
import org.swtchart.ISeries;

public abstract class TmfBarChartViewer
extends TmfCommonXLineChartViewer {
    public static final int MINIMUM_BAR_WIDTH = 1;
    private int fBarWidth = 1;
    private final List<String> fSeriesNames = new ArrayList<String>();
    private final List<RGB> fColors = new ArrayList<RGB>();

    public TmfBarChartViewer(Composite parent, String title, String xLabel, String yLabel, int barWidth) {
        super(parent, title, xLabel, yLabel);
        this.fBarWidth = barWidth;
        this.setTooltipProvider(new TmfHistogramTooltipProvider(this));
    }

    @Override
    protected @NonNull String getSeriesType(@NonNull String seriesName) {
        return "bar";
    }

    @Override
    protected int getWidth(@NonNull String seriesName) {
        return this.fBarWidth;
    }

    @Deprecated
    protected void readData(ISeries series, long start, long end, int nb) {
    }

    @Deprecated
    protected void drawChart(final ISeries series, final double[] x, final double[] y) {
        final Display display = TmfBarChartViewer.getDisplay();
        if (display.isDisposed()) {
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (display.isDisposed()) {
                    return;
                }
                Chart swtChart = TmfBarChartViewer.this.getSwtChart();
                IAxisTick xTick = swtChart.getAxisSet().getXAxis(0).getTick();
                xTick.setFormat((Format)new TmfChartTimeStampFormat(TmfBarChartViewer.this.getTimeOffset()));
                series.setXSeries(x);
                series.setYSeries(y);
                xTick.setTickMarkStepHint(256);
                swtChart.getAxisSet().adjustRange();
                swtChart.redraw();
            }
        });
    }

    @Deprecated
    protected void addSeries(String name, RGB color) {
        this.fSeriesNames.add(name);
        this.fColors.add(color);
    }

    @Deprecated
    protected void clearSeries() {
        this.fSeriesNames.clear();
        this.fColors.clear();
    }
}

