/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.ui.internal.contentassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.wst.html.ui.internal.contentassist.HTMLTemplateCompletionProcessor;
import org.eclipse.wst.html.ui.internal.templates.TemplateContextTypeIdsHTML;
import org.eclipse.wst.sse.ui.contentassist.CompletionProposalInvocationContext;
import org.eclipse.wst.xml.ui.internal.contentassist.ContentAssistRequest;
import org.eclipse.wst.xml.ui.internal.contentassist.DefaultXMLCompletionProposalComputer;

public class HTMLTemplatesCompletionProposalComputer
extends DefaultXMLCompletionProposalComputer {
    private HTMLTemplateCompletionProcessor fTemplateProcessor = new HTMLTemplateCompletionProcessor();

    public List computeCompletionProposals(CompletionProposalInvocationContext context, IProgressMonitor monitor) {
        ArrayList proposals = new ArrayList(super.computeCompletionProposals(context, monitor));
        proposals.addAll(this.getTemplateProposals(TemplateContextTypeIdsHTML.ALL, context));
        return proposals;
    }

    protected void addAttributeNameProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsHTML.ATTRIBUTE, context);
    }

    protected void addAttributeValueProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsHTML.ATTRIBUTE_VALUE, context);
    }

    protected void addEmptyDocumentProposals(ContentAssistRequest contentAssistRequest, CompletionProposalInvocationContext context) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsHTML.NEW, context);
    }

    protected void addTagInsertionProposals(ContentAssistRequest contentAssistRequest, int childPosition, CompletionProposalInvocationContext context) {
        this.addTemplates(contentAssistRequest, TemplateContextTypeIdsHTML.TAG, context);
    }

    private List getTemplateProposals(String templateContext, CompletionProposalInvocationContext context) {
        ArrayList<ICompletionProposal> templateProposals = new ArrayList<ICompletionProposal>();
        if (this.fTemplateProcessor != null) {
            this.fTemplateProcessor.setContextType(templateContext);
            ICompletionProposal[] proposals = this.fTemplateProcessor.computeCompletionProposals(context.getViewer(), context.getInvocationOffset());
            templateProposals.addAll(Arrays.asList(proposals));
        }
        return templateProposals;
    }

    private void addTemplates(ContentAssistRequest contentAssistRequest, String templateContext, CompletionProposalInvocationContext context) {
        if (contentAssistRequest != null) {
            boolean useProposalList = !contentAssistRequest.shouldSeparate();
            List proposals = this.getTemplateProposals(templateContext, context);
            int i = 0;
            while (i < proposals.size()) {
                if (useProposalList) {
                    contentAssistRequest.addProposal((ICompletionProposal)proposals.get(i));
                } else {
                    contentAssistRequest.addMacro((ICompletionProposal)proposals.get(i));
                }
                ++i;
            }
        }
    }
}

