/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.java.resource;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.xtend.lib.annotations.FinalFieldsConstructor;
import org.eclipse.xtext.common.types.TypesPackage;
import org.eclipse.xtext.common.types.descriptions.EObjectDescriptionBasedStubGenerator;
import org.eclipse.xtext.java.resource.JavaResource;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

@FinalFieldsConstructor
public class IndexAwareNameEnvironment
implements INameEnvironment {
    private final Resource resource;
    private final ClassLoader classLoader;
    private final IResourceDescriptions resourceDescriptions;
    private final EObjectDescriptionBasedStubGenerator stubGenerator;
    private Map<QualifiedName, NameEnvironmentAnswer> cache = CollectionLiterals.newHashMap((Pair[])new Pair[0]);

    public void cleanup() {
        this.cache.clear();
    }

    public NameEnvironmentAnswer findType(char[][] compoundTypeName) {
        Functions.Function1 _function = it -> String.valueOf(it);
        QualifiedName className = QualifiedName.create((List)ListExtensions.map((List)((List)Conversions.doWrapArray((Object)compoundTypeName)), (Functions.Function1)_function));
        return this.findType(className);
    }

    public NameEnvironmentAnswer findType(QualifiedName className) {
        try {
            boolean _containsKey = this.cache.containsKey(className);
            if (_containsKey) {
                return this.cache.get(className);
            }
            IEObjectDescription candidate = (IEObjectDescription)IterableExtensions.head((Iterable)this.resourceDescriptions.getExportedObjects(TypesPackage.Literals.JVM_DECLARED_TYPE, className, false));
            NameEnvironmentAnswer result = null;
            if (candidate != null) {
                NameEnvironmentAnswer _nameEnvironmentAnswer;
                IResourceDescription resourceDescription = this.resourceDescriptions.getResourceDescription(candidate.getEObjectURI().trimFragment());
                Resource res = this.resource.getResourceSet().getResource(resourceDescription.getURI(), false);
                String _xifexpression = null;
                _xifexpression = res instanceof JavaResource ? ((JavaResource)res).getOriginalSource() : this.stubGenerator.getJavaStubSource(candidate, resourceDescription);
                String source = _xifexpression;
                char[] _charArray = source.toCharArray();
                String _string = className.toString("/");
                String _plus = _string + ".java";
                CompilationUnit _compilationUnit = new CompilationUnit(_charArray, _plus, null);
                result = _nameEnvironmentAnswer = new NameEnvironmentAnswer((ICompilationUnit)_compilationUnit, null);
            } else {
                NameEnvironmentAnswer _nameEnvironmentAnswer_1;
                String _string_1 = className.toString("/");
                String fileName = _string_1 + ".class";
                URL url = this.classLoader.getResource(fileName);
                if (url == null) {
                    this.cache.put(className, null);
                    return null;
                }
                ClassFileReader reader = ClassFileReader.read((InputStream)url.openStream(), (String)fileName);
                result = _nameEnvironmentAnswer_1 = new NameEnvironmentAnswer((IBinaryType)reader, null);
            }
            this.cache.put(className, result);
            return result;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public NameEnvironmentAnswer findType(char[] typeName, char[][] packageName) {
        Functions.Function1 _function = it -> String.valueOf(it);
        List _map = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)packageName)), (Functions.Function1)_function);
        ArrayList<String> list = new ArrayList<String>(_map);
        String _valueOf = String.valueOf(typeName);
        list.add(_valueOf);
        QualifiedName className = QualifiedName.create(list);
        return this.findType(className);
    }

    public boolean isPackage(char[][] parentPackageName, char[] packageName) {
        if (packageName == null || packageName.length == 0) {
            return false;
        }
        return Character.isLowerCase(((Character)IterableExtensions.head((Iterable)((Iterable)Conversions.doWrapArray((Object)packageName)))).charValue());
    }

    public IndexAwareNameEnvironment(Resource resource, ClassLoader classLoader, IResourceDescriptions resourceDescriptions, EObjectDescriptionBasedStubGenerator stubGenerator) {
        this.resource = resource;
        this.classLoader = classLoader;
        this.resourceDescriptions = resourceDescriptions;
        this.stubGenerator = stubGenerator;
    }
}

