/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.ui.mode;

import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.ui.NatEventData;
import net.sourceforge.nattable.ui.action.DragModeEventHandler;
import net.sourceforge.nattable.ui.action.IDragMode;
import net.sourceforge.nattable.ui.action.IMouseAction;
import net.sourceforge.nattable.ui.mode.AbstractModeEventHandler;
import net.sourceforge.nattable.ui.mode.ModeSupport;
import net.sourceforge.nattable.ui.util.CancelableRunnable;
import org.eclipse.swt.events.MouseEvent;

public class MouseModeEventHandler
extends AbstractModeEventHandler {
    private final NatTable natTable;
    private MouseEvent initialMouseDownEvent;
    private IMouseAction singleClickAction;
    private IMouseAction doubleClickAction;
    private boolean mouseDown;
    private IDragMode dragMode;
    private SingleClickRunnable singleClickRunnable;
    private boolean exclusive = false;

    public MouseModeEventHandler(ModeSupport modeSupport, NatTable natTable, MouseEvent initialMouseDownEvent, IMouseAction singleClickAction, IMouseAction doubleClickAction, IDragMode dragMode) {
        super(modeSupport);
        this.natTable = natTable;
        this.mouseDown = true;
        this.initialMouseDownEvent = initialMouseDownEvent;
        this.singleClickAction = singleClickAction;
        this.doubleClickAction = doubleClickAction;
        this.dragMode = dragMode;
    }

    public void mouseUp(MouseEvent event) {
        this.mouseDown = false;
        if (this.singleClickAction != null) {
            if (this.exclusive && this.doubleClickAction != null) {
                this.singleClickRunnable = new SingleClickRunnable(this.singleClickAction, event);
                event.display.timerExec(event.display.getDoubleClickTime(), (Runnable)this.singleClickRunnable);
            } else {
                this.executeSingleClickAction(this.singleClickAction, event);
            }
        } else if (this.doubleClickAction == null) {
            this.switchMode("NORMAL_MODE");
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        if (this.doubleClickAction != null) {
            if (this.singleClickRunnable != null) {
                this.singleClickRunnable.cancel();
            }
            event.data = NatEventData.createInstanceFromEvent(event);
            this.doubleClickAction.run(this.natTable, event);
            this.switchMode("NORMAL_MODE");
        }
    }

    public synchronized void mouseMove(MouseEvent event) {
        if (this.mouseDown && this.dragMode != null) {
            this.dragMode.mouseDown(this.natTable, this.initialMouseDownEvent);
            this.switchMode(new DragModeEventHandler(this.getModeSupport(), this.natTable, this.dragMode));
        } else {
            this.switchMode("NORMAL_MODE");
        }
    }

    private void executeSingleClickAction(IMouseAction action, MouseEvent event) {
        event.data = NatEventData.createInstanceFromEvent(event);
        action.run(this.natTable, event);
        this.switchMode("NORMAL_MODE");
    }

    class SingleClickRunnable
    extends CancelableRunnable {
        private IMouseAction action;
        private MouseEvent event;

        public SingleClickRunnable(IMouseAction action, MouseEvent event) {
            this.action = action;
            this.event = event;
        }

        public void run() {
            if (!this.isCancelled()) {
                MouseModeEventHandler.this.executeSingleClickAction(this.action, this.event);
            }
        }
    }
}

