/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.tools.i18n.LocalizedResource;
import org.apache.derby.impl.drda.DRDAStatement;
import org.apache.derby.impl.drda.NetworkServerControlImpl;
import org.apache.derby.impl.drda.PiggyBackedSessionData;
import org.apache.derby.impl.drda.Pkgnamcsn;

class Database {
    private String dbName;
    private String shortDbName;
    String attrString = "";
    protected int securityMechanism;
    protected String userId;
    protected String password;
    protected String decryptedUserId;
    protected String decryptedPassword;
    protected byte[] passwordSubstitute;
    protected boolean rdbAllowUpdates = true;
    protected int accessCount;
    protected byte[] secTokenIn;
    protected byte[] secTokenOut;
    protected byte[] crrtkn;
    protected String typDefNam;
    protected int byteOrder;
    protected int ccsidSBC;
    protected int ccsidDBC;
    protected int ccsidMBC;
    protected String ccsidSBCEncoding;
    protected String ccsidDBCEncoding;
    protected String ccsidMBCEncoding;
    protected boolean RDBUPDRM_sent = false;
    protected boolean sendTRGDFTRT = false;
    private EngineConnection conn;
    DRDAStatement defaultStatement;
    private DRDAStatement currentStatement;
    private Hashtable<Object, DRDAStatement> stmtTable;
    private boolean locatorSupport = false;
    private boolean locatorSupportChecked = false;
    private PiggyBackedSessionData pbsd_ = null;

    Database(String string) {
        this.setDatabaseName(string);
        this.stmtTable = new Hashtable();
        this.initializeDefaultStatement();
    }

    public void setDatabaseName(String string) {
        if (string != null) {
            int n = string.indexOf(59);
            if (n != -1) {
                this.attrString = string.substring(n, string.length());
                this.shortDbName = string.substring(0, n);
            } else {
                this.shortDbName = string;
            }
        }
        this.dbName = string;
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public String getShortDbName() {
        return this.shortDbName;
    }

    private void initializeDefaultStatement() {
        this.defaultStatement = new DRDAStatement(this);
    }

    final void setConnection(EngineConnection engineConnection) throws SQLException {
        if (this.conn != engineConnection) {
            this.pbsd_ = null;
        }
        this.conn = engineConnection;
        if (engineConnection != null) {
            this.defaultStatement.setStatement(engineConnection);
        }
    }

    final EngineConnection getConnection() {
        return this.conn;
    }

    protected DRDAStatement getCurrentStatement() {
        return this.currentStatement;
    }

    protected DRDAStatement getDefaultStatement() {
        this.currentStatement = this.defaultStatement;
        return this.defaultStatement;
    }

    protected DRDAStatement getDefaultStatement(Pkgnamcsn pkgnamcsn) {
        this.currentStatement = this.defaultStatement;
        this.currentStatement.setPkgnamcsn(pkgnamcsn);
        return this.currentStatement;
    }

    protected DRDAStatement newDRDAStatement(Pkgnamcsn pkgnamcsn) throws SQLException {
        DRDAStatement dRDAStatement = this.getDRDAStatement(pkgnamcsn);
        if (dRDAStatement != null) {
            dRDAStatement.close();
            dRDAStatement.reset();
        } else {
            dRDAStatement = new DRDAStatement(this);
            dRDAStatement.setPkgnamcsn(pkgnamcsn);
            this.storeStatement(dRDAStatement);
        }
        return dRDAStatement;
    }

    protected DRDAStatement getDRDAStatement(Pkgnamcsn pkgnamcsn) {
        DRDAStatement dRDAStatement = this.stmtTable.get(pkgnamcsn.getStatementKey());
        if (dRDAStatement != null) {
            this.currentStatement = dRDAStatement;
            this.currentStatement.setCurrentDrdaResultSet(pkgnamcsn);
        }
        return dRDAStatement;
    }

    void makeConnection(Properties properties) throws SQLException {
        EngineConnection engineConnection;
        properties.put("user", this.userId);
        if (this.password != null) {
            properties.put("password", this.password);
        }
        if ((engineConnection = (EngineConnection)NetworkServerControlImpl.getDriver().connect("jdbc:derby:" + this.shortDbName + this.attrString, properties)) != null) {
            engineConnection.setAutoCommit(false);
        }
        this.setConnection(engineConnection);
    }

    void makeDummyConnection() {
        try {
            EngineConnection engineConnection = (EngineConnection)NetworkServerControlImpl.getDriver().connect("jdbc:derby:" + this.shortDbName + this.attrString, new Properties());
            if (engineConnection != null) {
                engineConnection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    String appendAttrString(Properties properties) {
        if (properties == null) {
            return null;
        }
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            this.attrString = this.attrString + ";" + string + "=" + properties.getProperty(string);
        }
        return this.attrString;
    }

    protected void storeStatement(DRDAStatement dRDAStatement) throws SQLException {
        this.stmtTable.put(dRDAStatement.getPkgnamcsn().getStatementKey(), dRDAStatement);
    }

    protected void removeStatement(DRDAStatement dRDAStatement) throws SQLException {
        this.stmtTable.remove(dRDAStatement.getPkgnamcsn().getStatementKey());
        dRDAStatement.close();
    }

    protected void setCurrentStatement(DRDAStatement dRDAStatement) {
        this.currentStatement = dRDAStatement;
    }

    protected void commit() throws SQLException {
        if (this.conn != null) {
            this.conn.commit();
        }
    }

    protected void rollback() throws SQLException {
        if (this.conn != null) {
            this.conn.rollback();
        }
    }

    protected void close() throws SQLException {
        try {
            if (this.stmtTable != null) {
                Enumeration<DRDAStatement> enumeration = this.stmtTable.elements();
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement().close();
                }
            }
            if (this.defaultStatement != null) {
                this.defaultStatement.close();
            }
            if (this.conn != null && !this.conn.isClosed()) {
                if (!this.conn.isInGlobalTransaction()) {
                    this.conn.rollback();
                }
                this.conn.close();
            }
        }
        finally {
            this.conn = null;
            this.currentStatement = null;
            this.defaultStatement = null;
            this.stmtTable = null;
        }
    }

    final void setDrdaID(String string) {
        if (this.conn != null) {
            this.conn.setDrdaID(string);
        }
    }

    final void setPrepareIsolation(int n) throws SQLException {
        this.conn.setPrepareIsolation(n);
    }

    final int getPrepareIsolation() throws SQLException {
        return this.conn.getPrepareIsolation();
    }

    protected String buildRuntimeInfo(String string, LocalizedResource localizedResource) {
        String string2 = string + localizedResource.getTextMessage("DRDA_RuntimeInfoDatabase.I", new Object[0]) + this.dbName + "\n" + localizedResource.getTextMessage("DRDA_RuntimeInfoUser.I", new Object[0]) + this.userId + "\n" + localizedResource.getTextMessage("DRDA_RuntimeInfoNumStatements.I", new Object[0]) + this.stmtTable.size() + "\n";
        string2 = string2 + localizedResource.getTextMessage("DRDA_RuntimeInfoPreparedStatementHeader.I", new Object[0]);
        Enumeration<DRDAStatement> enumeration = this.stmtTable.elements();
        while (enumeration.hasMoreElements()) {
            string2 = string2 + enumeration.nextElement().toDebugString(string + "\t") + "\n";
        }
        return string2;
    }

    boolean supportsLocator() throws SQLException {
        if (!this.locatorSupportChecked) {
            ResultSet resultSet = this.getConnection().getMetaData().getProcedures(null, "SYSIBM", "BLOBTRUNCATE");
            this.locatorSupport = resultSet.next();
            resultSet.close();
            this.locatorSupportChecked = true;
        }
        return this.locatorSupport;
    }

    public void reset() {
        this.decryptedUserId = null;
        this.decryptedPassword = null;
        this.passwordSubstitute = null;
        this.secTokenIn = null;
        this.secTokenOut = null;
        this.userId = null;
        this.password = null;
        this.securityMechanism = 0;
    }

    public PiggyBackedSessionData getPiggyBackedSessionData(boolean bl) throws SQLException {
        this.pbsd_ = PiggyBackedSessionData.getInstance(this.pbsd_, this.conn, bl);
        return this.pbsd_;
    }
}

