/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.TriggerInfo;
import org.apache.derby.impl.sql.execute.WriteCursorConstantAction;

public class UpdateConstantAction
extends WriteCursorConstantAction {
    int[] changedColumnIds;
    private boolean positionedUpdate;
    int numColumns;
    private String schemaName;
    private String tableName;

    public UpdateConstantAction() {
    }

    UpdateConstantAction(TableDescriptor tableDescriptor, StaticCompiledOpenConglomInfo staticCompiledOpenConglomInfo, IndexRowGenerator[] indexRowGeneratorArray, long[] lArray, StaticCompiledOpenConglomInfo[] staticCompiledOpenConglomInfoArray, String[] stringArray, boolean bl, UUID uUID, int n, int[] nArray, FKInfo[] fKInfoArray, TriggerInfo triggerInfo, FormatableBitSet formatableBitSet, int[] nArray2, int[] nArray3, int n2, boolean bl2, boolean bl3, boolean bl4) throws StandardException {
        super(tableDescriptor.getHeapConglomerateId(), staticCompiledOpenConglomInfo, indexRowGeneratorArray, lArray, staticCompiledOpenConglomInfoArray, stringArray, bl, null, uUID, n, fKInfoArray, triggerInfo, formatableBitSet, nArray2, nArray3, bl3, bl4);
        this.changedColumnIds = nArray;
        this.positionedUpdate = bl2;
        this.numColumns = n2;
        this.schemaName = tableDescriptor.getSchemaName();
        this.tableName = tableDescriptor.getName();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.changedColumnIds = ArrayUtil.readIntArray(objectInput);
        this.positionedUpdate = objectInput.readBoolean();
        this.numColumns = objectInput.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        ArrayUtil.writeIntArray(objectOutput, this.changedColumnIds);
        objectOutput.writeBoolean(this.positionedUpdate);
        objectOutput.writeInt(this.numColumns);
    }

    @Override
    public int getTypeFormatId() {
        return 39;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }
}

