/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.ui.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.amalgam.explorer.contextual.core.category.CategoryImpl;
import org.eclipse.amalgam.explorer.contextual.core.category.ICategory;
import org.eclipse.amalgam.explorer.contextual.core.model.IExplorerContextualModel;

public class ExplorerContextualModel
implements IExplorerContextualModel {
    protected Map<String, Boolean> _categoryShowHide = new HashMap<String, Boolean>();
    protected boolean limitateTreeExpansion = false;
    protected Hashtable<String, List<String>> explorerID2ExpandedObjectHashcodes = new Hashtable();

    public void setCategoryShowState(String categoryName_p, boolean showState_p) {
        this._categoryShowHide.put(categoryName_p, showState_p);
    }

    public boolean getCategoryShowState(String categoryName_p) {
        if (this._categoryShowHide.containsKey(categoryName_p)) {
            return this._categoryShowHide.get(categoryName_p);
        }
        return true;
    }

    public boolean doesLimitateTreeExpansion() {
        return this.limitateTreeExpansion;
    }

    public void setLimitateTreeExpansion(boolean limitateTreeExpansion_p) {
        this.limitateTreeExpansion = limitateTreeExpansion_p;
    }

    public boolean doesShowCategory(ICategory category) {
        if (this._categoryShowHide.containsKey(category.getName())) {
            return this.getCategoryShowState(category.getName());
        }
        return true;
    }

    public void saveExpandedState(CategoryImpl category, String explorerID, boolean expanded) {
        String hashcode;
        List<String> expandedObjects = this.getOrCreateHistory(explorerID);
        if (expandedObjects.contains(hashcode = this.getHashcode((ICategory)category)) && !expanded) {
            expandedObjects.remove(hashcode);
        } else if (!expandedObjects.contains(hashcode) && expanded) {
            expandedObjects.add(hashcode);
        }
    }

    public boolean getExpandedState(ICategory category, String explorerID) {
        List<String> expandedObjects;
        return !this.doesLimitateTreeExpansion() || (expandedObjects = this.explorerID2ExpandedObjectHashcodes.get(explorerID)) == null || expandedObjects.contains(this.getHashcode(category));
    }

    public boolean containsExpandedHistory(String explorerID) {
        return this.explorerID2ExpandedObjectHashcodes.containsKey(explorerID);
    }

    public List<String> getOrCreateHistory(String explorerID) {
        List<String> nonExpandedObjects = this.explorerID2ExpandedObjectHashcodes.get(explorerID);
        if (nonExpandedObjects == null) {
            nonExpandedObjects = new ArrayList<String>();
            this.explorerID2ExpandedObjectHashcodes.put(explorerID, nonExpandedObjects);
        }
        return nonExpandedObjects;
    }

    private String getHashcode(ICategory category) {
        return category.getName();
    }
}

