/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.internal.impl;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DBObject;
import com.mongodb.DBRefBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.mongodb.impl.MDbResultSetMetaData;
import org.eclipse.birt.data.oda.mongodb.internal.impl.ArrayFieldValues;
import org.eclipse.birt.data.oda.mongodb.internal.impl.DriverUtil;
import org.eclipse.birt.data.oda.mongodb.internal.impl.MDbMetaData;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class ResultDataHandler {
    private MDbResultSetMetaData m_rsMetaData;
    private List<String> m_flattenableLevelFields;
    private Map<String, MDbMetaData.FieldMetaData> m_intermediateFieldMDs;
    private Map<String, ArrayFieldValues> m_nestedValues;
    private Map<String, DBObject> m_currentContainingDocs;
    static final String TOP_LEVEL_PARENT = "";
    private static final DBObject NULL_VALUE_FIELD = new BasicDBObject().append("NULL", (Object)Boolean.TRUE);
    private static Logger sm_logger = DriverUtil.getLogger();

    public ResultDataHandler(MDbResultSetMetaData resultSetMetaData) {
        this.m_rsMetaData = resultSetMetaData;
        this.m_flattenableLevelFields = new ArrayList<String>(3);
        this.m_intermediateFieldMDs = new HashMap<String, MDbMetaData.FieldMetaData>(3);
        this.m_nestedValues = new HashMap<String, ArrayFieldValues>(3);
        this.m_currentContainingDocs = new HashMap<String, DBObject>(8);
        this.initializeNestedLevels();
    }

    private void initializeNestedLevels() {
        String nextLevelArrayField = TOP_LEVEL_PARENT;
        this.addFlattenableField(nextLevelArrayField);
        MDbMetaData.DocumentsMetaData docMD = this.getDocumentsMetaData();
        while (docMD != null) {
            String fieldSimpleName;
            MDbMetaData.FieldMetaData fieldMD;
            nextLevelArrayField = docMD.getFlattenableFieldName();
            if (nextLevelArrayField == null || (fieldMD = docMD.getFieldMetaData(fieldSimpleName = MDbMetaData.getSimpleName(nextLevelArrayField))) == null) break;
            this.addFlattenableField(nextLevelArrayField);
            docMD = fieldMD.getChildMetaData();
        }
    }

    private ArrayFieldValues addFlattenableField(String fieldName) {
        this.m_flattenableLevelFields.add(fieldName);
        return this.getOrCreateCachedFieldValues(fieldName);
    }

    private MDbMetaData.DocumentsMetaData getDocumentsMetaData() {
        return this.m_rsMetaData.getDocumentsMetaData();
    }

    private MDbMetaData.FieldMetaData getFieldMetaData(String fieldName) {
        MDbMetaData.FieldMetaData fieldMD = this.m_rsMetaData.getColumnMetaData(fieldName);
        if (fieldMD == null && (fieldMD = this.m_intermediateFieldMDs.get(fieldName)) == null) {
            fieldMD = MDbMetaData.findFieldByFullName(fieldName, this.getDocumentsMetaData());
            this.m_intermediateFieldMDs.put(fieldName, fieldMD);
        }
        return fieldMD;
    }

    private boolean isFlattenableTopLevelScalarArrayField(MDbMetaData.FieldMetaData fieldMD) {
        if (fieldMD == null || fieldMD.isChildField()) {
            return false;
        }
        if (!fieldMD.isArrayOfScalarValues()) {
            return false;
        }
        return this.isFlattenableLevelField(fieldMD.getFullName());
    }

    private boolean isFlattenableLevelField(String fieldFullName) {
        return this.m_flattenableLevelFields != null && this.m_flattenableLevelFields.contains(fieldFullName);
    }

    private boolean isFlattenableNestedField(MDbMetaData.FieldMetaData fieldMd) {
        if (this.isFlattenableLevelField(fieldMd.getFullName())) {
            return true;
        }
        return MDbMetaData.isFlattenableNestedField(fieldMd, this.getDocumentsMetaData());
    }

    private ArrayFieldValues getOrCreateCachedFieldValues(String arrayAncestorName) {
        return this.doGetCachedFieldValues(arrayAncestorName, false);
    }

    private ArrayFieldValues getCachedFieldValues(String arrayAncestorName) {
        return this.doGetCachedFieldValues(arrayAncestorName, true);
    }

    private ArrayFieldValues doGetCachedFieldValues(String arrayAncestorName, boolean ifExists) {
        if (arrayAncestorName == null) {
            return null;
        }
        ArrayFieldValues existingValue = this.m_nestedValues.get(arrayAncestorName);
        if (ifExists || existingValue != null) {
            return existingValue;
        }
        return this.createCachedFieldValues(arrayAncestorName);
    }

    private ArrayFieldValues createCachedFieldValues(String arrayAncestorName) {
        ArrayFieldValues newFieldValues = new ArrayFieldValues(arrayAncestorName);
        this.m_nestedValues.put(arrayAncestorName, newFieldValues);
        return newFieldValues;
    }

    public Object getFieldValue(String fieldName, DBObject currentRow) throws OdaException {
        MDbMetaData.FieldMetaData fieldMD = this.getFieldMetaData(fieldName);
        if (fieldMD == null) {
            throw new OdaException(Messages.bind((String)Messages.resultDataHandler_invalidFieldName, (Object)fieldName));
        }
        if (this.isFlattenableTopLevelScalarArrayField(fieldMD)) {
            ArrayFieldValues fieldValues = this.getOrCreateCachedFieldValues(fieldName);
            if (!fieldValues.hasFieldValue(fieldName)) {
                Object value = currentRow.get(fieldName);
                fieldValues.addFieldValue(fieldName, value, true);
                if (ResultDataHandler.getLogger().isLoggable(Level.FINEST)) {
                    ResultDataHandler.getLogger().finest(Messages.bind((String)">> Cached array values for top-level field {0}:\n {1}", (Object)fieldName, (Object)value));
                }
            }
            Object flattenedValue = fieldValues.getCurrentValue(fieldName);
            return flattenedValue;
        }
        DBObject containerDoc = this.getContainerDocument(fieldName, fieldMD, currentRow);
        if (containerDoc == NULL_VALUE_FIELD) {
            return null;
        }
        if (containerDoc == null) {
            ArrayFieldValues cachedValues = this.getCachedFieldValues(TOP_LEVEL_PARENT);
            if (cachedValues.hasFieldValue(fieldName)) {
                return cachedValues.getFieldValue(fieldName);
            }
            Object value = ResultDataHandler.fetchFieldValues(fieldName, fieldMD, currentRow);
            cachedValues.addFieldValue(fieldName, value, false);
            if (ResultDataHandler.getLogger().isLoggable(Level.FINEST)) {
                ResultDataHandler.getLogger().finest(Messages.bind((String)">> Cached non-flattened values for top-level field {0}:\n {1}", (Object)fieldName, (Object)value));
            }
            return value;
        }
        if (this.isFlattenableLevelField(fieldName)) {
            return containerDoc;
        }
        Object value = null;
        try {
            value = this.getSubFieldValues(fieldName, fieldMD, containerDoc);
        }
        catch (Exception ex) {
            ResultDataHandler.getLogger().log(Level.SEVERE, Messages.bind((String)"Unable to get field value of {0} from document: ({1}).", (Object)fieldMD.getFullName(), (Object)containerDoc), ex);
            throw new OdaException((Throwable)ex);
        }
        return value;
    }

    private DBObject getContainerDocument(String fieldFullName, MDbMetaData.FieldMetaData fieldMD, DBObject documentObj) {
        if (this.m_currentContainingDocs.containsKey(fieldFullName)) {
            return this.m_currentContainingDocs.get(fieldFullName);
        }
        DBObject containingDoc = this.doGetContainerDocument(fieldFullName, fieldMD, documentObj, null);
        this.m_currentContainingDocs.put(fieldFullName, containingDoc);
        return containingDoc;
    }

    private DBObject doGetContainerDocument(String fieldFullName, MDbMetaData.FieldMetaData fieldMD, DBObject documentObj, String priorLevelName) {
        String[] fieldLevelNames;
        String[] stringArray = fieldLevelNames = fieldMD != null ? fieldMD.getLevelNames() : MDbMetaData.splitFieldName(fieldFullName);
        if (fieldLevelNames.length == 0) {
            return documentObj;
        }
        String firstLevelName = fieldLevelNames[0];
        String levelFullName = priorLevelName != null ? String.valueOf(priorLevelName) + "." + firstLevelName : firstLevelName;
        DBObject currentContainerDoc = null;
        if (!this.m_currentContainingDocs.containsKey(levelFullName)) {
            MDbMetaData.FieldMetaData firstLevelMD;
            MDbMetaData.FieldMetaData fieldMetaData = firstLevelMD = levelFullName.equals(fieldFullName) && fieldMD != null ? fieldMD : this.getFieldMetaData(levelFullName);
            if (ResultDataHandler.getLogger().isLoggable(Level.FINEST)) {
                ResultDataHandler.getLogger().finest(Messages.bind((String)">> FieldFullName= {0}, priorLevelName= {1},\n fieldMetaData= <{2}>,\n documentObj= {3}", (Object[])new Object[]{fieldFullName, priorLevelName, fieldMD, documentObj}));
                ResultDataHandler.getLogger().finest(Messages.bind((String)" firstLevelName= {0}, levelFullName= {1},\n firstLevelMD= <{2}>", (Object[])new Object[]{firstLevelName, levelFullName, firstLevelMD}));
            }
            if (firstLevelMD == null) {
                return documentObj;
            }
            if (!firstLevelMD.hasChildDocuments()) {
                return documentObj;
            }
            if (!this.isFlattenableNestedField(firstLevelMD)) {
                return null;
            }
            if (fieldLevelNames.length == 1 && !this.isFlattenableLevelField(levelFullName)) {
                return documentObj;
            }
            ArrayFieldValues firstLevelValues = this.getOrCreateCachedFieldValues(levelFullName);
            if (!firstLevelValues.hasContainerDocs()) {
                Object value = documentObj.get(firstLevelName);
                DBObject firstLevelDocs = value != null ? ResultDataHandler.fetchFieldDocument(value) : NULL_VALUE_FIELD;
                firstLevelValues.addContainerDocs(firstLevelDocs);
                if (ResultDataHandler.getLogger().isLoggable(Level.FINEST)) {
                    ResultDataHandler.getLogger().finest(Messages.bind((String)">> Cached container documents for {0}:\n {1}", (Object)levelFullName, (Object)firstLevelDocs));
                }
            }
            currentContainerDoc = firstLevelValues.getCurrentContainerDoc();
            this.m_currentContainingDocs.put(levelFullName, currentContainerDoc);
        }
        if ((currentContainerDoc = this.m_currentContainingDocs.get(levelFullName)) == null || currentContainerDoc == NULL_VALUE_FIELD) {
            return currentContainerDoc;
        }
        if (fieldLevelNames.length == 1) {
            return currentContainerDoc;
        }
        String childFullName = MDbMetaData.stripParentName(fieldFullName, firstLevelName);
        return this.doGetContainerDocument(childFullName, null, currentContainerDoc, levelFullName);
    }

    public boolean next() throws OdaException {
        int level = this.m_flattenableLevelFields.size();
        while (level >= 1) {
            String levelFieldName = this.m_flattenableLevelFields.get(level - 1);
            this.clearCurrentDocsOf(levelFieldName);
            ArrayFieldValues cachedFieldValues = this.getCachedFieldValues(levelFieldName);
            if (cachedFieldValues != null && cachedFieldValues.next()) {
                return true;
            }
            cachedFieldValues.clearContainerDocs();
            --level;
        }
        for (ArrayFieldValues nestedLevelValues : this.m_nestedValues.values()) {
            nestedLevelValues.clear();
        }
        if (!this.m_currentContainingDocs.isEmpty()) {
            this.m_currentContainingDocs.clear();
        }
        return false;
    }

    private void clearCurrentDocsOf(String containerFieldName) {
        if (this.m_currentContainingDocs.isEmpty() || TOP_LEVEL_PARENT.equals(containerFieldName)) {
            return;
        }
        this.m_currentContainingDocs.remove(containerFieldName);
        String parentPrefix = String.valueOf(containerFieldName) + ".";
        HashSet<String> cachedFieldNames = new HashSet<String>(this.m_currentContainingDocs.keySet());
        for (String fieldName : cachedFieldNames) {
            if (!fieldName.startsWith(parentPrefix)) continue;
            this.m_currentContainingDocs.remove(fieldName);
        }
    }

    static DBObject fetchFieldDocument(Object fieldValue) {
        return ResultDataHandler.fetchFieldDocument(fieldValue, (byte)6);
    }

    static DBObject fetchFieldDocument(Object fieldValue, byte fieldNativeDataType) {
        if (fieldNativeDataType == 6) {
            fieldNativeDataType = Bytes.getType((Object)fieldValue);
        }
        if (fieldNativeDataType == 4) {
            if (!(fieldValue instanceof List)) {
                return null;
            }
            BasicDBList dbObjsList = new BasicDBList();
            for (Object valueInList : (List)fieldValue) {
                DBObject listElementObj = ResultDataHandler.fetchFieldDocument(valueInList);
                if (listElementObj == null) {
                    return null;
                }
                if (listElementObj instanceof List) {
                    dbObjsList.addAll((Collection)((List)listElementObj));
                    continue;
                }
                dbObjsList.add((Object)listElementObj);
            }
            return dbObjsList;
        }
        DBObject fieldObjValue = null;
        if (fieldNativeDataType == 3) {
            if (fieldValue instanceof DBObject) {
                fieldObjValue = (DBObject)fieldValue;
            } else if (fieldValue instanceof DBRefBase) {
                try {
                    fieldObjValue = ((DBRefBase)fieldValue).fetch();
                }
                catch (Exception exception) {
                    ResultDataHandler.getLogger().log(Level.INFO, "Ignoring error in fetching a DBRefBase object.");
                }
            }
        }
        return fieldObjValue;
    }

    public static Object fetchFieldValues(String fieldFullName, DBObject documentObj) {
        return ResultDataHandler.fetchFieldValues(fieldFullName, null, documentObj);
    }

    public static Object fetchFieldValues(String fieldFullName, MDbMetaData.FieldMetaData fieldMD, DBObject documentObj) {
        String[] fieldLevelNames;
        if (documentObj instanceof BasicDBList) {
            return ResultDataHandler.fetchFieldValuesFromList(fieldFullName, (BasicDBList)documentObj);
        }
        String[] stringArray = fieldLevelNames = fieldMD != null ? fieldMD.getLevelNames() : MDbMetaData.splitFieldName(fieldFullName);
        if (fieldLevelNames.length == 0) {
            return null;
        }
        Object value = documentObj.get(fieldLevelNames[0]);
        if (value == null) {
            return null;
        }
        DBObject fieldDoc = ResultDataHandler.fetchFieldDocument(value);
        if (fieldLevelNames.length == 1) {
            return fieldDoc != null ? fieldDoc : value;
        }
        if (fieldDoc == null) {
            ResultDataHandler.getLogger().log(Level.INFO, Messages.bind((String)"The nested field ({0}) has no parent document.", (Object)fieldFullName));
            return value;
        }
        String childFullName = MDbMetaData.stripParentName(fieldFullName, fieldLevelNames[0]);
        return ResultDataHandler.fetchFieldValues(childFullName, fieldDoc);
    }

    private static BasicDBList fetchFieldValuesFromList(String fieldFullName, BasicDBList fromDBList) {
        if (fromDBList == null || fromDBList.size() == 0) {
            return null;
        }
        BasicDBList fieldValuesList = new BasicDBList();
        if (fromDBList.isPartialObject()) {
            fieldValuesList.markAsPartialObject();
        }
        int index = 0;
        while (index < fromDBList.size()) {
            Object listElementObj = fromDBList.get(String.valueOf(index));
            if (listElementObj instanceof DBObject) {
                listElementObj = ResultDataHandler.fetchFieldValues(fieldFullName, (DBObject)listElementObj);
            }
            fieldValuesList.put(index, listElementObj);
            ++index;
        }
        for (Object elementValue : fieldValuesList.toMap().values()) {
            if (elementValue == null) continue;
            return fieldValuesList;
        }
        return null;
    }

    private Object getSubFieldValues(String fieldFullName, MDbMetaData.FieldMetaData fieldMD, DBObject documentObj) {
        String[] fieldLevelNames;
        String[] stringArray = fieldLevelNames = fieldMD != null ? fieldMD.getLevelNames() : MDbMetaData.splitFieldName(fieldFullName);
        if (fieldLevelNames.length == 1) {
            String fieldSimpleName = fieldMD != null ? fieldMD.getSimpleName() : fieldLevelNames[0];
            return documentObj.get(fieldSimpleName);
        }
        if (fieldLevelNames.length == 2) {
            return documentObj.get(fieldLevelNames[1]);
        }
        int i = fieldLevelNames.length - 2;
        while (i >= 0) {
            String ancestorFullName = MDbMetaData.formatFieldLevelNames(fieldLevelNames, 0, i);
            if (this.isFlattenableLevelField(ancestorFullName)) {
                String childLevelName = MDbMetaData.formatFieldLevelNames(fieldLevelNames, i + 1, fieldLevelNames.length - 1);
                return ResultDataHandler.fetchFieldValues(childLevelName, documentObj);
            }
            --i;
        }
        return documentObj;
    }

    private static Logger getLogger() {
        return sm_logger;
    }
}

