/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.math.BigDecimal;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementDetailHandle;
import org.eclipse.birt.report.model.api.elements.structures.FormatValue;
import org.eclipse.birt.report.model.metadata.ColorPropertyType;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.util.ModelUtil;

public class FactoryPropertyHandle
extends ElementDetailHandle {
    protected ElementPropertyDefn propDefn;
    protected Object value = null;

    public FactoryPropertyHandle(DesignElementHandle element, ElementPropertyDefn prop) {
        super(element);
        this.propDefn = prop;
        this.value = element.getElement().getFactoryProperty(element.getModule(), this.propDefn);
    }

    public Object getValue() {
        return ModelUtil.wrapPropertyValue(this.getModule(), this.propDefn, this.value);
    }

    public boolean isStyleProperty() {
        return this.propDefn.isStyleProperty();
    }

    public boolean isSet() {
        return this.value != null;
    }

    public int getIntValue() {
        return this.propDefn.getIntValue(this.getModule(), this.value);
    }

    public String getStringValue() {
        if (this.value instanceof FormatValue) {
            FormatValue formatValue = (FormatValue)this.value;
            return formatValue.getPattern();
        }
        return this.propDefn.getStringValue(this.getModule(), this.value);
    }

    public double getFloatValue() {
        return this.propDefn.getFloatValue(this.getModule(), this.value);
    }

    public BigDecimal getNumberValue() {
        return this.propDefn.getNumberValue(this.getModule(), this.value);
    }

    public boolean getBooleanValue() {
        return this.propDefn.getBooleanValue(this.getModule(), this.value);
    }

    public String getColorValue() {
        PropertyType type = this.propDefn.getType();
        if (type.getTypeCode() == 4) {
            return ((ColorPropertyType)type).toCssColor(this.getModule(), this.value);
        }
        return null;
    }
}

