/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements.structures;

import java.util.List;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.JoinConditionHandle;
import org.eclipse.birt.report.model.api.SimpleValueHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.metadata.ElementRefValue;

public class JoinCondition
extends Structure {
    public static final String STRUCTURE_NAME = "JoinCondition";
    public static final String JOIN_TYPE_MEMBER = "joinType";
    public static final String JOIN_OPERATOR_MEMBER = "joinOperator";
    public static final String LEFT_DATASET_MEMBER = "leftDataSet";
    public static final String RIGHT_DATASET_MEMBER = "rightDataSet";
    public static final String LEFT_EXPRESSION_MEMBER = "leftExpression";
    public static final String RIGHT_EXPRESSION_MEMBER = "rightExpression";
    protected String joinType = null;
    protected String joinOperator = null;
    protected String leftDataSet = null;
    protected String rightDataSet = null;
    protected Expression leftExpression = null;
    protected Expression rightExpression = null;

    @Override
    public String getStructName() {
        return STRUCTURE_NAME;
    }

    @Override
    protected Object getIntrinsicProperty(String propName) {
        if (JOIN_TYPE_MEMBER.equals(propName)) {
            return this.joinType;
        }
        if (JOIN_OPERATOR_MEMBER.equals(propName)) {
            return this.joinOperator;
        }
        if (LEFT_DATASET_MEMBER.equals(propName)) {
            return this.leftDataSet;
        }
        if (RIGHT_DATASET_MEMBER.equals(propName)) {
            return this.rightDataSet;
        }
        if (LEFT_EXPRESSION_MEMBER.equals(propName)) {
            return this.leftExpression;
        }
        if (RIGHT_EXPRESSION_MEMBER.equals(propName)) {
            return this.rightExpression;
        }
        assert (false);
        return null;
    }

    @Override
    protected void setIntrinsicProperty(String propName, Object value) {
        if (JOIN_TYPE_MEMBER.equals(propName)) {
            this.joinType = (String)value;
        } else if (JOIN_OPERATOR_MEMBER.equals(propName)) {
            this.joinOperator = (String)value;
        } else if (LEFT_DATASET_MEMBER.equals(propName)) {
            this.leftDataSet = (String)value;
        } else if (RIGHT_DATASET_MEMBER.equals(propName)) {
            this.rightDataSet = (String)value;
        } else if (LEFT_EXPRESSION_MEMBER.equals(propName)) {
            this.leftExpression = (Expression)value;
        } else if (RIGHT_EXPRESSION_MEMBER.equals(propName)) {
            this.rightExpression = (Expression)value;
        } else assert (false);
    }

    public void setJoinType(String type) {
        this.setProperty(JOIN_TYPE_MEMBER, (Object)type);
    }

    public String getJoinType() {
        return (String)this.getProperty(null, JOIN_TYPE_MEMBER);
    }

    public void setOperator(String operator) {
        this.setProperty(JOIN_OPERATOR_MEMBER, (Object)operator);
    }

    public String getOperator() {
        return (String)this.getProperty(null, JOIN_OPERATOR_MEMBER);
    }

    public void setLeftDataSet(String leftDataSet) {
        this.setProperty(LEFT_DATASET_MEMBER, (Object)leftDataSet);
    }

    public String getLeftDataSet() {
        return (String)this.getProperty(null, LEFT_DATASET_MEMBER);
    }

    public void setRightDataSet(String rightDataSet) {
        this.setProperty(RIGHT_DATASET_MEMBER, (Object)rightDataSet);
    }

    public String getRightDataSet() {
        return (String)this.getProperty(null, RIGHT_DATASET_MEMBER);
    }

    public void setLeftExpression(String leftExpression) {
        this.setProperty(LEFT_EXPRESSION_MEMBER, (Object)leftExpression);
    }

    public String getLeftExpression() {
        return this.getStringProperty(null, LEFT_EXPRESSION_MEMBER);
    }

    public void setRightExpression(String rightExpression) {
        this.setProperty(RIGHT_EXPRESSION_MEMBER, (Object)rightExpression);
    }

    public String getRightExpression() {
        return this.getStringProperty(null, RIGHT_EXPRESSION_MEMBER);
    }

    @Override
    public StructureHandle handle(SimpleValueHandle valueHandle, int index) {
        return new JoinConditionHandle(valueHandle, index);
    }

    public List validate(Module module, DesignElement element) {
        List<SemanticException> list = super.validate(module, element);
        this.checkStringMember(this.joinType, JOIN_TYPE_MEMBER, element, list);
        this.checkStringMember(this.joinOperator, JOIN_OPERATOR_MEMBER, element, list);
        this.checkStringMember(this.leftDataSet, LEFT_DATASET_MEMBER, element, list);
        this.checkStringMember(this.rightDataSet, RIGHT_DATASET_MEMBER, element, list);
        this.checkStringMember(this.leftExpression == null ? null : this.leftExpression.getStringExpression(), LEFT_EXPRESSION_MEMBER, element, list);
        this.checkStringMember(this.rightExpression == null ? null : this.rightExpression.getStringExpression(), RIGHT_EXPRESSION_MEMBER, element, list);
        this.checkDataSet(module, this.leftDataSet, list, element);
        this.checkDataSet(module, this.rightDataSet, list, element);
        return list;
    }

    private void checkDataSet(Module module, String dataSetName, List errors, DesignElement element) {
        if (dataSetName == null) {
            return;
        }
        List dataSetsReferences = (List)element.getProperty(module, "dataSets");
        if (dataSetsReferences != null) {
            int dataSetIndex = 0;
            while (dataSetIndex < dataSetsReferences.size()) {
                if (((ElementRefValue)dataSetsReferences.get(dataSetIndex)).getQualifiedReference().equals(dataSetName)) {
                    return;
                }
                ++dataSetIndex;
            }
        }
        errors.add(new SemanticError(element, new String[]{element.getFullName(), dataSetName}, "Error.SemanticError.DATA_SET_MISSED_IN_JOINT_DATA_SET"));
    }
}

