/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui;

import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.osgi.framework.Bundle;

public class Templates {
    static final String TEMPLATE_PROPERTIES = "template.properties";
    static final String TEMPLATE_LOCATION = "/templates/";
    static final String DEFAULT_ENCODING = "UTF-8";
    @Deprecated
    static final String BPEL_FILE_EXTENSION = ".bpel";
    static final String BUNDLE_DIRECTORY = "/";
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_KEY = "key";
    public static final String TEMPLATE_KEY_ASYNC = "async";
    public static final String TEMPLATE_KEY_SYNC = "sync";
    public static final String TEMPLATE_KEY_EMPTY = "empty";
    public static final String PROPERTY_ENCODING = "encoding";
    public static final String PROPERTY_DESCRIPTION = "description";
    static final String EMPTY = "";
    static final String[] EMPTY_NAMES = new String[0];
    Set<String> mNamespaceNames = new TreeSet<String>();
    Map<String, Template> mTemplateByName = new TreeMap<String, Template>();
    Map<String, Template> mTemplateByKey = new HashMap<String, Template>();

    public void initializeFrom(Bundle bundle) {
        this.initializeFrom(bundle, TEMPLATE_LOCATION);
    }

    public void initializeFrom(String templateLocation) {
        this.initializeFrom(BPELUIPlugin.INSTANCE.getBundle(), templateLocation);
    }

    /*
     * Unable to fully structure code
     */
    public void initializeFrom(Bundle bundle, String templateLocation) {
        list = bundle.getEntryPaths(templateLocation);
        if (list != null) ** GOTO lbl67
        return;
lbl-1000:
        // 1 sources

        {
            nextRoot = (String)list.nextElement();
            if (!nextRoot.endsWith("/") || (nextURL = bundle.getEntry(nextEntry = String.valueOf(nextRoot) + "template.properties")) == null) continue;
            props = new Properties();
            is = null;
            try {
                try {
                    is = nextURL.openStream();
                    props.load(is);
                }
                catch (IOException e) {
                    BPELUIPlugin.log(e);
                    try {
                        is.close();
                    }
                    catch (Throwable v0) {}
                    continue;
                }
            }
            catch (Throwable var10_12) {
                try {
                    is.close();
                }
                catch (Throwable v1) {}
                throw var10_12;
            }
            try {
                is.close();
            }
            catch (Throwable v2) {}
            name = props.getProperty("name");
            if (name == null) continue;
            enc = props.getProperty("encoding", "UTF-8");
            desc = props.getProperty("description", "");
            this.mNamespaceNames.addAll(this.findProperties(props, "namespace.{0}"));
            template = new Template();
            template.mName = name;
            template.mDescription = desc;
            template.mProperties = props;
            this.mTemplateByName.put(name, template);
            id = props.getProperty("key");
            if (id != null) {
                template.mKey = id;
                this.mTemplateByKey.put(id, template);
            }
            hole = 3;
            i = 0;
            while (hole >= 0) {
                key = MessageFormat.format("resource.{0}", new Object[]{i});
                resourceName = props.getProperty(key);
                if (resourceName == null) {
                    --hole;
                } else {
                    hole = 3;
                    key = MessageFormat.format("resource.{0}.name", new Object[]{i});
                    nameTemplate = props.getProperty(key);
                    entryLoc = String.valueOf(nextRoot) + resourceName;
                    resource = new TemplateResource();
                    resource.mName = resourceName;
                    resource.mContent = this.slurpContent(bundle.getEntry(entryLoc), enc);
                    resource.mNameTemplate = nameTemplate;
                    template.add(resource);
                }
                ++i;
            }
lbl67:
            // 6 sources

            ** while (list.hasMoreElements())
        }
lbl68:
        // 1 sources

    }

    String slurpContent(URL loc, String enc) {
        StringBuilder sb;
        block13: {
            if (loc == null) {
                return null;
            }
            sb = new StringBuilder(2096);
            char[] buf = new char[256];
            InputStreamReader isr = null;
            try {
                try {
                    int cnt;
                    isr = new InputStreamReader(loc.openStream(), enc);
                    while ((cnt = isr.read(buf)) >= 0) {
                        sb.append(buf, 0, cnt);
                    }
                }
                catch (Exception ex) {
                    BPELUIPlugin.log(ex);
                    try {
                        isr.close();
                    }
                    catch (Throwable throwable) {}
                    break block13;
                }
            }
            catch (Throwable throwable) {
                try {
                    isr.close();
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                isr.close();
            }
            catch (Throwable throwable) {}
        }
        return sb.toString();
    }

    List<String> findProperties(Properties props, String pattern) {
        ArrayList<String> list = new ArrayList<String>();
        int hole = 3;
        int i = 0;
        while (hole >= 0) {
            String key = MessageFormat.format(pattern, i);
            String val = props.getProperty(key, null);
            if (val != null) {
                list.add(val);
                hole = 3;
            } else {
                --hole;
            }
            ++i;
        }
        return list;
    }

    public Template getTemplateByKey(String key) {
        return this.mTemplateByKey.get(key);
    }

    public Template getTemplateByName(String name) {
        return this.mTemplateByName.get(name);
    }

    public String[] getNamespaceNames() {
        return this.mNamespaceNames.toArray(EMPTY_NAMES);
    }

    public String[] getTemplateNames() {
        return this.mTemplateByName.keySet().toArray(EMPTY_NAMES);
    }

    public class Template {
        String mKey;
        String mName;
        String mDescription;
        Map<String, String> mProperties;
        List<TemplateResource> mResources = new ArrayList<TemplateResource>();

        public String getName() {
            return this.mName;
        }

        public String getKey() {
            return this.mKey;
        }

        void add(TemplateResource resource) {
            this.mResources.add(resource);
            resource.mTemplate = this;
        }

        public List<TemplateResource> getResources() {
            return this.mResources;
        }

        public String getDescription() {
            return this.mDescription;
        }

        public String getProperty(String key) {
            return this.mProperties.get(key);
        }

        TemplateResource lookupResource(String name) {
            String name2 = this.mProperties.get(name);
            for (TemplateResource resource : this.mResources) {
                if (name.equals(resource.mName)) {
                    return resource;
                }
                if (name2 == null || !name2.equals(resource.mName)) continue;
                return resource;
            }
            return null;
        }
    }

    public class TemplateResource {
        Template mTemplate = null;
        String mName;
        String mContent;
        String mNameTemplate;

        public String getContent() {
            return this.mContent;
        }

        public String getName() {
            return this.mName;
        }

        public String process(Map<String, Object> args) {
            return this.process(this.mContent, args);
        }

        String process(String src, Map<String, Object> args) {
            int openReplace;
            if (src == null) {
                return Templates.EMPTY;
            }
            int start = src.indexOf("</definitions>");
            if (start > 0) {
                StringBuffer ss = new StringBuffer(src.substring(0, start));
                Object key = args.get(Templates.PROPERTY_KEY);
                String protocol = (String)args.get("protocol");
                if (protocol != null) {
                    protocol = protocol.toLowerCase();
                }
                if (Templates.TEMPLATE_KEY_ASYNC.equals(key)) {
                    if ("soap".equals(protocol)) {
                        ss.append("\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     BINDING DEFINITION - Defines the message format and protocol details\n     for a web service.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <binding name=\"${processName}Binding\" type=\"tns:${processName}\">\n        <soap:binding style=\"document\"\n    \t\ttransport=\"http://schemas.xmlsoap.org/soap/http\"/>\n        <operation name=\"initiate\">\n            <soap:operation\n    \t\t\tsoapAction=\"${namespace}/initiate\"/>\n            <input>\n                <soap:body use=\"literal\"/>\n            </input>\n        </operation>\n    </binding>\n\n    <binding name=\"${processName}CallbackBinding\" type=\"tns:${processName}Callback\">\n        <soap:binding style=\"document\" transport=\"http://schemas.xmlsoap.org/soap/http\"/>\n        <operation name=\"onResult\">\n            <soap:operation\n    \t\t\tsoapAction=\"${namespace}/onResult\"/>\n            <input>\n                <soap:body use=\"literal\"/>\n            </input>\n        </operation>\n    </binding>\n\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     SERVICE DEFINITION - A service groups a set of ports into\n     a service unit.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <service name=\"${serviceName}\">\n        <port name=\"${portName}\" binding=\"tns:${processName}Binding\">\n    \t\t<soap:address location=\"${address}\"/>\n        </port>\n    </service>\n\n    <service name=\"${serviceName}Callback\">\n        <port name=\"${portName}CallbackPort\" binding=\"tns:${processName}CallbackBinding\">\n    \t\t<soap:address location=\"${address}Callback\"/>\n        </port>\n    </service>\n");
                    } else {
                        ss.append("\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     BINDING DEFINITION - Defines the message format and protocol details\n     for a web service.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <binding name=\"${processName}Binding\" type=\"tns:${processName}\" xmlns:mime=\"http://schemas.xmlsoap.org/wsdl/mime/\">\n    \t<http:binding verb=\"POST\" />\n    \t<operation name=\"initiate\">\n    \t\t<http:operation location=\"/initiate\" />\n    \t\t<input>\n    \t\t\t<mime:content type=\"text/xml\"  part=\"payload\"/>\n    \t\t</input>\n    \t</operation>\n    </binding>\n\n    <binding name=\"${processName}CallbackBinding\" type=\"tns:${processName}Callback\" xmlns:mime=\"http://schemas.xmlsoap.org/wsdl/mime/\">\n    \t<http:binding verb=\"POST\" />\n    \t<operation name=\"onResult\">\n    \t\t<http:operation location=\"/onResult\" />\n    \t\t<input>\n    \t\t\t<mime:content type=\"text/xml\" part=\"payload\"/>\n    \t\t</input>\n    \t</operation>\n    </binding>\n\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     SERVICE DEFINITION - A service groups a set of ports into\n     a service unit.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <service name=\"${serviceName}\">\n        <port name=\"${portName}\" binding=\"tns:${processName}Binding\">\n    \t\t<http:address location=\"${address}\"/>\n        </port>\n    </service>\n\n    <service name=\"${serviceName}Callback\">\n        <port name=\"${portName}CallbackPort\" binding=\"tns:${processName}CallbackBinding\">\n    \t\t<http:address location=\"${address}Callback\"/>\n        </port>\n    </service>\n");
                    }
                } else if (Templates.TEMPLATE_KEY_SYNC.equals(key)) {
                    if ("soap".equals(protocol)) {
                        ss.append("\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     BINDING DEFINITION - Defines the message format and protocol details\n     for a web service.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <binding name=\"${processName}Binding\" type=\"tns:${processName}\">\n    \t<soap:binding style=\"document\"\n    \t\ttransport=\"http://schemas.xmlsoap.org/soap/http\" />\n    \t<operation name=\"process\">\n    \t\t<soap:operation\n    \t\t\tsoapAction=\"${namespace}/process\" />\n    \t\t<input>\n    \t\t\t<soap:body use=\"literal\" />\n    \t\t</input>\n    \t\t<output>\n    \t\t\t<soap:body use=\"literal\" />\n    \t\t</output>\n    \t</operation>\n    </binding>\n\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     SERVICE DEFINITION - A service groups a set of ports into\n     a service unit.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <service name=\"${serviceName}\">\n    \t<port name=\"${portName}\" binding=\"tns:${processName}Binding\">\n    \t\t<soap:address location=\"${address}\" />\n    \t</port>\n    </service>\n");
                    } else {
                        ss.append("\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     BINDING DEFINITION - Defines the message format and protocol details\n     for a web service.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <binding name=\"${processName}Binding\" type=\"tns:${processName}\" xmlns:mime=\"http://schemas.xmlsoap.org/wsdl/mime/\">\n    \t<http:binding verb=\"POST\" />\n    \t<operation name=\"process\">\n    \t\t<http:operation location=\"/process\" />\n    \t\t<input>\n    \t\t\t<mime:content type=\"text/xml\"  part=\"payload\"/>\n    \t\t</input>\n    \t\t<output>\n    \t\t\t<mime:content type=\"text/xml\"  part=\"payload\"/>\n    \t\t</output>\n    \t</operation>\n    </binding>\n\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     SERVICE DEFINITION - A service groups a set of ports into\n     a service unit.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <service name=\"${serviceName}\">\n    \t<port name=\"${portName}\" binding=\"tns:${processName}Binding\">\n            <http:address location=\"${address}\"/>\n        </port>\n    </service>\n");
                    }
                } else if (Templates.TEMPLATE_KEY_EMPTY.equals(key)) {
                    ss.append("\n<!-- ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n     SERVICE DEFINITION - A service groups a set of ports into\n     a service unit.\n     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ -->\n    <service name=\"${serviceName}\">\n    </service>\n");
                }
                ss.append("</definitions>");
                src = ss.toString();
            }
            StringBuilder sb = new StringBuilder(src.length());
            int cursor = 0;
            while ((openReplace = src.indexOf("${", cursor)) >= 0) {
                sb.append(src.substring(cursor, openReplace));
                cursor = openReplace + 2;
                int closeReplace = src.indexOf("}", cursor);
                if (closeReplace < 0) {
                    return sb.toString();
                }
                String expr = src.substring(cursor, closeReplace).trim();
                sb.append(this.lookup(expr, args));
                cursor = closeReplace + 1;
            }
            sb.append(src.substring(cursor));
            return sb.toString();
        }

        Object lookup(String key, Map<String, Object> args) {
            Object value = null;
            TemplateResource r = null;
            if (key.startsWith(":include:")) {
                r = this.mTemplate.lookupResource(key = key.substring(9));
                if (r != null) {
                    value = r.mContent;
                }
            } else if (key.startsWith(":parse:")) {
                r = this.mTemplate.lookupResource(key = key.substring(7));
                if (r != null && r != this) {
                    value = r.process(args);
                }
            } else {
                value = args.get(key);
                if (value == null) {
                    value = this.mTemplate.mProperties.get(key);
                }
            }
            return value;
        }

        public String getName(Map<String, Object> args) {
            if (this.mNameTemplate == null) {
                return this.mName;
            }
            return this.process(this.mNameTemplate, args);
        }

        public boolean isProcess() {
            return this.mName.endsWith(Templates.BPEL_FILE_EXTENSION);
        }
    }
}

