/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.adapters;

import java.util.List;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.CompensationHandler;
import org.eclipse.bpel.model.FaultHandler;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.PartnerLink;
import org.eclipse.bpel.model.Variable;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.ui.actions.editpart.AbstractAction;
import org.eclipse.bpel.ui.actions.editpart.SetPartnerLinkAction;
import org.eclipse.bpel.ui.actions.editpart.SetVariableAction;
import org.eclipse.bpel.ui.adapters.AnnotationHelper;
import org.eclipse.bpel.ui.adapters.ContainerActivityAdapter;
import org.eclipse.bpel.ui.adapters.IAnnotatedElement;
import org.eclipse.bpel.ui.adapters.ICompensationHandlerHolder;
import org.eclipse.bpel.ui.adapters.IContainer;
import org.eclipse.bpel.ui.adapters.IFaultHandlerHolder;
import org.eclipse.bpel.ui.adapters.IOutlineEditPartFactory;
import org.eclipse.bpel.ui.adapters.Messages;
import org.eclipse.bpel.ui.adapters.delegates.MultiContainer;
import org.eclipse.bpel.ui.adapters.delegates.ReferenceContainer;
import org.eclipse.bpel.ui.editparts.InvokeEditPart;
import org.eclipse.bpel.ui.editparts.OutlineTreeEditPart;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.wst.wsdl.Operation;

public class InvokeAdapter
extends ContainerActivityAdapter
implements EditPartFactory,
IOutlineEditPartFactory,
IFaultHandlerHolder,
ICompensationHandlerHolder,
IAnnotatedElement {
    @Override
    public IContainer createContainerDelegate() {
        MultiContainer omc = new MultiContainer();
        omc.add(new ReferenceContainer(BPELPackage.eINSTANCE.getInvoke_FaultHandler()));
        omc.add(new ReferenceContainer(BPELPackage.eINSTANCE.getInvoke_CompensationHandler()));
        return omc;
    }

    @Override
    public EditPart createOutlineEditPart(EditPart context, Object model) {
        OutlineTreeEditPart result = new OutlineTreeEditPart();
        result.setModel(model);
        return result;
    }

    @Override
    public FaultHandler getFaultHandler(Object object) {
        return ((Invoke)object).getFaultHandler();
    }

    @Override
    public void setFaultHandler(Object object, FaultHandler faultHandler) {
        ((Invoke)object).setFaultHandler(faultHandler);
    }

    @Override
    public CompensationHandler getCompensationHandler(Object object) {
        return ((Invoke)object).getCompensationHandler();
    }

    @Override
    public void setCompensationHandler(Object object, CompensationHandler compensationHandler) {
        ((Invoke)object).setCompensationHandler(compensationHandler);
    }

    @Override
    public List<AbstractAction> getEditPartActions(EditPart editPart) {
        List<AbstractAction> actions = super.getEditPartActions(editPart);
        actions.add(new SetPartnerLinkAction(editPart));
        actions.add(new SetVariableAction(editPart, 1));
        actions.add(new SetVariableAction(editPart, 2));
        return actions;
    }

    @Override
    public EditPart createEditPart(EditPart context, Object model) {
        InvokeEditPart result = new InvokeEditPart();
        result.setModel(model);
        return result;
    }

    @Override
    public String[] getAnnotation(Object object) {
        PartnerLink pLink = ModelHelper.getPartnerLink(object);
        Operation operation = ModelHelper.getOperation(object);
        Variable inVar = ModelHelper.getVariable(object, 0);
        Variable outVar = ModelHelper.getVariable(object, 1);
        Role myRole = pLink != null ? pLink.getMyRole() : null;
        Role partnerRole = pLink != null ? pLink.getPartnerRole() : null;
        return new String[]{Messages.PARTNER_LINK, AnnotationHelper.getAnnotation(pLink), Messages.OPERATION, AnnotationHelper.getAnnotation(operation), Messages.INPUT, AnnotationHelper.getAnnotation(inVar), Messages.OUTPUT, AnnotationHelper.getAnnotation(outVar), Messages.MY_ROLE, AnnotationHelper.getAnnotation(myRole), Messages.PARTNER_ROLE, AnnotationHelper.getAnnotation(partnerRole)};
    }
}

