/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.util;

import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.adapters.ILabeledElement;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

public class BPELDirectEditManager
extends DirectEditManager {
    private IInputValidator validator;

    public BPELDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, IInputValidator validator) {
        super(source, editorType, locator);
        this.validator = validator;
    }

    protected void commit() {
        Text text;
        String newValue;
        String validationMessage;
        if (this.validator != null && (validationMessage = this.validator.isValid(newValue = (text = (Text)this.getCellEditor().getControl()).getText())) != null) {
            MessageBox dialog = new MessageBox(text.getShell(), 33);
            String message = Messages.BPELEditManager_RenameError;
            dialog.setText(message);
            message = NLS.bind((String)Messages.BPELEditManager_RenameErrorMessage, (Object[])new Object[]{message, validationMessage});
            dialog.setMessage(message);
            dialog.open();
            this.bringDown();
            return;
        }
        super.commit();
    }

    protected void initCellEditor() {
        this.getEditPart().getFigure().validate();
        Object model = this.getEditPart().getModel();
        ILabeledElement labeledElement = BPELUtil.adapt(model, ILabeledElement.class);
        String initialLabelText = labeledElement.getLabel(model);
        this.getCellEditor().setValue((Object)initialLabelText);
        Text text = (Text)this.getCellEditor().getControl();
        text.selectAll();
    }
}

