/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.features.RoutingNet;
import org.eclipse.bpmn2.modeler.core.utils.GraphicsUtil;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.mm.algorithms.styles.Point;
import org.eclipse.graphiti.mm.pictograms.AnchorContainer;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class RouteSolver {
    protected static final IGaService gaService = Graphiti.getGaService();
    protected static final IPeService peService = Graphiti.getPeService();
    static final int topMargin = 50;
    static final int bottomMargin = 50;
    static final int leftMargin = 50;
    static final int rightMargin = 50;
    IFeatureProvider fp;
    List<ContainerShape> allShapes;
    Shape source;
    Shape target;
    int top;
    int left;
    int bottom;
    int right;
    RoutingNet verticalNet;
    RoutingNet horizontalNet;
    private boolean rotate = false;

    public RouteSolver(IFeatureProvider fp, List<ContainerShape> allShapes) {
        this.fp = fp;
        this.allShapes = new ArrayList<ContainerShape>();
        this.allShapes.addAll(allShapes);
        this.initialize();
    }

    public boolean solve(Shape source, Shape target) {
        this.source = source;
        this.target = target;
        this.verticalNet.eraseLanes();
        this.horizontalNet.eraseLanes();
        Point ps = GraphicsUtil.getShapeCenter((AnchorContainer)source);
        Point pt = GraphicsUtil.getShapeCenter((AnchorContainer)target);
        int dx = ps.getX() - pt.getX();
        int dy = ps.getY() - pt.getY();
        if (Math.abs(dy) > Math.abs(dx)) {
            this.verticalNet.findSolutions(source, target);
            this.verticalNet.drawLanes();
        } else {
            this.horizontalNet.findSolutions(source, target);
            this.horizontalNet.drawLanes();
        }
        return true;
    }

    public boolean initialize() {
        if (this.allShapes.size() < 2) {
            return false;
        }
        this.rotate = false;
        this.verticalNet = new RoutingNet(this.fp);
        Rectangle r = this.calculateDiagramBounds();
        this.sortAllShapes();
        this.top = r.y;
        this.left = r.x;
        this.bottom = this.top + r.height;
        this.right = this.left + r.width;
        this.calculateRoutingNet(this.verticalNet);
        this.verticalNet.link();
        this.rotate = true;
        this.horizontalNet = new RoutingNet(this.fp);
        r = this.calculateDiagramBounds();
        this.sortAllShapes();
        this.top = r.y;
        this.left = r.x;
        this.bottom = this.top + r.height;
        this.right = this.left + r.width;
        this.calculateRoutingNet(this.horizontalNet);
        this.horizontalNet.link();
        this.rotate = false;
        return true;
    }

    protected Rectangle calculateDiagramBounds() {
        int left = Integer.MAX_VALUE;
        int right = Integer.MIN_VALUE;
        int top = Integer.MAX_VALUE;
        int bottom = Integer.MIN_VALUE;
        for (ContainerShape s : this.allShapes) {
            int y;
            Rectangle r = this.getBounds(s);
            int x = r.x;
            if (x < left) {
                left = x;
            }
            if ((x = r.right()) > right) {
                right = x;
            }
            if ((y = r.y) < top) {
                top = y;
            }
            if ((y = r.bottom()) <= bottom) continue;
            bottom = y;
        }
        return new Rectangle(left -= 50, top -= 50, (right += 50) - left, (bottom += 50) - top);
    }

    protected void calculateRoutingNet(RoutingNet net) {
        net.add(this.left, this.top, 50, this.bottom - this.top);
        int i = 0;
        while (i < this.allShapes.size()) {
            ContainerShape shape = this.allShapes.get(i);
            GraphicsUtil.debug = GraphicsUtil.getDebugText((PictogramElement)shape).contains("Task_1");
            Rectangle shapeBounds = this.getBounds(shape);
            Slice slice = new Slice(shapeBounds.x, shapeBounds.right());
            List<ContainerShape> below = this.getShapesBelow(shape);
            for (ContainerShape shapeBelow : below) {
                Rectangle shapeBelowBounds = this.getBounds(shapeBelow);
                if (slice.remove(shapeBelowBounds.x, shapeBelowBounds.right()) == 0) break;
            }
            List<Integer> cuts = slice.getCuts();
            int c1 = cuts.get(0);
            int ic = 1;
            while (ic < cuts.size()) {
                int c2 = cuts.get(ic);
                int x = c1;
                int y = shapeBounds.y + shapeBounds.height;
                int w = c2 - c1;
                int h = Integer.MIN_VALUE;
                for (ContainerShape shapeBelow : below) {
                    Rectangle shapeBelowBounds = this.getBounds(shapeBelow);
                    if (shapeBelowBounds.x > c1 || c1 >= shapeBelowBounds.right()) continue;
                    h = shapeBelowBounds.y - shapeBounds.y - shapeBounds.height;
                    break;
                }
                if (h == Integer.MIN_VALUE) {
                    h = this.bottom - shapeBounds.y - shapeBounds.height;
                }
                net.add(x, y, w, h);
                c1 = c2;
                ++ic;
            }
            slice = new Slice(shapeBounds.x, shapeBounds.right());
            List<ContainerShape> above = this.getShapesAbove(shape);
            for (ContainerShape shapeAbove : above) {
                Rectangle shapeAboveBounds = this.getBounds(shapeAbove);
                if (slice.remove(shapeAboveBounds.x, shapeAboveBounds.right()) == 0) break;
            }
            cuts = slice.getCuts();
            c1 = cuts.get(0);
            int ic2 = 1;
            while (ic2 < cuts.size()) {
                int c2 = cuts.get(ic2);
                int x = c1;
                int y = this.top;
                int w = c2 - c1;
                int h = Integer.MIN_VALUE;
                for (ContainerShape shapeAbove : above) {
                    Rectangle shapeAboveBounds = this.getBounds(shapeAbove);
                    if (shapeAboveBounds.x > c1 || c1 >= shapeAboveBounds.right()) continue;
                    h = shapeAboveBounds.y - shapeBounds.y - shapeBounds.height;
                    break;
                }
                if (h == Integer.MIN_VALUE) {
                    h = shapeBounds.y - this.top;
                    net.add(x, y, w, h);
                }
                c1 = c2;
                ++ic2;
            }
            this.addTrailingAisle(net, shape);
            ++i;
        }
        net.add(this.right - 50, this.top, 50, this.bottom - this.top);
        net.rotate(this.rotate);
    }

    protected void addTrailingAisle(RoutingNet net, ContainerShape shape) {
        ContainerShape s;
        Rectangle shapeBounds = this.getBounds(shape);
        int x = shapeBounds.right();
        int size = this.allShapes.size();
        int i = 0;
        while (i < size) {
            s = this.allShapes.get(i);
            if (s != shape) {
                Rectangle b = this.getBounds(s);
                if (b.x <= x && x < b.right()) {
                    return;
                }
            }
            ++i;
        }
        i = 0;
        while (i < size) {
            s = this.allShapes.get(i);
            if (s == shape) {
                int n = i + 1;
                while (n < size) {
                    ContainerShape nextShape = this.allShapes.get(n);
                    Rectangle nextShapeBounds = this.getBounds(nextShape);
                    if (nextShapeBounds.x > shapeBounds.right()) {
                        net.add(shapeBounds.right(), this.top, nextShapeBounds.x - shapeBounds.right(), this.bottom - this.top);
                        return;
                    }
                    ++n;
                }
            }
            ++i;
        }
    }

    protected List<ContainerShape> getShapesBelow(ContainerShape shape) {
        Rectangle b;
        final Rectangle bounds = this.getBounds(shape);
        ArrayList<ContainerShape> shapes = new ArrayList<ContainerShape>();
        for (ContainerShape s : this.allShapes) {
            if (s == shape) continue;
            b = this.getBounds(s);
            if (b.x > bounds.right()) break;
            int d = b.y - bounds.y;
            if (d < 0 || !(bounds.x <= b.x && b.x <= bounds.right() || bounds.x <= b.right() && b.right() <= bounds.right()) && (b.x > bounds.x || bounds.right() > b.right())) continue;
            shapes.add(s);
        }
        Collections.sort(shapes, new Comparator<ContainerShape>(){

            @Override
            public int compare(ContainerShape s1, ContainerShape s2) {
                int d2;
                Rectangle b1 = RouteSolver.this.getBounds(s1);
                Rectangle b2 = RouteSolver.this.getBounds(s2);
                int d1 = b1.y - bounds.bottom();
                int i = d1 - (d2 = b2.y - bounds.bottom());
                if (i == 0) {
                    i = b1.x - b2.x;
                }
                return i;
            }
        });
        int i = 0;
        while (i < shapes.size()) {
            ContainerShape s = (ContainerShape)shapes.get(i);
            b = this.getBounds(s);
            if (b.x <= bounds.x && b.right() >= bounds.right()) {
                ++i;
                while (i < shapes.size()) {
                    shapes.remove(i);
                }
            }
            ++i;
        }
        return shapes;
    }

    protected List<ContainerShape> getShapesAbove(ContainerShape shape) {
        Rectangle b;
        final Rectangle bounds = this.getBounds(shape);
        ArrayList<ContainerShape> shapes = new ArrayList<ContainerShape>();
        for (ContainerShape s : this.allShapes) {
            if (s == shape) continue;
            b = this.getBounds(s);
            if (b.x > bounds.right()) break;
            int d = b.y - bounds.y;
            if (d > 0 || !(bounds.x <= b.x && b.x <= bounds.right() || bounds.x <= b.right() && b.right() <= bounds.right()) && (b.x > bounds.x || bounds.right() > b.right())) continue;
            shapes.add(s);
        }
        Collections.sort(shapes, new Comparator<ContainerShape>(){

            @Override
            public int compare(ContainerShape s1, ContainerShape s2) {
                Rectangle b1 = RouteSolver.this.getBounds(s1);
                Rectangle b2 = RouteSolver.this.getBounds(s2);
                int d1 = b1.y - bounds.y;
                int d2 = b2.y - bounds.y;
                int i = d1 - d2;
                if (i == 0) {
                    i = b1.x - b2.x;
                }
                return i;
            }
        });
        int i = 0;
        while (i < shapes.size()) {
            ContainerShape s = (ContainerShape)shapes.get(i);
            b = this.getBounds(s);
            if (b.x <= bounds.x && b.right() >= bounds.right()) {
                ++i;
                while (i < shapes.size()) {
                    shapes.remove(i);
                }
            }
            ++i;
        }
        return shapes;
    }

    protected void sortAllShapes() {
        Collections.sort(this.allShapes, new Comparator<ContainerShape>(){

            @Override
            public int compare(ContainerShape s1, ContainerShape s2) {
                Rectangle r1 = RouteSolver.this.getBounds(s1);
                Rectangle r2 = RouteSolver.this.getBounds(s2);
                int i = r1.x - r2.x;
                if (i == 0) {
                    i = r1.y - r2.y;
                }
                return i;
            }
        });
    }

    private Rectangle getBounds(ContainerShape shape) {
        return RoutingNet.getBounds(this.rotate, (Shape)shape);
    }

    class Slice {
        protected Slice parent;
        protected int left;
        protected int right;
        List<Integer> cuts = new ArrayList<Integer>();
        List<Slice> children = new ArrayList<Slice>();

        public Slice(int left, int right) {
            this(null, left, right);
        }

        protected Slice(Slice parent, int left, int right) {
            this.parent = parent;
            this.left = left;
            this.right = right;
            this.cuts.add(left);
            this.cuts.add(right);
        }

        public int remove(int l, int r) {
            if (r < this.left || this.right < l) {
                for (Slice s : this.children) {
                    s.remove(l, r);
                }
            } else if (l <= this.left && this.left <= r && r <= this.right) {
                for (Slice s : this.children) {
                    s.remove(l, r);
                }
                this.cut(this.left);
                this.left = r;
            } else if (l <= this.left && this.right <= r) {
                for (Slice s : this.children) {
                    s.remove(l, this.left);
                    s.remove(this.right, r);
                }
                this.cut(this.left);
                this.cut(this.right);
                this.right = this.left;
            } else if (l > this.left && r < this.right) {
                this.children.add(new Slice(this, this.left, l));
                this.children.add(new Slice(this, r, this.right));
                this.cut(this.left);
                this.left = l;
                this.cut(this.right);
                this.right = r;
            } else if (this.left <= l && l <= this.right && r >= this.right) {
                for (Slice s : this.children) {
                    s.remove(r, this.right);
                }
                this.cut(this.right);
                this.right = l;
            }
            return this.length();
        }

        public int length() {
            int length = this.right - this.left;
            for (Slice s : this.children) {
                length += s.length();
            }
            return length;
        }

        protected void cut(int point) {
            if (!this.cuts.contains(point)) {
                this.cuts.add(point);
            }
        }

        public List<Integer> getCuts() {
            this.cut(this.left);
            this.cut(this.right);
            for (Slice s : this.children) {
                for (Integer p : s.getCuts()) {
                    this.cut(p);
                }
            }
            if (this.parent == null) {
                Collections.sort(this.cuts);
            }
            return this.cuts;
        }
    }
}

