/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.features.event.definitions;

import org.eclipse.bpmn2.BoundaryEvent;
import org.eclipse.bpmn2.EndEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.EventDefinition;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.modeler.core.features.BaseElementFeatureContainer;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.AbstractAddEventDefinitionFeature;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.AbstractUpdateEventDefinitionFeature;
import org.eclipse.bpmn2.modeler.core.features.event.definitions.DecorationAlgorithm;
import org.eclipse.bpmn2.modeler.core.utils.BusinessObjectUtil;
import org.eclipse.graphiti.features.IAddFeature;
import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.ILayoutFeature;
import org.eclipse.graphiti.features.IMoveShapeFeature;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.IResizeShapeFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.IPictogramElementContext;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.algorithms.styles.Color;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.util.IColorConstant;

public abstract class AbstractEventDefinitionFeatureContainer
extends BaseElementFeatureContainer {
    @Override
    public Object getApplyObject(IContext context) {
        EventDefinition ed;
        if (context instanceof IAddContext) {
            return ((IAddContext)context).getNewObject();
        }
        if (context instanceof IPictogramElementContext && (ed = BusinessObjectUtil.getFirstElementOfType(((IPictogramElementContext)context).getPictogramElement(), EventDefinition.class)) != null) {
            return ed;
        }
        return null;
    }

    @Override
    public IAddFeature getAddFeature(IFeatureProvider fp) {
        return new AddEventDefinitionFeature(fp);
    }

    @Override
    public IUpdateFeature getUpdateFeature(IFeatureProvider fp) {
        return new UpdateEventDefinitionFeature(fp);
    }

    protected abstract Shape drawForStart(DecorationAlgorithm var1, ContainerShape var2);

    protected abstract Shape drawForEnd(DecorationAlgorithm var1, ContainerShape var2);

    protected abstract Shape drawForThrow(DecorationAlgorithm var1, ContainerShape var2);

    protected abstract Shape drawForCatch(DecorationAlgorithm var1, ContainerShape var2);

    protected abstract Shape drawForBoundary(DecorationAlgorithm var1, ContainerShape var2);

    @Override
    public ILayoutFeature getLayoutFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IMoveShapeFeature getMoveFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IResizeShapeFeature getResizeFeature(IFeatureProvider fp) {
        return null;
    }

    @Override
    public IDeleteFeature getDeleteFeature(IFeatureProvider context) {
        return null;
    }

    public static class AddEventDefinitionFeature
    extends AbstractAddEventDefinitionFeature<EventDefinition> {
        public AddEventDefinitionFeature(IFeatureProvider fp) {
            super(fp);
        }

        @Override
        protected void decorateShape(IAddContext context, ContainerShape containerShape, EventDefinition businessObject) {
        }

        @Override
        public Class getBusinessObjectType() {
            return EventDefinition.class;
        }
    }

    public class UpdateEventDefinitionFeature
    extends AbstractUpdateEventDefinitionFeature {
        public UpdateEventDefinitionFeature(IFeatureProvider fp) {
            super(fp);
        }

        @Override
        public DecorationAlgorithm getDecorationAlgorithm(final Event event) {
            return new DecorationAlgorithm(){

                @Override
                public Shape draw(ContainerShape shape) {
                    if (event instanceof BoundaryEvent) {
                        return AbstractEventDefinitionFeatureContainer.this.drawForBoundary(this, shape);
                    }
                    if (event instanceof IntermediateCatchEvent) {
                        return AbstractEventDefinitionFeatureContainer.this.drawForCatch(this, shape);
                    }
                    if (event instanceof IntermediateThrowEvent) {
                        return AbstractEventDefinitionFeatureContainer.this.drawForThrow(this, shape);
                    }
                    if (event instanceof StartEvent) {
                        return AbstractEventDefinitionFeatureContainer.this.drawForStart(this, shape);
                    }
                    if (event instanceof EndEvent) {
                        return AbstractEventDefinitionFeatureContainer.this.drawForEnd(this, shape);
                    }
                    return null;
                }

                @Override
                public Color manageColor(IColorConstant colorConstant) {
                    return UpdateEventDefinitionFeature.this.manageColor(colorConstant);
                }
            };
        }

        public boolean update(IUpdateContext context) {
            ContainerShape container = (ContainerShape)context.getPictogramElement();
            Event event = (Event)this.getBusinessObjectForPictogramElement((PictogramElement)container);
            this.draw(event, container);
            return true;
        }

        public boolean canUpdate(IUpdateContext context) {
            return true;
        }

        @Override
        public IReason updateNeeded(IUpdateContext context) {
            return new Reason(false);
        }
    }
}

