/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.gradleware.tooling.toolingmodel.OmniEclipseProject;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;

final class LibraryFilter {
    LibraryFilter() {
    }

    public static void update(IJavaProject eclipseProject, OmniEclipseProject modelProject, IProgressMonitor monitor) throws JavaModelException {
        if (LibraryFilter.supportsClasspathCustomization(modelProject)) {
            IClasspathEntry[] newClasspath = LibraryFilter.filterLibraries(eclipseProject.getRawClasspath());
            eclipseProject.setRawClasspath(newClasspath, monitor);
        }
    }

    private static IClasspathEntry[] filterLibraries(IClasspathEntry[] classpath) throws JavaModelException {
        return (IClasspathEntry[])FluentIterable.from(Arrays.asList(classpath)).filter((Predicate)new Predicate<IClasspathEntry>(){

            public boolean apply(IClasspathEntry entry) {
                return entry.getEntryKind() != 1;
            }
        }).toArray(IClasspathEntry.class);
    }

    private static boolean supportsClasspathCustomization(OmniEclipseProject modelProject) {
        return modelProject.getClasspathContainers().isPresent();
    }
}

