/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.build;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.cdt.core.build.IUserToolChainProvider;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.internal.ui.build.NewToolChainWizard;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.build.ToolChainWizard;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ToolChainPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TableViewer availTable;
    private Button availUp;
    private Button availDown;
    private TableViewer userTable;
    private Button userEdit;
    private Button userRemove;
    private List<IToolChain> toolChains;
    private static IToolChainManager manager = CUIPlugin.getService(IToolChainManager.class);
    private ISafeRunnable tcListener = () -> Display.getDefault().asyncExec(() -> {
        this.availTable.refresh();
        this.userTable.refresh();
    });

    public ToolChainPreferencePage() {
        super(CUIMessages.ToolChainPreferencePage_Toolchains);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        Label label = new Label(control, 0);
        label.setText(CUIMessages.ToolChainPreferencePage_Desc);
        Group availGroup = new Group(control, 0);
        availGroup.setText(CUIMessages.ToolChainPreferencePage_AvailableToolchains);
        availGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        availGroup.setLayout((Layout)new GridLayout(2, false));
        this.availTable = this.createToolChainTable((Composite)availGroup);
        this.availTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.availTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ToolChainPreferencePage.this.toolChains = new ArrayList();
                try {
                    ToolChainPreferencePage.this.toolChains.addAll(manager.getAllToolChains());
                }
                catch (CoreException e) {
                    CUIPlugin.log(e.getStatus());
                }
                return ToolChainPreferencePage.this.toolChains.toArray();
            }
        });
        this.availTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolChainPreferencePage.this.updateButtons();
            }
        });
        Composite availButtonComp = new Composite((Composite)availGroup, 0);
        availButtonComp.setLayoutData((Object)new GridData(4, 4, false, true));
        availButtonComp.setLayout((Layout)new GridLayout());
        this.availUp = new Button(availButtonComp, 8);
        this.availUp.setLayoutData((Object)new GridData(4, 1, false, false));
        this.availUp.setText(CUIMessages.ToolChainPreferencePage_Up);
        this.availUp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = ToolChainPreferencePage.this.availTable.getTable().getSelectionIndex();
                if (i < 1) {
                    return;
                }
                IToolChain tc = (IToolChain)ToolChainPreferencePage.this.toolChains.get(i - 1);
                ToolChainPreferencePage.this.toolChains.set(i - 1, (IToolChain)ToolChainPreferencePage.this.toolChains.get(i));
                ToolChainPreferencePage.this.toolChains.set(i, tc);
                ToolChainPreferencePage.this.availTable.refresh();
            }
        });
        this.availDown = new Button(availButtonComp, 8);
        this.availDown.setLayoutData((Object)new GridData(4, 1, false, false));
        this.availDown.setText(CUIMessages.ToolChainPreferencePage_Down);
        this.availDown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = ToolChainPreferencePage.this.availTable.getTable().getSelectionIndex();
                if (i < 0 || i > ToolChainPreferencePage.this.toolChains.size() - 2) {
                    return;
                }
                IToolChain tc = (IToolChain)ToolChainPreferencePage.this.toolChains.get(i + 1);
                ToolChainPreferencePage.this.toolChains.set(i + 1, (IToolChain)ToolChainPreferencePage.this.toolChains.get(i));
                ToolChainPreferencePage.this.toolChains.set(i, tc);
                ToolChainPreferencePage.this.availTable.refresh();
            }
        });
        Group userGroup = new Group(control, 0);
        userGroup.setText(CUIMessages.ToolChainPreferencePage_UserDefinedToolchains);
        userGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        userGroup.setLayout((Layout)new GridLayout(2, false));
        this.userTable = this.createToolChainTable((Composite)userGroup);
        this.userTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.userTable.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                ArrayList<IToolChain> tcs = new ArrayList<IToolChain>();
                try {
                    for (IToolChain tc : manager.getAllToolChains()) {
                        if (!(tc.getProvider() instanceof IUserToolChainProvider)) continue;
                        tcs.add(tc);
                    }
                }
                catch (CoreException e) {
                    CUIPlugin.log(e);
                }
                return tcs.toArray();
            }
        });
        this.userTable.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ToolChainPreferencePage.this.updateButtons();
            }
        });
        Composite userButtonComp = new Composite((Composite)userGroup, 0);
        userButtonComp.setLayoutData((Object)new GridData(4, 4, false, true));
        userButtonComp.setLayout((Layout)new GridLayout());
        Button userAdd = new Button(userButtonComp, 8);
        userAdd.setLayoutData((Object)new GridData(4, 1, false, false));
        userAdd.setText(CUIMessages.ToolChainPreferencePage_Add);
        userAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewToolChainWizard wizard = new NewToolChainWizard();
                WizardDialog dialog = new WizardDialog(ToolChainPreferencePage.this.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        this.userEdit = new Button(userButtonComp, 8);
        this.userEdit.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.userEdit.setText(CUIMessages.ToolChainPreferencePage_EditDot);
        this.userEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IToolChain tc = (IToolChain)ToolChainPreferencePage.this.userTable.getStructuredSelection().getFirstElement();
                String providerId = tc.getProvider().getId();
                ToolChainWizard wizard = null;
                IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.cdt.ui.newToolChainWizards");
                IExtension[] iExtensionArray = point.getExtensions();
                int n = iExtensionArray.length;
                int n2 = 0;
                block2: while (n2 < n) {
                    IExtension extension = iExtensionArray[n2];
                    IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                    int n3 = iConfigurationElementArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement element = iConfigurationElementArray[n4];
                        if (providerId.equals(element.getAttribute("providerId"))) {
                            try {
                                wizard = (ToolChainWizard)((Object)element.createExecutableExtension("class"));
                                break block2;
                            }
                            catch (CoreException e1) {
                                CUIPlugin.log(e1.getStatus());
                            }
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (wizard != null) {
                    wizard.setToolChain(tc);
                    WizardDialog dialog = new WizardDialog(ToolChainPreferencePage.this.getShell(), (IWizard)wizard);
                    dialog.open();
                } else {
                    MessageDialog.openInformation((Shell)ToolChainPreferencePage.this.getShell(), (String)CUIMessages.ToolChainPreferencePage_Edit, (String)CUIMessages.ToolChainPreferencePage_NoEditor);
                }
            }
        });
        this.userRemove = new Button(userButtonComp, 8);
        this.userRemove.setLayoutData((Object)new GridData(4, 1, false, false));
        this.userRemove.setText(CUIMessages.ToolChainPreferencePage_Remove);
        this.userRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (MessageDialog.openConfirm((Shell)ToolChainPreferencePage.this.getShell(), (String)CUIMessages.ToolChainPreferencePage_Remove1, (String)CUIMessages.ToolChainPreferencePage_AreYouSure)) {
                    final IToolChain tc = (IToolChain)ToolChainPreferencePage.this.userTable.getStructuredSelection().getFirstElement();
                    final IUserToolChainProvider provider = (IUserToolChainProvider)tc.getProvider();
                    new Job(CUIMessages.ToolChainPreferencePage_RemoveToolchain){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                provider.removeToolChain(tc);
                                return Status.OK_STATUS;
                            }
                            catch (CoreException e) {
                                return e.getStatus();
                            }
                        }
                    }.schedule();
                }
            }
        });
        this.availTable.setInput((Object)manager);
        this.userTable.setInput((Object)manager);
        this.updateButtons();
        manager.addToolChainListener(this.tcListener);
        return control;
    }

    public void dispose() {
        manager.removeToolChainListener(this.tcListener);
        super.dispose();
    }

    public boolean performOk() {
        if (!super.performOk()) {
            return false;
        }
        try {
            if (!this.toolChains.equals(manager.getAllToolChains())) {
                manager.setToolChainOrder(this.toolChains);
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e.getStatus());
            return false;
        }
        return true;
    }

    private TableViewer createToolChainTable(Composite parent) {
        Composite tableComp = new Composite(parent, 0);
        tableComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Table table = new Table(tableComp, 68096);
        table.setLayoutData((Object)new GridData(4, 4, true, true));
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tableTypeColumn = new TableColumn(table, 16384);
        tableTypeColumn.setText(CUIMessages.ToolChainPreferencePage_Type);
        tableLayout.setColumnData((Widget)tableTypeColumn, (ColumnLayoutData)new ColumnWeightData(2));
        TableColumn tableNameColumn = new TableColumn(table, 16384);
        tableNameColumn.setText(CUIMessages.ToolChainPreferencePage_Name);
        tableLayout.setColumnData((Widget)tableNameColumn, (ColumnLayoutData)new ColumnWeightData(10));
        TableColumn tableOSColumn = new TableColumn(table, 16384);
        tableOSColumn.setText(CUIMessages.ToolChainPreferencePage_OS);
        tableLayout.setColumnData((Widget)tableOSColumn, (ColumnLayoutData)new ColumnWeightData(2));
        TableColumn tableArchColumn = new TableColumn(table, 16384);
        tableArchColumn.setText(CUIMessages.ToolChainPreferencePage_Arch);
        tableLayout.setColumnData((Widget)tableArchColumn, (ColumnLayoutData)new ColumnWeightData(2));
        tableComp.setLayout((Layout)tableLayout);
        return new TableViewer(table);
    }

    private void updateButtons() {
        int i = this.availTable.getTable().getSelectionIndex();
        this.availUp.setEnabled(i > 0);
        this.availDown.setEnabled(i >= 0 && i < this.toolChains.size() - 2);
        boolean userSelected = this.userTable.getTable().getSelectionCount() > 0;
        this.userEdit.setEnabled(userSelected);
        this.userRemove.setEnabled(userSelected);
    }

    private static class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TableLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            IToolChain toolChain = (IToolChain)element;
            switch (columnIndex) {
                case 0: {
                    return manager.getToolChainTypeName(toolChain.getTypeId());
                }
                case 1: {
                    return toolChain.getName();
                }
                case 2: {
                    return toolChain.getProperty("os");
                }
                case 3: {
                    return toolChain.getProperty("arch");
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

