/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.refresh;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.sqltools.internal.refresh.ICatalogObjectListener2;

public class RefreshManager2 {
    private RefreshManager _delegate = RefreshManager.getInstance();
    private static RefreshManager2 instance = null;
    private HashMap listeners = new HashMap();
    private HashMap typeListeners = new HashMap();
    private ArrayList globalListeners = new ArrayList();

    private RefreshManager2() {
    }

    public static RefreshManager2 getInstance() {
        if (instance == null) {
            instance = new RefreshManager2();
        }
        return instance;
    }

    public void addListener(ICatalogObject interestedObject, ICatalogObjectListener2 listener) {
        if (interestedObject == null) {
            if (!this.globalListeners.contains(listener)) {
                this.globalListeners.add(listener);
            }
        } else if (this.listeners.containsKey(interestedObject)) {
            ArrayList listenerLinks = (ArrayList)this.listeners.get(interestedObject);
            if (!listenerLinks.contains(listener)) {
                listenerLinks.add(listener);
            }
        } else {
            ArrayList<ICatalogObjectListener2> listenerLinks = new ArrayList<ICatalogObjectListener2>();
            listenerLinks.add(listener);
            this.listeners.put(interestedObject, listenerLinks);
        }
    }

    public void addListener(Class type, ICatalogObjectListener2 listener) {
        if (type == null) {
            if (!this.globalListeners.contains(listener)) {
                this.globalListeners.add(listener);
            }
        } else if (this.typeListeners.containsKey(type)) {
            ArrayList listenerLinks = (ArrayList)this.typeListeners.get(type);
            if (!listenerLinks.contains(listener)) {
                listenerLinks.add(listener);
            }
        } else {
            ArrayList<ICatalogObjectListener2> listenerLinks = new ArrayList<ICatalogObjectListener2>();
            listenerLinks.add(listener);
            this.typeListeners.put(type, listenerLinks);
        }
    }

    public void removeListener(ICatalogObject interestedObject, ICatalogObjectListener2 listener) {
        ArrayList listenerLinks;
        if (interestedObject == null) {
            if (this.globalListeners.contains(listener)) {
                this.globalListeners.remove(listener);
            }
        } else if (this.listeners.containsKey(interestedObject) && (listenerLinks = (ArrayList)this.listeners.get(interestedObject)).contains(listener)) {
            listenerLinks.remove(listener);
        }
    }

    public void removeListener(Class type, ICatalogObjectListener2 listener) {
        ArrayList listenerLinks;
        if (type == null) {
            if (this.globalListeners.contains(listener)) {
                this.globalListeners.remove(listener);
            }
        } else if (this.typeListeners.containsKey(type) && (listenerLinks = (ArrayList)this.typeListeners.get(type)).contains(listener)) {
            listenerLinks.remove(listener);
        }
    }

    public void clearListener() {
        this.listeners.clear();
        this.typeListeners.clear();
        this.globalListeners.clear();
    }

    public void referesh(ICatalogObject object, String context) {
        this._delegate.referesh(object);
        int i = 0;
        while (i < this.globalListeners.size()) {
            ((ICatalogObjectListener2)this.globalListeners.get(i)).notifyChanged(object, 0, context);
            ++i;
        }
        for (Class clazz : this.typeListeners.keySet()) {
            if (!clazz.isInstance(object)) continue;
            ArrayList listenerLinks = (ArrayList)this.typeListeners.get(object);
            int i2 = 0;
            while (i2 < listenerLinks.size()) {
                ICatalogObjectListener2 listener = (ICatalogObjectListener2)listenerLinks.get(i2);
                listener.notifyChanged(object, 0, context);
                ++i2;
            }
        }
        if (this.listeners.containsKey(object)) {
            ArrayList listenerLinks = (ArrayList)this.listeners.get(object);
            int i3 = 0;
            while (i3 < listenerLinks.size()) {
                ICatalogObjectListener2 listener = (ICatalogObjectListener2)listenerLinks.get(i3);
                listener.notifyChanged(object, 0, context);
                ++i3;
            }
        }
    }
}

