/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.common.component.tabs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.TableColumn;

public class TableViewerUtil {
    public static void refreshAndPack(TableViewer viewer) {
        viewer.refresh();
        TableViewerUtil.packAllColumns(viewer);
    }

    public static void updateAndPack(TableViewer viewer, Object object) {
        viewer.update(object, null);
        TableViewerUtil.packAllColumns(viewer);
    }

    public static boolean isColumnClicked(TableViewer viewer, MouseEvent e, TableViewerColumn tvColumn) {
        int index;
        ViewerCell cell = viewer.getCell(new Point(e.x, e.y));
        boolean ret = cell == null ? false : ((index = Arrays.asList(viewer.getTable().getColumns()).indexOf(tvColumn.getColumn())) == -1 ? false : index == cell.getColumnIndex());
        return ret;
    }

    public static Object getData(TableViewer viewer, MouseEvent e) {
        ViewerCell cell = viewer.getCell(new Point(e.x, e.y));
        if (cell == null) {
            return null;
        }
        return cell.getElement();
    }

    public static void packAllColumns(TableViewer viewer) {
        TableColumn[] tableColumnArray = viewer.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            col.pack();
            ++n2;
        }
    }

    public static void resetColumnOrder(TableViewer tvResults) {
        int[] order = tvResults.getTable().getColumnOrder();
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        tvResults.getTable().setColumnOrder(order);
    }

    public static ArrayList<TableColumn> getColumnsInDisplayOrder(TableViewer viewer) {
        final ArrayList<TableColumn> allCols = new ArrayList<TableColumn>(Arrays.asList(viewer.getTable().getColumns()));
        final int[] order = viewer.getTable().getColumnOrder();
        Collections.sort(allCols, new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn o1, TableColumn o2) {
                return order[allCols.indexOf(o1)] - order[allCols.indexOf(o2)];
            }
        });
        return allCols;
    }

    public static int getVisibleColumnIndex(TableViewer tvResults2, TableColumn col) {
        int createOrder = Arrays.asList(tvResults2.getTable().getColumns()).indexOf(col);
        if (createOrder == -1) {
            return -1;
        }
        return tvResults2.getTable().getColumnOrder()[createOrder];
    }

    public static abstract class AbstractInvertableTableSorter
    extends InvertableSorter {
        private final InvertableSorter inverse = new InvertableSorter(){

            @Override
            public int compare(Viewer viewer, Object e1, Object e2) {
                return -1 * AbstractInvertableTableSorter.this.compare(viewer, e1, e2);
            }

            @Override
            InvertableSorter getInverseSorter() {
                return AbstractInvertableTableSorter.this;
            }

            @Override
            public int getSortDirection() {
                return 1024;
            }
        };

        @Override
        InvertableSorter getInverseSorter() {
            return this.inverse;
        }

        @Override
        public int getSortDirection() {
            return 128;
        }
    }

    static class ColumnLabelSorter
    extends AbstractInvertableTableSorter {
        private final TableColumn col;

        ColumnLabelSorter(TableColumn col) {
            this.col = col;
        }

        @Override
        public int compare(Viewer viewer, Object e1, Object e2) {
            TableViewer tableViewer = (TableViewer)viewer;
            ColumnLabelProvider labelProvider = (ColumnLabelProvider)tableViewer.getLabelProvider(Arrays.asList(tableViewer.getTable().getColumns()).indexOf(this.col));
            return labelProvider.getText(e1).compareTo(labelProvider.getText(e2));
        }
    }

    static abstract class InvertableSorter
    extends ViewerSorter {
        InvertableSorter() {
        }

        public abstract int compare(Viewer var1, Object var2, Object var3);

        abstract InvertableSorter getInverseSorter();

        public abstract int getSortDirection();
    }

    public static class TableSortSelectionListener
    implements SelectionListener {
        private final TableViewer viewer;
        private final TableColumn column;
        private final InvertableSorter sorter;
        private final boolean keepDirection;
        private InvertableSorter currentSorter;

        public TableSortSelectionListener(TableViewer viewer, TableColumn column, AbstractInvertableTableSorter sorter, int defaultDirection, boolean keepDirection) {
            this.viewer = viewer;
            this.column = column;
            this.keepDirection = keepDirection;
            this.currentSorter = this.sorter = defaultDirection == 128 ? sorter : sorter.getInverseSorter();
            this.column.addSelectionListener((SelectionListener)this);
        }

        public void chooseColumnForSorting() {
            this.viewer.getTable().setSortColumn(this.column);
            this.viewer.getTable().setSortDirection(this.currentSorter.getSortDirection());
            this.viewer.setSorter((ViewerSorter)this.currentSorter);
        }

        public void widgetSelected(SelectionEvent e) {
            InvertableSorter newSorter = this.viewer.getTable().getSortColumn() == this.column ? ((InvertableSorter)this.viewer.getSorter()).getInverseSorter() : (this.keepDirection ? this.currentSorter : this.sorter);
            this.currentSorter = newSorter;
            this.chooseColumnForSorting();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }
}

