/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.model;

import org.eclipse.egerrit.internal.core.utils.Utils;
import org.eclipse.egerrit.internal.dashboard.ui.GerritUi;
import org.eclipse.egerrit.internal.dashboard.ui.model.Messages;
import org.eclipse.egerrit.internal.dashboard.ui.model.ReviewTableDefinition;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.provider.ChangeInfoItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ReviewTableLabelProvider
extends ChangeInfoItemProvider {
    private static final String EMPTY_STRING = "";
    private int fState;
    private int defaultColumn = ReviewTableDefinition.values().length;
    private String[] voteColumns;
    public static final String STAR_FILLED = "starFilled.gif";
    public static final String STAR_OPEN = "starOpen.gif";
    private static Display fDisplay = Display.getCurrent();
    private static final Color DEFAULT_COLOR = fDisplay.getSystemColor(25);
    private static final Color DEFAULT_FOREGROUND_COLOR = fDisplay.getSystemColor(16);
    private static final Color BOLD_COLOR = fDisplay.getSystemColor(2);
    private static final Color INCOMING_COLOR = fDisplay.getSystemColor(1);
    private static final Color CLOSED_COLOR = fDisplay.getSystemColor(1);
    private static final Color RED_COLOR = fDisplay.getSystemColor(3);
    private static final Color GREEN_COLOR = fDisplay.getSystemColor(6);
    private static ImageRegistry fImageRegistry = new ImageRegistry();

    static {
        String iconPath = "icons/view16/";
        fImageRegistry.put(STAR_FILLED, GerritUi.getImageDescriptor(String.valueOf(iconPath) + STAR_FILLED));
        fImageRegistry.put(STAR_OPEN, GerritUi.getImageDescriptor(String.valueOf(iconPath) + STAR_OPEN));
    }

    public ReviewTableLabelProvider(AdapterFactory adapterFactory, String[] columnDescription) {
        super(adapterFactory);
        this.voteColumns = columnDescription;
    }

    private Image getReviewId(Boolean aState) {
        if (aState.booleanValue()) {
            return fImageRegistry.get(STAR_FILLED);
        }
        return fImageRegistry.get(STAR_OPEN);
    }

    public String getColumnText(Object aObj, int aIndex) {
        if (aObj instanceof ChangeInfo) {
            ChangeInfo reviewSummary = (ChangeInfo)aObj;
            switch (aIndex) {
                case 0: {
                    Boolean starred = reviewSummary.isStarred();
                    if (starred.booleanValue()) {
                        return Messages.Starred;
                    }
                    return Messages.Not_Starred;
                }
                case 1: {
                    return Integer.toString(reviewSummary.get_number());
                }
                case 2: {
                    return reviewSummary.getSubject();
                }
                case 3: {
                    String attribute = reviewSummary.getStatus();
                    return attribute;
                }
                case 4: {
                    return reviewSummary.getOwner().getName();
                }
                case 5: {
                    return reviewSummary.getProject();
                }
                case 6: {
                    String branch = reviewSummary.getBranch();
                    String topic = reviewSummary.getTopic();
                    if (topic != null && !topic.isEmpty()) {
                        branch = String.valueOf(branch) + " (" + topic + ")";
                    }
                    return branch;
                }
                case 7: {
                    return Utils.prettyPrintDate((String)reviewSummary.getUpdated());
                }
            }
            String label = this.getColumnLabels(aIndex);
            this.fState = reviewSummary.getMostRelevantVote(label).getValue();
            int min = reviewSummary.getLabelMinValue(label);
            int max = reviewSummary.getLabelMaxValue(label);
            if (max != 0 && this.fState >= max) {
                return "\u2713";
            }
            if (min != 0 && this.fState <= min) {
                return "X";
            }
            if (this.fState != 0) {
                String st = this.fState > 0 ? "+" : EMPTY_STRING;
                st = String.valueOf(st) + StringConverter.asString((int)this.fState);
                return st;
            }
            return EMPTY_STRING;
        }
        return EMPTY_STRING;
    }

    public Image getColumnImage(Object aObj, int aIndex) {
        Image image = null;
        String value = null;
        if (aObj instanceof ChangeInfo) {
            ChangeInfo reviewSummary = (ChangeInfo)aObj;
            switch (aIndex) {
                case 0: {
                    Boolean starred = reviewSummary.isStarred();
                    value = starred.toString();
                    if (value == null || value.equals(EMPTY_STRING)) break;
                    return this.getReviewId(Boolean.valueOf(value.toLowerCase()));
                }
                default: {
                    return image;
                }
            }
        }
        return image;
    }

    public Object getForeground(Object aElement, int aColumnIndex) {
        if (aElement instanceof ChangeInfo) {
            switch (aColumnIndex) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ChangeInfo changeInfo = (ChangeInfo)aElement;
                    if (changeInfo.isReviewed()) {
                        return DEFAULT_FOREGROUND_COLOR;
                    }
                    return BOLD_COLOR;
                }
            }
            if (this.fState < 0) {
                return RED_COLOR;
            }
            if (this.fState > 0) {
                return GREEN_COLOR;
            }
        }
        return null;
    }

    public Object getBackground(Object aElement, int aColumnIndex) {
        ChangeInfo item;
        String state;
        if (aElement instanceof ChangeInfo && (state = Boolean.toString((item = (ChangeInfo)aElement).isStarred())) != null) {
            if (state.equals(Boolean.toString(true))) {
                return INCOMING_COLOR;
            }
            if (state.equals(Boolean.toString(false))) {
                return CLOSED_COLOR;
            }
        }
        return DEFAULT_COLOR;
    }

    private String getColumnLabels(int column) {
        int val = column - this.defaultColumn;
        if (val >= 0) {
            return this.voteColumns[val];
        }
        return EMPTY_STRING;
    }
}

