/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.commit;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.PreferenceBasedDateFormatter;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.RepositoryCommitNote;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.Note;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.ui.model.WorkbenchAdapter;

public class RepositoryCommit
extends WorkbenchAdapter
implements IAdaptable {
    public static final int NAME_LENGTH = 8;
    private Repository repository;
    private RevCommit commit;
    private FileDiff[] diffs;
    private RepositoryCommitNote[] notes;
    private boolean stash;

    public RepositoryCommit(Repository repository, RevCommit commit) {
        Assert.isNotNull((Object)repository, (String)"Repository cannot be null");
        Assert.isNotNull((Object)commit, (String)"Commit cannot be null");
        this.repository = repository;
        this.commit = commit;
    }

    public Object getAdapter(Class adapter) {
        if (Repository.class == adapter) {
            return this.repository;
        }
        if (RevCommit.class == adapter) {
            return this.commit;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public String abbreviate() {
        return this.commit.abbreviate(8).name();
    }

    public String getRepositoryName() {
        if (!this.repository.isBare()) {
            return this.repository.getDirectory().getParentFile().getName();
        }
        return this.repository.getDirectory().getName();
    }

    public Repository getRepository() {
        return this.repository;
    }

    public RevCommit getRevCommit() {
        return this.commit;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileDiff[] getDiffs() {
        if (this.diffs != null) return this.diffs;
        RevCommit[] parents = this.commit.getParents();
        if (this.isStash() && this.commit.getParentCount() > 0) {
            parents = new RevCommit[]{this.commit.getParent(0)};
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                RevWalk revWalk = new RevWalk(this.repository);
                try {
                    try (TreeWalk treewalk = new TreeWalk(revWalk.getObjectReader());){
                        treewalk.setRecursive(true);
                        treewalk.setFilter(TreeFilter.ANY_DIFF);
                        RevCommit[] revCommitArray = this.commit.getParents();
                        int n = revCommitArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            RevCommit parent = revCommitArray[n2];
                            revWalk.parseBody((RevObject)parent);
                            ++n2;
                        }
                        this.diffs = FileDiff.compute(this.repository, treewalk, this.commit, parents, TreeFilter.ALL);
                    }
                    if (revWalk == null) return this.diffs;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (revWalk == null) throw throwable;
                    revWalk.close();
                    throw throwable;
                }
                revWalk.close();
                return this.diffs;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.diffs = new FileDiff[0];
        }
        return this.diffs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FileDiff[] getDiffs(RevCommit ... parents) {
        FileDiff[] diffsResult = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                RevWalk revWalk = new RevWalk(this.repository);
                try {
                    try (TreeWalk treewalk = new TreeWalk(revWalk.getObjectReader());){
                        treewalk.setRecursive(true);
                        treewalk.setFilter(TreeFilter.ANY_DIFF);
                        this.loadParents();
                        diffsResult = FileDiff.compute(this.repository, treewalk, this.commit, parents, TreeFilter.ALL);
                    }
                    if (revWalk == null) return diffsResult;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (revWalk == null) throw throwable;
                    revWalk.close();
                    throw throwable;
                }
                revWalk.close();
                return diffsResult;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return new FileDiff[0];
        }
    }

    private void loadParents() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (RevWalk revWalk = new RevWalk(this.repository);){
            RevCommit[] revCommitArray = this.commit.getParents();
            int n = revCommitArray.length;
            int n2 = 0;
            while (n2 < n) {
                RevCommit parent = revCommitArray[n2];
                revWalk.parseBody((RevObject)parent);
                ++n2;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public RepositoryCommitNote[] getNotes() {
        if (this.notes == null) {
            ArrayList<RepositoryCommitNote> noteList = new ArrayList<RepositoryCommitNote>();
            try {
                Repository repo = this.getRepository();
                Git git = Git.wrap((Repository)repo);
                RevCommit revCommit = this.getRevCommit();
                for (Ref ref : repo.getRefDatabase().getRefs("refs/notes/").values()) {
                    Note note = git.notesShow().setNotesRef(ref.getName()).setObjectId((RevObject)revCommit).call();
                    if (note == null) continue;
                    noteList.add(new RepositoryCommitNote(this, ref, note));
                }
                this.notes = noteList.toArray(new RepositoryCommitNote[noteList.size()]);
            }
            catch (Exception e) {
                Activator.logError("Error showing notes", e);
                this.notes = new RepositoryCommitNote[0];
            }
        }
        return this.notes;
    }

    public Object[] getChildren(Object o) {
        return new Object[0];
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return UIIcons.CHANGESET;
    }

    public String getLabel(Object o) {
        return this.abbreviate();
    }

    public Object getParent(Object o) {
        return null;
    }

    public StyledString getStyledText(Object object) {
        StyledString styled = new StyledString();
        styled.append(this.abbreviate());
        styled.append(": ");
        styled.append(this.commit.getShortMessage());
        PersonIdent author = this.commit.getAuthorIdent();
        PersonIdent committer = this.commit.getCommitterIdent();
        if (author != null && committer != null) {
            PreferenceBasedDateFormatter formatter = PreferenceBasedDateFormatter.create();
            if (author.getName().equals(committer.getName())) {
                styled.append(MessageFormat.format(UIText.RepositoryCommit_AuthorDate, author.getName(), formatter.formatDate(author)), StyledString.QUALIFIER_STYLER);
            } else {
                styled.append(MessageFormat.format(UIText.RepositoryCommit_AuthorDateCommitter, author.getName(), formatter.formatDate(author), committer.getName()), StyledString.QUALIFIER_STYLER);
            }
        }
        return styled;
    }

    public void setStash(boolean stash) {
        this.stash = stash;
    }

    public boolean isStash() {
        return this.stash;
    }
}

