/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.view;

import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.common.revision.delta.CDOFeatureDelta;
import org.eclipse.emf.cdo.transaction.CDOCommitContext;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler1;
import org.eclipse.emf.cdo.transaction.CDOTransactionHandler2;
import org.eclipse.emf.cdo.view.CDOObjectHandler;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewEvent;
import org.eclipse.net4j.util.container.SelfAttachingContainerListener;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.event.INotifier;

public class CDOViewEventProducer
extends SelfAttachingContainerListener.Delegating {
    private final CDOObjectHandler objectHandler = new CDOObjectHandler(){

        public void objectStateChanged(CDOView view, CDOObject object, CDOState oldState, CDOState newState) {
            CDOViewEventProducer.this.notifyOtherEvent(new CDOObjectStateChangedEvent(view, object, oldState, newState));
        }
    };
    private final CDOTransactionHandler1 transactionHandler1 = new CDOTransactionHandler1(){

        public void attachingObject(CDOTransaction transaction, CDOObject object) {
            CDOViewEventProducer.this.notifyOtherEvent(new CDOAttachingObjectEvent(transaction, object));
        }

        public void detachingObject(CDOTransaction transaction, CDOObject object) {
            CDOViewEventProducer.this.notifyOtherEvent(new CDODetachingObjectEvent(transaction, object));
        }

        public void modifyingObject(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
            CDOViewEventProducer.this.notifyOtherEvent(new CDOModifyingObjectEvent(transaction, object, featureDelta));
        }
    };
    private final CDOTransactionHandler2 transactionHandler2 = new CDOTransactionHandler2(){

        public void committingTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            CDOViewEventProducer.this.notifyOtherEvent(new CDOCommittingTransactionEvent(transaction, commitContext));
        }

        public void committedTransaction(CDOTransaction transaction, CDOCommitContext commitContext) {
            CDOViewEventProducer.this.notifyOtherEvent(new CDOCommittedTransactionEvent(transaction, commitContext));
        }

        public void rolledBackTransaction(CDOTransaction transaction) {
            CDOViewEventProducer.this.notifyOtherEvent(new CDORolledBackTransactionEvent(transaction));
        }
    };

    public CDOViewEventProducer(IListener delegate, boolean delegateContainerEvents) {
        super(delegate, delegateContainerEvents);
    }

    public CDOViewEventProducer(IListener delegate) {
        super(delegate);
    }

    public void attach(Object element) {
        if (element instanceof CDOView) {
            CDOView view = (CDOView)element;
            if (this.produceObjectStateChangedEvents()) {
                view.addObjectHandler(this.objectHandler);
            }
            if (view instanceof CDOTransaction) {
                CDOTransaction transaction = (CDOTransaction)view;
                if (this.produceObjectModificationEvents()) {
                    transaction.addTransactionHandler(this.transactionHandler1);
                }
                if (this.produceTransactionDemarcationEvents()) {
                    transaction.addTransactionHandler(this.transactionHandler2);
                }
            }
        }
        super.attach(element);
    }

    public void detach(Object element) {
        super.detach(element);
        if (element instanceof CDOView) {
            CDOView view = (CDOView)element;
            if (this.produceObjectStateChangedEvents()) {
                view.removeObjectHandler(this.objectHandler);
            }
            if (view instanceof CDOTransaction) {
                CDOTransaction transaction = (CDOTransaction)view;
                if (this.produceObjectModificationEvents()) {
                    transaction.removeTransactionHandler(this.transactionHandler1);
                }
                if (this.produceTransactionDemarcationEvents()) {
                    transaction.removeTransactionHandler(this.transactionHandler2);
                }
            }
        }
    }

    protected boolean produceObjectStateChangedEvents() {
        return true;
    }

    protected boolean produceObjectModificationEvents() {
        return true;
    }

    protected boolean produceTransactionDemarcationEvents() {
        return true;
    }

    public static final class CDOAttachingObjectEvent
    extends Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;
        private final CDOObject object;

        private CDOAttachingObjectEvent(CDOTransaction transaction, CDOObject object) {
            super((INotifier)transaction);
            this.object = object;
        }

        public CDOTransaction getSource() {
            return (CDOTransaction)super.getSource();
        }

        public CDOObject getObject() {
            return this.object;
        }

        protected String formatAdditionalParameters() {
            return "object=" + this.object;
        }
    }

    public static final class CDOCommittedTransactionEvent
    extends Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;
        private final CDOCommitContext commitContext;

        private CDOCommittedTransactionEvent(CDOTransaction transaction, CDOCommitContext commitContext) {
            super((INotifier)transaction);
            this.commitContext = commitContext;
        }

        public CDOTransaction getSource() {
            return (CDOTransaction)super.getSource();
        }

        public CDOCommitContext getCommitContext() {
            return this.commitContext;
        }

        protected String formatAdditionalParameters() {
            return "commitContext=" + this.commitContext;
        }
    }

    public static final class CDOCommittingTransactionEvent
    extends Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;
        private final CDOCommitContext commitContext;

        private CDOCommittingTransactionEvent(CDOTransaction transaction, CDOCommitContext commitContext) {
            super((INotifier)transaction);
            this.commitContext = commitContext;
        }

        public CDOTransaction getSource() {
            return (CDOTransaction)super.getSource();
        }

        public CDOCommitContext getCommitContext() {
            return this.commitContext;
        }

        protected String formatAdditionalParameters() {
            return "commitContext=" + this.commitContext;
        }
    }

    public static final class CDODetachingObjectEvent
    extends Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;
        private final CDOObject object;

        private CDODetachingObjectEvent(CDOTransaction transaction, CDOObject object) {
            super((INotifier)transaction);
            this.object = object;
        }

        public CDOTransaction getSource() {
            return (CDOTransaction)super.getSource();
        }

        public CDOObject getObject() {
            return this.object;
        }

        protected String formatAdditionalParameters() {
            return "object=" + this.object;
        }
    }

    public static final class CDOModifyingObjectEvent
    extends Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;
        private final CDOObject object;
        private final CDOFeatureDelta featureDelta;

        private CDOModifyingObjectEvent(CDOTransaction transaction, CDOObject object, CDOFeatureDelta featureDelta) {
            super((INotifier)transaction);
            this.object = object;
            this.featureDelta = featureDelta;
        }

        public CDOTransaction getSource() {
            return (CDOTransaction)super.getSource();
        }

        public CDOObject getObject() {
            return this.object;
        }

        public CDOFeatureDelta getFeatureDelta() {
            return this.featureDelta;
        }

        protected String formatAdditionalParameters() {
            return "object=" + this.object + ", featureDelta=" + this.featureDelta;
        }
    }

    public static final class CDOObjectStateChangedEvent
    extends Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;
        private final CDOObject object;
        private final CDOState oldState;
        private final CDOState newState;

        private CDOObjectStateChangedEvent(CDOView view, CDOObject object, CDOState oldState, CDOState newState) {
            super((INotifier)view);
            this.object = object;
            this.oldState = oldState;
            this.newState = newState;
        }

        public CDOView getSource() {
            return (CDOView)super.getSource();
        }

        public CDOObject getObject() {
            return this.object;
        }

        public CDOState getOldState() {
            return this.oldState;
        }

        public CDOState getNewState() {
            return this.newState;
        }

        protected String formatAdditionalParameters() {
            return "object=" + this.object + ", oldState=" + (Object)((Object)this.oldState) + ", newState=" + (Object)((Object)this.newState);
        }
    }

    public static final class CDORolledBackTransactionEvent
    extends Event
    implements CDOViewEvent {
        private static final long serialVersionUID = 1L;

        private CDORolledBackTransactionEvent(CDOTransaction transaction) {
            super((INotifier)transaction);
        }

        public CDOTransaction getSource() {
            return (CDOTransaction)super.getSource();
        }
    }
}

