/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport;

import java.util.Properties;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.EMFStoreMessageDialog;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport.CorruptedSourceException;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport.LdapImportSource;
import org.eclipse.emf.emfstore.internal.client.ui.dialogs.admin.acimport.Messages;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LdapSourceDialog
extends TitleAreaDialog {
    private boolean isOkPressed;
    private Text serverName;
    private Text ldapBase;
    private final LdapImportSource ldapImport;
    private boolean isInitFinished;

    public LdapSourceDialog(Shell parentShell, LdapImportSource ldapImport) {
        super(parentShell);
        this.ldapImport = ldapImport;
        this.setTitle(Messages.LdapSourceDialog_LDAPImport);
        this.isInitFinished = false;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.emf.emfstore.client.ui.help_import_ldap");
        Composite contents = new Composite(parent, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setTitle(Messages.LdapSourceDialog_LDAPServerData);
        this.setMessage(Messages.LdapSourceDialog_EnterServerData);
        Label name = new Label(contents, 0);
        name.setText(Messages.LdapSourceDialog_ServerName);
        this.serverName = new Text(contents, 2052);
        this.serverName.setSize(this.convertHorizontalDLUsToPixels(350), this.convertVerticalDLUsToPixels(20));
        Label desc = new Label(contents, 0);
        desc.setText(Messages.LdapSourceDialog_ServerBase);
        this.ldapBase = new Text(contents, 2052);
        this.ldapBase.setSize(this.convertHorizontalDLUsToPixels(350), this.convertVerticalDLUsToPixels(20));
        Point defaultMargins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().numColumns(2).margins(defaultMargins.x, defaultMargins.y).generateLayout(contents);
        return contents;
    }

    public void okPressed() {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        progressMonitorDialog.open();
        progressMonitorDialog.getProgressMonitor().beginTask(Messages.LdapSourceDialog_Connecting, -1);
        Properties serverProperties = new Properties();
        serverProperties.put("java.naming.provider.url", this.serverName.getText());
        serverProperties.put("ldapbase", this.ldapBase.getText());
        this.ldapImport.setProperties(serverProperties);
        try {
            this.ldapImport.connect();
            this.isInitFinished = true;
            progressMonitorDialog.close();
        }
        catch (CorruptedSourceException e) {
            progressMonitorDialog.close();
            this.isInitFinished = false;
            EMFStoreMessageDialog.showExceptionDialog(Messages.LdapSourceDialog_ExceptionMessage, (Exception)e);
        }
        this.isOkPressed = true;
        this.close();
    }

    protected void cancelPressed() {
        this.isOkPressed = false;
        this.close();
    }

    public boolean getIsInitFinished() {
        return this.isOkPressed && this.isInitFinished;
    }
}

