/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.model.util;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.emfstore.client.ESLocalProject;
import org.eclipse.emf.emfstore.client.handler.ESChecksumErrorHandler;
import org.eclipse.emf.emfstore.internal.client.common.UnknownEMFStoreWorkloadCommand;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESLocalProjectImpl;
import org.eclipse.emf.emfstore.internal.client.model.util.LogDetailed;
import org.eclipse.emf.emfstore.internal.client.model.util.Messages;
import org.eclipse.emf.emfstore.internal.client.model.util.WorkspaceUtil;
import org.eclipse.emf.emfstore.internal.common.model.Project;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.ProjectId;
import org.eclipse.emf.emfstore.internal.server.model.SessionId;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESGlobalProjectIdImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.ESSessionIdImpl;
import org.eclipse.emf.emfstore.internal.server.model.impl.api.versionspec.ESVersionSpecImpl;
import org.eclipse.emf.emfstore.internal.server.model.versioning.VersionSpec;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.emf.emfstore.server.model.versionspec.ESPrimaryVersionSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ChecksumErrorHandler implements ESChecksumErrorHandler
{
    LOG{

        public boolean execute(ESLocalProject project, ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
            WorkspaceUtil.logWarning(Messages.ChecksumErrorHandler_ChecksumComparisionFailed, null);
            return true;
        }
    }
    ,
    LOG_DETAILED{

        public boolean execute(ESLocalProject localProject, ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
            return LogDetailed.execute(localProject, versionSpec, monitor, false);
        }
    }
    ,
    LOG_DETAILED_AND_CANCEL{

        public boolean execute(ESLocalProject localProject, ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
            return LogDetailed.execute(localProject, versionSpec, monitor, true);
        }
    }
    ,
    CANCEL{

        public boolean execute(ESLocalProject project, ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
            return false;
        }
    }
    ,
    AUTOCORRECT{

        public boolean execute(final ESLocalProject project, final ESPrimaryVersionSpec versionSpec, IProgressMonitor monitor) throws ESException {
            ESLocalProjectImpl localProjectImpl = (ESLocalProjectImpl)project;
            ProjectSpace projectSpace = (ProjectSpace)localProjectImpl.toInternalAPI();
            Resource projectResource = ((ProjectSpace)localProjectImpl.toInternalAPI()).getProject().eResource();
            Project fetchedProject = (Project)new UnknownEMFStoreWorkloadCommand<Project>(monitor){

                @Override
                public Project run(IProgressMonitor monitor) throws ESException {
                    ESSessionIdImpl sessionIdImpl = (ESSessionIdImpl)project.getUsersession().getSessionId();
                    ESGlobalProjectIdImpl globalProjectIdImpl = (ESGlobalProjectIdImpl)project.getRemoteProject().getGlobalProjectId();
                    ESVersionSpecImpl versionSpecImpl = (ESVersionSpecImpl)versionSpec;
                    return ESWorkspaceProviderImpl.getInstance().getConnectionManager().getProject((SessionId)sessionIdImpl.toInternalAPI(), (ProjectId)globalProjectIdImpl.toInternalAPI(), (VersionSpec)ModelUtil.clone((EObject)((VersionSpec)versionSpecImpl.toInternalAPI())));
                }
            }.execute();
            if (fetchedProject == null) {
                throw new ESException(Messages.ChecksumErrorHandler_ServerReturnedNullProject);
            }
            projectResource.getContents().clear();
            projectResource.getContents().add((Object)fetchedProject);
            try {
                projectResource.save(ModelUtil.getResourceSaveOptions());
            }
            catch (IOException iOException) {
                throw new ESException(Messages.ChecksumErrorHandler_SaveFailedWhileAutocorrect);
            }
            projectSpace.setProject(fetchedProject);
            projectSpace.init();
            return true;
        }
    };


    private ChecksumErrorHandler() {
    }

    /* synthetic */ ChecksumErrorHandler(String string, int n, ChecksumErrorHandler checksumErrorHandler) {
        this();
    }
}

