/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfforms.spi.swt.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emfforms.spi.localization.LocalizationServiceHelper;
import org.eclipse.emfforms.spi.swt.table.ButtonBarBuilder;
import org.eclipse.emfforms.spi.swt.table.NewElementCreator;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public final class DefaultButtonBarBuilder
implements ButtonBarBuilder {
    private NewElementCreator<Object, Button> creator;

    @Override
    public void fillButtonComposite(Composite buttonComposite, AbstractTableViewer viewer) {
        this.addLayoutToButtonComposite(buttonComposite);
        this.createAddButton(buttonComposite, viewer);
        this.createRemoveButton(buttonComposite, viewer);
    }

    protected void addLayoutToButtonComposite(Composite buttonComposite) {
        GridLayoutFactory.fillDefaults().numColumns(this.getNumberOfColumns()).equalWidth(false).applyTo(buttonComposite);
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    protected void createRemoveButton(Composite buttonComposite, final AbstractTableViewer viewer) {
        Button removeButton = new Button(buttonComposite, 8);
        removeButton.setText(LocalizationServiceHelper.getString(DefaultButtonBarBuilder.class, (String)"DefaultButtonBarBuilder_RemoveButtonText"));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object input = viewer.getInput();
                if (Collection.class.isInstance(input)) {
                    Collection collection = (Collection)Collection.class.cast(input);
                    IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                    if (selection == null || selection.getFirstElement() == null) {
                        return;
                    }
                    ArrayList deletionList = new ArrayList();
                    Iterator iterator = selection.iterator();
                    while (iterator.hasNext()) {
                        deletionList.add(iterator.next());
                    }
                    collection.removeAll(deletionList);
                }
            }
        });
    }

    protected void createAddButton(Composite buttonComposite, final AbstractTableViewer viewer) {
        final Button addButton = new Button(buttonComposite, 8);
        addButton.setText(LocalizationServiceHelper.getString(DefaultButtonBarBuilder.class, (String)"DefaultButtonBarBuilder_AddButtonText"));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object input = viewer.getInput();
                if (Collection.class.isInstance(input)) {
                    Collection collection = (Collection)Collection.class.cast(input);
                    Object newElement = DefaultButtonBarBuilder.this.createNewElement(addButton);
                    if (newElement == null) {
                        return;
                    }
                    collection.add(newElement);
                }
            }
        });
        if (this.creator == null) {
            addButton.setEnabled(false);
            addButton.setToolTipText(LocalizationServiceHelper.getString(DefaultButtonBarBuilder.class, (String)"DefaultButtonBarBuilder_AddButtonTooltipNoCreator"));
        }
    }

    @Override
    public Object createNewElement(Button button) {
        if (this.creator == null) {
            return null;
        }
        return this.creator.createNewElement(button);
    }

    public void setCreator(NewElementCreator<Object, Button> creator) {
        this.creator = creator;
    }
}

