/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.geometry.planar;

import java.awt.geom.NoninvertibleTransformException;
import org.eclipse.gef.geometry.convert.awt.AWT2Geometry;
import org.eclipse.gef.geometry.convert.awt.Geometry2AWT;
import org.eclipse.gef.geometry.euclidean.Angle;
import org.eclipse.gef.geometry.planar.Point;

public class AffineTransform
implements Cloneable {
    private java.awt.geom.AffineTransform delegate = new java.awt.geom.AffineTransform();

    public AffineTransform() {
    }

    public AffineTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.delegate = new java.awt.geom.AffineTransform(m00, m10, m01, m11, m02, m12);
    }

    public AffineTransform(double[] flatmatrix) {
        this.delegate = new java.awt.geom.AffineTransform(flatmatrix);
    }

    private AffineTransform(java.awt.geom.AffineTransform delegate) {
        this.delegate = delegate;
    }

    public Object clone() {
        return this.delegate.clone();
    }

    public AffineTransform concatenate(AffineTransform Tx) {
        this.delegate.concatenate(Tx.delegate);
        return this;
    }

    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        this.delegate.deltaTransform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public Point deltaTransform(Point pt) {
        return AWT2Geometry.toPoint(this.delegate.deltaTransform(Geometry2AWT.toAWTPoint(pt), null));
    }

    public boolean equals(Object obj) {
        if (obj instanceof AffineTransform) {
            return this.delegate.equals(((AffineTransform)obj).delegate);
        }
        return false;
    }

    public AffineTransform getCopy() {
        return new AffineTransform(this.getMatrix());
    }

    public double getDeterminant() {
        return this.delegate.getDeterminant();
    }

    public AffineTransform getInverse() {
        try {
            return new AffineTransform(this.delegate.createInverse());
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public double getM00() {
        return this.delegate.getScaleX();
    }

    public double getM01() {
        return this.delegate.getShearX();
    }

    public double getM10() {
        return this.delegate.getShearY();
    }

    public double getM11() {
        return this.delegate.getScaleY();
    }

    public double[] getMatrix() {
        double[] flatmatrix = new double[6];
        this.delegate.getMatrix(flatmatrix);
        return flatmatrix;
    }

    public Angle getRotation() {
        double rad = Math.atan2(this.getM01(), this.getM00());
        return Angle.fromRad(rad);
    }

    public double getScaleX() {
        return Math.sqrt(this.getM00() * this.getM00() + this.getM10() * this.getM10());
    }

    public double getScaleY() {
        return Math.sqrt(this.getM01() * this.getM01() + this.getM11() * this.getM11());
    }

    public Point getTransformed(Point ptSrc) {
        return AWT2Geometry.toPoint(this.delegate.transform(Geometry2AWT.toAWTPoint(ptSrc), null));
    }

    public Point[] getTransformed(Point[] points) {
        Point[] result = new Point[points.length];
        int i = 0;
        while (i < points.length) {
            result[i] = this.getTransformed(points[i]);
            ++i;
        }
        return result;
    }

    public double getTranslateX() {
        return this.delegate.getTranslateX();
    }

    public double getTranslateY() {
        return this.delegate.getTranslateY();
    }

    public int getType() {
        return this.delegate.getType();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void inverseTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) throws NoninvertibleTransformException {
        this.delegate.inverseTransform(srcPts, srcOff, dstPts, dstOff, numPts);
    }

    public Point inverseTransform(Point pt) throws NoninvertibleTransformException {
        return AWT2Geometry.toPoint(this.delegate.inverseTransform(Geometry2AWT.toAWTPoint(pt), null));
    }

    public AffineTransform invert() throws NoninvertibleTransformException {
        this.delegate.invert();
        return this;
    }

    public boolean isIdentity() {
        return this.delegate.isIdentity();
    }

    public AffineTransform preConcatenate(AffineTransform Tx) {
        this.delegate.preConcatenate(Tx.delegate);
        return this;
    }

    public AffineTransform quadrantRotate(int numquadrants) {
        this.delegate.quadrantRotate(numquadrants);
        return this;
    }

    public AffineTransform quadrantRotate(int numquadrants, double anchorx, double anchory) {
        this.delegate.quadrantRotate(numquadrants, anchorx, anchory);
        return this;
    }

    public AffineTransform rotate(double theta) {
        this.delegate.rotate(theta);
        return this;
    }

    public AffineTransform rotate(double vecx, double vecy) {
        this.delegate.rotate(vecx, vecy);
        return this;
    }

    public AffineTransform rotate(double theta, double anchorx, double anchory) {
        this.delegate.rotate(theta, anchorx, anchory);
        return this;
    }

    public AffineTransform rotate(double vecx, double vecy, double anchorx, double anchory) {
        this.delegate.rotate(vecx, vecy, anchorx, anchory);
        return this;
    }

    public AffineTransform scale(double sx, double sy) {
        this.delegate.scale(sx, sy);
        return this;
    }

    public AffineTransform setToIdentity() {
        this.delegate.setToIdentity();
        return this;
    }

    public AffineTransform setToQuadrantRotation(int numquadrants) {
        this.delegate.setToQuadrantRotation(numquadrants);
        return this;
    }

    public AffineTransform setToQuadrantRotation(int numquadrants, double anchorx, double anchory) {
        this.delegate.setToQuadrantRotation(numquadrants, anchorx, anchory);
        return this;
    }

    public AffineTransform setToRotation(double theta) {
        this.delegate.setToRotation(theta);
        return this;
    }

    public AffineTransform setToRotation(double vecx, double vecy) {
        this.delegate.setToRotation(vecx, vecy);
        return this;
    }

    public AffineTransform setToRotation(double theta, double anchorx, double anchory) {
        this.delegate.setToRotation(theta, anchorx, anchory);
        return this;
    }

    public AffineTransform setToRotation(double vecx, double vecy, double anchorx, double anchory) {
        this.delegate.setToRotation(vecx, vecy, anchorx, anchory);
        return this;
    }

    public AffineTransform setToScale(double sx, double sy) {
        this.delegate.setToScale(sx, sy);
        return this;
    }

    public AffineTransform setToShear(double shx, double shy) {
        this.delegate.setToShear(shx, shy);
        return this;
    }

    public AffineTransform setToTranslation(double tx, double ty) {
        this.delegate.setToTranslation(tx, ty);
        return this;
    }

    public AffineTransform setTransform(AffineTransform Tx) {
        this.delegate.setTransform(Tx.delegate);
        return this;
    }

    public AffineTransform setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.delegate.setTransform(m00, m10, m01, m11, m02, m12);
        return this;
    }

    public AffineTransform shear(double shx, double shy) {
        this.delegate.shear(shx, shy);
        return this;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public AffineTransform translate(double tx, double ty) {
        this.delegate.translate(tx, ty);
        return this;
    }
}

