/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.lookup.ModuleBinding;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.builder.ClasspathDirectory;
import org.eclipse.jdt.internal.core.builder.ClasspathJMod;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathJrt;
import org.eclipse.jdt.internal.core.builder.ClasspathMultiDirectory;

public abstract class ClasspathLocation {
    protected boolean isOnModulePath;
    protected IModule module;

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3, String var4);

    public abstract NameEnvironmentAnswer findClass(String var1, String var2, String var3, String var4, boolean var5);

    public abstract boolean isPackage(String var1, String var2);

    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        return this.singletonModuleNameIf(this.isPackage(qualifiedPackageName, moduleName));
    }

    public boolean hasModule() {
        return this.getModule() != null;
    }

    public abstract boolean hasCompilationUnit(String var1, String var2);

    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly) {
        String fileName = new String(typeName);
        return this.findClass(fileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly);
    }

    public void setModule(IModule mod) {
        this.module = mod;
    }

    public IModule getModule() {
        return this.module;
    }

    static ClasspathLocation forSourceFolder(IContainer sourceFolder, IContainer outputFolder, char[][] inclusionPatterns, char[][] exclusionPatterns, boolean ignoreOptionalProblems) {
        return new ClasspathMultiDirectory(sourceFolder, outputFolder, inclusionPatterns, exclusionPatterns, ignoreOptionalProblems);
    }

    public static ClasspathLocation forBinaryFolder(IContainer binaryFolder, boolean isOutputFolder, AccessRuleSet accessRuleSet, IPath externalAnnotationPath, boolean autoModule) {
        return new ClasspathDirectory(binaryFolder, isOutputFolder, accessRuleSet, externalAnnotationPath, autoModule);
    }

    static ClasspathLocation forLibrary(String libraryPathname, long lastModified, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean autoModule) {
        return Util.isJrt(libraryPathname) ? new ClasspathJrt(libraryPathname, annotationsPath) : (Util.archiveFormat(libraryPathname) == 1 ? new ClasspathJMod(libraryPathname, lastModified, accessRuleSet, annotationsPath) : new ClasspathJar(libraryPathname, lastModified, accessRuleSet, annotationsPath, autoModule));
    }

    public static ClasspathLocation forLibrary(String libraryPathname, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean autoModule) {
        return ClasspathLocation.forLibrary(libraryPathname, 0L, accessRuleSet, annotationsPath, autoModule);
    }

    static ClasspathLocation forLibrary(IFile library, AccessRuleSet accessRuleSet, IPath annotationsPath, boolean autoModule) {
        return new ClasspathJar(library, accessRuleSet, annotationsPath, autoModule);
    }

    public abstract IPath getProjectRelativePath();

    public boolean isOutputFolder() {
        return false;
    }

    public void cleanup() {
    }

    public void reset() {
    }

    public abstract String debugPathString();

    public char[][] singletonModuleNameIf(boolean condition) {
        if (!condition) {
            return null;
        }
        if (this.module != null) {
            return new char[][]{this.module.name()};
        }
        return new char[][]{ModuleBinding.UNNAMED};
    }
}

