/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpadiagrameditor.ui.internal.feature;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.features.context.ILayoutContext;
import org.eclipse.graphiti.features.context.impl.LayoutContext;
import org.eclipse.graphiti.features.custom.AbstractCustomFeature;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.Diagram;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.ui.editor.IDiagramContainerUI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jpt.common.core.JptResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.utility.model.event.CollectionAddEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionChangeEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionClearEvent;
import org.eclipse.jpt.common.utility.model.event.CollectionRemoveEvent;
import org.eclipse.jpt.common.utility.model.listener.CollectionChangeListener;
import org.eclipse.jpt.jpa.core.JpaFile;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.context.AttributeMapping;
import org.eclipse.jpt.jpa.core.context.PersistentAttribute;
import org.eclipse.jpt.jpa.core.context.PersistentType;
import org.eclipse.jpt.jpa.core.context.RelationshipMapping;
import org.eclipse.jpt.jpa.core.context.SpecifiedMappedByRelationshipStrategy;
import org.eclipse.jpt.jpa.core.context.persistence.PersistenceUnit;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.JPADiagramEditorPlugin;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.feature.RenameEntityFeature;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.provider.IJPAEditorFeatureProvider;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.GraphicsUpdater;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPAEditorUtil;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JPASolver;
import org.eclipse.jpt.jpadiagrameditor.ui.internal.util.JpaArtifactFactory;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;

public abstract class RefactorEntityFeature
extends AbstractCustomFeature {
    protected Set<PersistentAttribute> ats = null;
    protected boolean hasEntitySpecifiedName = false;
    private static final String REGEX_PATTERN = "(_[\\d]+)*";

    public RefactorEntityFeature(IFeatureProvider fp) {
        super(fp);
    }

    public boolean isAvailable(IContext context) {
        if (!(context instanceof ICustomContext)) {
            return false;
        }
        ICustomContext ctx = (ICustomContext)context;
        PictogramElement pe = ctx.getInnerPictogramElement();
        Object bo = this.getFeatureProvider().getBusinessObjectForPictogramElement(pe);
        if (bo instanceof PersistentType) {
            PersistentType jpt = (PersistentType)bo;
            this.ats = JpaArtifactFactory.instance().getRelatedAttributes(jpt);
            this.hasEntitySpecifiedName = JpaArtifactFactory.instance().hasEntitySpecifiedName(jpt);
            return true;
        }
        if (pe instanceof Shape) {
            ContainerShape cs = ((Shape)pe).getContainer();
            if (cs == null) {
                return false;
            }
            bo = this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)cs);
            if (bo instanceof PersistentType) {
                PersistentType jpt = (PersistentType)bo;
                this.ats = JpaArtifactFactory.instance().getRelatedAttributes(jpt);
                this.hasEntitySpecifiedName = JpaArtifactFactory.instance().hasEntitySpecifiedName(jpt);
                return true;
            }
        }
        return false;
    }

    public boolean canExecute(ICustomContext context) {
        return true;
    }

    public void execute(ICustomContext context, SelectionDispatchAction action) {
        PictogramElement pe = context.getInnerPictogramElement();
        final ContainerShape pict = ((Shape)pe).getContainer();
        final PersistentType jpt = (PersistentType)this.getBusinessObjectForPictogramElement((PictogramElement)pict);
        ICompilationUnit cu = this.getFeatureProvider().getCompilationUnit(jpt);
        StructuredSelection sel = new StructuredSelection((Object)cu);
        final PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpt);
        Semaphore s = new Semaphore(0);
        final JPAProjectListener lsnr = new JPAProjectListener(s);
        jpt.getJpaProject().addCollectionChangeListener("jpaFiles", (CollectionChangeListener)lsnr);
        ShowBusy showBusy = new ShowBusy(s);
        JPASolver.ignoreEvents = true;
        try {
            action.run((IStructuredSelection)sel);
        }
        catch (Exception exception) {}
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)showBusy);
        jpt.getJpaProject().removeCollectionChangeListener("jpaFiles", (CollectionChangeListener)lsnr);
        JPASolver.ignoreEvents = false;
        final boolean rename = RenameEntityFeature.class.isInstance((Object)this);
        if (!showBusy.isMoved()) {
            return;
        }
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pict);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                RefactorEntityFeature.this.remapEntity(jpt, (Shape)pict, pu, rename, lsnr, RefactorEntityFeature.this.getFeatureProvider());
            }
        });
    }

    public void execute(ICustomContext context, String newName, ICompilationUnit cu, PersistentType originalJPT) {
        final Shape pict = (Shape)this.getFeatureProvider().getPictogramElementForBusinessObject(originalJPT);
        final PersistentType jpt = (PersistentType)this.getFeatureProvider().getBusinessObjectForPictogramElement((PictogramElement)pict);
        final PersistenceUnit pu = JpaArtifactFactory.instance().getPersistenceUnit(jpt);
        Semaphore s = new Semaphore(0);
        final JPAProjectListener lsnr = new JPAProjectListener(s);
        jpt.getJpaProject().addCollectionChangeListener("jpaFiles", (CollectionChangeListener)lsnr);
        ShowBusy showBusy = new ShowBusy(s);
        JPASolver.ignoreEvents = true;
        JpaArtifactFactory.instance().renameEntityClass(jpt, newName);
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)showBusy);
        jpt.getJpaProject().removeCollectionChangeListener("jpaFiles", (CollectionChangeListener)lsnr);
        JPASolver.ignoreEvents = false;
        TransactionalEditingDomain ted = TransactionUtil.getEditingDomain((EObject)pict);
        ted.getCommandStack().execute((Command)new RecordingCommand(ted){

            protected void doExecute() {
                RefactorEntityFeature.this.remapEntity(jpt, pict, pu, true, lsnr, RefactorEntityFeature.this.getFeatureProvider());
            }
        });
    }

    public void remapEntity(final PersistentType oldJPT, final Shape pict, final PersistenceUnit pu, final boolean rename, final JPAProjectListener lsnr, final IJPAEditorFeatureProvider fp) {
        BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

            @Override
            public void run() {
                PersistentType newJPT;
                fp.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer().selectPictogramElements(new PictogramElement[0]);
                String newJPTName = lsnr.getNewJPTName();
                lsnr.setOldJptName(oldJPT.getSimpleName());
                if (!JpaPreferences.getDiscoverAnnotatedClasses((IProject)oldJPT.getJpaProject().getProject())) {
                    JPAEditorUtil.createUnregisterEntityFromXMLJob(oldJPT.getJpaProject(), oldJPT.getName());
                    JPAEditorUtil.createRegisterEntityInXMLJob(oldJPT.getJpaProject(), newJPTName);
                }
                if ((newJPT = JpaArtifactFactory.instance().getJPT(newJPTName, pu)) == null) {
                    return;
                }
                if (rename) {
                    String tableName = JPAEditorUtil.formTableName(newJPT);
                    JpaArtifactFactory.instance().setTableName(newJPT, tableName);
                }
                GraphicsUpdater.updateHeader((ContainerShape)pict, newJPT.getSimpleName());
                this.linkNewElement(oldJPT, (PictogramElement)pict, fp, newJPT);
                for (PersistentAttribute oldAttr : oldJPT.getAttributes()) {
                    PictogramElement attrPict = fp.getPictogramElementForBusinessObject(oldAttr);
                    if (attrPict == null) continue;
                    for (PersistentAttribute newAttr : newJPT.getAttributes()) {
                        if (!newAttr.getName().equals(oldAttr.getName())) continue;
                        this.linkNewElement(oldAttr, attrPict, fp, newAttr);
                    }
                }
                fp.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer().setPictogramElementForSelection((PictogramElement)pict);
                IWorkbenchPartSite ws = ((IDiagramContainerUI)fp.getDiagramTypeProvider().getDiagramBehavior().getDiagramContainer()).getSite();
                ICompilationUnit cu = fp.getCompilationUnit(newJPT);
                fp.getJPAEditorUtil().formatCode(cu, (IWorkbenchSite)ws);
            }

            private void linkNewElement(Object oldBO, PictogramElement pict2, IJPAEditorFeatureProvider fp2, Object newBO) {
                String newBoKey;
                fp2.link((PictogramElement)((ContainerShape)pict2), newBO);
                LayoutContext context = new LayoutContext((PictogramElement)((ContainerShape)pict2));
                fp2.layoutIfPossible((ILayoutContext)context);
                String oldBoKey = fp2.getKeyForBusinessObject(oldBO);
                if (oldBoKey != null) {
                    fp2.remove(oldBoKey);
                }
                if (fp2.getBusinessObjectForKey(newBoKey = fp2.getKeyForBusinessObject(newBO)) == null) {
                    fp2.putKeyToBusinessObject(newBoKey, newBO);
                }
            }
        });
    }

    protected Diagram getDiagram() {
        return this.getFeatureProvider().getDiagramTypeProvider().getDiagram();
    }

    public IJPAEditorFeatureProvider getFeatureProvider() {
        return (IJPAEditorFeatureProvider)super.getFeatureProvider();
    }

    public class JPAProjectListener
    implements CollectionChangeListener {
        private Semaphore s = null;
        private String newJptName = null;
        private String oldJptName = null;

        public JPAProjectListener(Semaphore s) {
            this.s = s;
        }

        public void itemsAdded(CollectionAddEvent event) {
            Iterator it = event.getItems().iterator();
            Object o = it.next();
            JpaFile jpaFile = (JpaFile)o;
            JptResourceModel rm = jpaFile.getResourceModel();
            if (rm == null) {
                return;
            }
            if (!JavaResourceCompilationUnit.class.isInstance(rm)) {
                return;
            }
            JavaResourceCompilationUnit jrcu = (JavaResourceCompilationUnit)rm;
            IType type = jrcu.getCompilationUnit().findPrimaryType();
            this.newJptName = type.getFullyQualifiedName();
            this.s.release();
            if (RefactorEntityFeature.this.ats == null || RefactorEntityFeature.this.hasEntitySpecifiedName) {
                return;
            }
            final Iterator<PersistentAttribute> iter = RefactorEntityFeature.this.ats.iterator();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    Hashtable<String, String> atOldToNewName = new Hashtable<String, String>();
                    HashSet<PersistentAttribute> newSelfAts = new HashSet<PersistentAttribute>();
                    while (iter.hasNext()) {
                        PersistentAttribute at = (PersistentAttribute)iter.next();
                        String attributeNamPattern = String.valueOf(JPAEditorUtil.decapitalizeFirstLetter(JPAProjectListener.this.oldJptName)) + RefactorEntityFeature.REGEX_PATTERN;
                        boolean isSame = at.getName().matches(attributeNamPattern);
                        if (!isSame) continue;
                        PersistentType atParent = (PersistentType)at.getParent();
                        ICompilationUnit cu = RefactorEntityFeature.this.getFeatureProvider().getCompilationUnit(atParent);
                        if (!cu.exists()) {
                            at = at.getPersistenceUnit().getPersistentType(JPAProjectListener.this.newJptName).getAttributeNamed(at.getName());
                            try {
                                PersistentAttribute newAt = JpaArtifactFactory.instance().renameAttribute(atParent, at.getName(), JPAEditorUtil.returnSimpleName(JPAProjectListener.this.newJptName), JPAProjectListener.this.newJptName, RefactorEntityFeature.this.getFeatureProvider());
                                if (newAt == null) continue;
                                atOldToNewName.put(at.getName(), newAt.getName());
                                newSelfAts.add(newAt);
                            }
                            catch (InterruptedException e) {
                                JPADiagramEditorPlugin.logError(e);
                            }
                            continue;
                        }
                        try {
                            JpaArtifactFactory.instance().renameAttribute(atParent, at.getName(), JPAEditorUtil.returnSimpleName(JPAProjectListener.this.newJptName), JPAProjectListener.this.newJptName, RefactorEntityFeature.this.getFeatureProvider());
                        }
                        catch (InterruptedException e) {
                            JPADiagramEditorPlugin.logError(e);
                        }
                    }
                    for (PersistentAttribute at : newSelfAts) {
                        String newMappedBy;
                        SpecifiedMappedByRelationshipStrategy mappedByRelationShipStrategy;
                        String oldMappedBy;
                        AttributeMapping m = JpaArtifactFactory.instance().getAttributeMapping(at);
                        if (!(m instanceof RelationshipMapping) || (oldMappedBy = (mappedByRelationShipStrategy = (SpecifiedMappedByRelationshipStrategy)((RelationshipMapping)m).getRelationship().getStrategy()).getMappedByAttribute()) == null || (newMappedBy = (String)atOldToNewName.get(oldMappedBy)) == null) continue;
                        mappedByRelationShipStrategy.setMappedByAttribute(newMappedBy);
                    }
                }
            };
            Display.getDefault().asyncExec(r);
        }

        public void itemsRemoved(CollectionRemoveEvent arg0) {
            this.s.release();
        }

        public void collectionChanged(CollectionChangeEvent event) {
        }

        public void collectionCleared(CollectionClearEvent arg0) {
        }

        public String getNewJPTName() {
            return this.newJptName;
        }

        public void setOldJptName(String oldJptName) {
            this.oldJptName = oldJptName;
        }
    }

    class ShowBusy
    implements Runnable {
        private Semaphore s;
        boolean moved = false;

        ShowBusy(Semaphore s) {
            this.s = s;
        }

        @Override
        public void run() {
            try {
                this.moved = this.s.tryAcquire(2, 4L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                JPADiagramEditorPlugin.logError("Thread interrupted", e);
            }
        }

        boolean isMoved() {
            return this.moved;
        }
    }
}

