/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.ui.refactoring.RenameContextRootChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.ParticipantManager;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public class RenameContextRootRefactoringProcessor
extends RenameProcessor {
    private IProject fProject;
    private String fNewName;
    private boolean fUpdateReferences;

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        if (!this.isApplicable()) {
            return RefactoringStatus.createErrorStatus((String)J2EEUIMessages.getResourceString("RefactoringNoInit"));
        }
        return this.validateNewElementName(this.fNewName);
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        if (this.isApplicable() && this.fNewName != null) {
            return new RenameContextRootChange(this.getProject(), this.fNewName, this.getOldContextRoot());
        }
        return null;
    }

    public Object[] getElements() {
        if (this.getProject() == null) {
            return new Object[0];
        }
        return new Object[]{this.getProject()};
    }

    public String getIdentifier() {
        return "org.eclipse.jst.j2ee.ChangeContextRootRefactoringProcessor";
    }

    public String getProcessorName() {
        return J2EEUIMessages.getResourceString("RenameContextRoot");
    }

    public IProject getProject() {
        return this.fProject;
    }

    public boolean isApplicable() throws CoreException {
        return this.getProject() != null;
    }

    private RenameArguments getRenameArguments() {
        return new RenameArguments(this.fNewName, this.fUpdateReferences);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        String[] natures = new String[]{};
        IProject project = this.getProject();
        if (project != null && this.fNewName != null) {
            natures = project.getDescription().getNatureIds();
            return ParticipantManager.loadRenameParticipants((RefactoringStatus)status, (RefactoringProcessor)this, (Object)project, (RenameArguments)this.getRenameArguments(), (String[])natures, (SharableParticipants)sharedParticipants);
        }
        return new RefactoringParticipant[0];
    }

    public void setProject(IProject project) {
        this.fProject = project;
    }

    public void setNewName(String newName) {
        this.fNewName = newName;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.fUpdateReferences = updateReferences;
    }

    public RefactoringStatus validateNewElementName(String newName) {
        return RefactoringStatus.create((IStatus)RenameContextRootChange.validateContextRoot(newName));
    }

    public String getOldContextRoot() {
        return J2EEProjectUtilities.getServerContextRoot((IProject)this.getProject());
    }
}

