/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facelet.core.internal.registry;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.jsf.common.dom.TagIdentifier;
import org.eclipse.jst.jsf.common.runtime.internal.model.component.ComponentTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ConverterTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.decorator.ValidatorTypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.model.types.TypeInfo;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.IHandlerTagElement;
import org.eclipse.jst.jsf.common.runtime.internal.view.model.common.ITagElement;
import org.eclipse.jst.jsf.core.internal.tld.TagIdentifierFactory;
import org.eclipse.jst.jsf.designtime.internal.Messages;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ViewMetadataLoader;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.ViewMetadataMapper;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.TagMapping;
import org.eclipse.jst.jsf.designtime.internal.view.mapping.viewmapping.TagToViewObjectMapping;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.AbstractTagResolvingStrategy;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.DefaultTagTypeInfo;
import org.eclipse.jst.jsf.designtime.internal.view.model.jsp.IAttributeAdvisor;
import org.eclipse.jst.jsf.facelet.core.internal.cm.FaceletDocumentFactory;
import org.eclipse.jst.jsf.facelet.core.internal.registry.IFaceletTagResolvingStrategy;
import org.eclipse.jst.jsf.facelet.core.internal.registry.MetadataAttributeAdvisor;
import org.eclipse.jst.jsf.facelet.core.internal.registry.taglib.faceletTaglib.FaceletTaglibTagAttribute;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.ComponentTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.ConverterTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.HandlerTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.NoArchetypeFaceletTag;
import org.eclipse.jst.jsf.facelet.core.internal.tagmodel.ValidatorTag;
import org.osgi.framework.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaceletMetaResolvingStrategy
extends AbstractTagResolvingStrategy<IFaceletTagResolvingStrategy.TLDWrapper, String>
implements IFaceletTagResolvingStrategy {
    public static final String ID = "org.eclipse.jst.jsf.facelet.metadata.FaceletMetaResolvingStrategy";
    public static final String DISPLAY_NAME = Messages.DefaultJSPTagResolver_DisplayName;
    private final ViewMetadataLoader _loader;
    private final ViewMetadataMapper _mapper;
    private final FaceletDocumentFactory _factory;

    public FaceletMetaResolvingStrategy(IProject project, FaceletDocumentFactory factory) {
        this._factory = factory;
        this._loader = new ViewMetadataLoader(project);
        this._mapper = new ViewMetadataMapper();
    }

    public ITagElement resolve(IFaceletTagResolvingStrategy.TLDWrapper elementDecl) {
        String uri = elementDecl.getUri();
        String tagName = elementDecl.getTagDefn().getTagName();
        TagIdentifier tagId = TagIdentifierFactory.createJSPTagWrapper((String)uri, (String)tagName);
        TagMapping mapping = this._loader.getTagToViewMapping(tagId);
        TypeInfo elementType = null;
        if (mapping != null) {
            elementType = this.findTypeInfo(mapping, "1.1", null);
        }
        EList<FaceletTaglibTagAttribute> attributes = elementDecl.getTagDefn().getAttribute();
        if (elementType instanceof ComponentTypeInfo) {
            return new ComponentTag(uri, tagName, (ComponentTypeInfo)elementType, null, this._factory, (IAttributeAdvisor)new MetadataAttributeAdvisor(tagId, this._loader, (List<FaceletTaglibTagAttribute>)attributes));
        }
        if (elementType instanceof ConverterTypeInfo) {
            return new ConverterTag(uri, tagName, (ConverterTypeInfo)elementType, null, this._factory, (IAttributeAdvisor)new MetadataAttributeAdvisor(tagId, this._loader, (List<FaceletTaglibTagAttribute>)attributes));
        }
        if (elementType instanceof ValidatorTypeInfo) {
            return new ValidatorTag(uri, tagName, (ValidatorTypeInfo)elementType, null, this._factory, (IAttributeAdvisor)new MetadataAttributeAdvisor(tagId, this._loader, (List<FaceletTaglibTagAttribute>)attributes));
        }
        if (elementType instanceof IHandlerTagElement.TagHandlerType) {
            return new HandlerTag(uri, tagName, (IHandlerTagElement.TagHandlerType)elementType, null, this._factory, (IAttributeAdvisor)new MetadataAttributeAdvisor(tagId, this._loader, (List<FaceletTaglibTagAttribute>)attributes));
        }
        if (DefaultTagTypeInfo.isDefaultLib((String)tagId.getUri())) {
            return new NoArchetypeFaceletTag(uri, tagName, this._factory, new MetadataAttributeAdvisor(tagId, this._loader, (List<FaceletTaglibTagAttribute>)attributes));
        }
        return null;
    }

    private TypeInfo findTypeInfo(TagMapping mapping, String jsfVersion, String libVersion) {
        EList list = mapping.getVersionedTagToViewMappings();
        for (Object obj : list) {
            if (!(obj instanceof TagToViewObjectMapping)) continue;
            TagToViewObjectMapping viewMapping = (TagToViewObjectMapping)obj;
            String minJsfVersionString = viewMapping.getMinJSFVersion();
            if (minJsfVersionString != null) {
                try {
                    Version version = new Version(jsfVersion);
                    Version minVersion = Version.parseVersion((String)minJsfVersionString);
                    if (version.compareTo(minVersion) < 0) {
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            String minLibVersionString = viewMapping.getMinLibraryVersion();
            if (libVersion != null && minLibVersionString != null) {
                try {
                    Version version = new Version(libVersion);
                    Version minLibVersion = Version.parseVersion((String)minLibVersionString);
                    if (version.compareTo(minLibVersion) < 0) {
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                continue;
            }
            return this._mapper.mapToFrameworkData(viewMapping.getTypeInfo());
        }
        return null;
    }

    public String getId() {
        return ID;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }
}

