/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.dialog;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.internal.common.AnyFilter;
import org.eclipse.jst.ws.internal.common.Filter;
import org.eclipse.jst.ws.internal.common.ResourceUtils;
import org.eclipse.jst.ws.internal.ui.WSUIPluginMessages;
import org.eclipse.jst.ws.internal.ui.plugin.WebServiceUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ResourceSelectionDialog
extends Dialog
implements Listener {
    private Label filterLabel_;
    private Combo filterCombo_;
    private static final String INFOPOP_DRES_COMBO_RESOURCE_TYPE = "org.eclipse.jst.ws.ui.DRES0001";
    private Tree resourceTree_;
    private TreeViewer fileViewer_;
    private static final String INFOPOP_DRES_TREE_RESOURCE = "org.eclipse.jst.ws.ui.DRES0002";
    private IResource root_;
    private IResource initialSelection_;
    private Filter[] filters_;
    private Filter currentFilter_;
    private IResource[] selection_;
    private boolean multipleSelectionEnabled_;

    public ResourceSelectionDialog(Shell parent, IResource root, IResource initialSelection) {
        this(parent, root, initialSelection, new Filter[]{new AnyFilter()});
    }

    public ResourceSelectionDialog(Shell parent, IResource root, IResource initialSelection, Filter filter) {
        this(parent, root, initialSelection, new Filter[]{filter});
    }

    public ResourceSelectionDialog(Shell parent, IResource root, IResource initialSelection, Filter[] filters) {
        super(parent);
        Filter[] filterArray;
        this.root_ = root == null ? ResourceUtils.getWorkspaceRoot() : root;
        this.initialSelection_ = initialSelection;
        if (filters == null || filters.length == 0) {
            Filter[] filterArray2 = new Filter[1];
            filterArray = filterArray2;
            filterArray2[0] = new AnyFilter();
        } else {
            filterArray = filters;
        }
        this.filters_ = filterArray;
        this.currentFilter_ = this.filters_[0];
        this.multipleSelectionEnabled_ = false;
        this.setShellStyle(67696);
    }

    public void setMultipleSelectionEnabled(boolean multipleSelectionEnabled) {
        this.multipleSelectionEnabled_ = multipleSelectionEnabled;
    }

    public IResource[] getResult() {
        return this.selection_;
    }

    protected void cancelPressed() {
        this.selection_ = null;
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        ISelection selection = this.fileViewer_.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.selection_ = new IResource[structuredSelection.size()];
            int i = 0;
            Iterator iter = structuredSelection.iterator();
            while (iter.hasNext()) {
                Object object = iter.next();
                if (!(object instanceof IResource)) continue;
                this.selection_[i++] = (IResource)object;
            }
        }
        this.setReturnCode(0);
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WSUIPluginMessages.DIALOG_TITLE_RESOURCE_BROWSE);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        if (this.filters_.length > 1) {
            Composite f = new Composite(composite, 0);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            f.setLayout((Layout)gl);
            gd = new GridData(768);
            f.setLayoutData((Object)gd);
            this.filterLabel_ = new Label(f, 64);
            this.filterLabel_.setText(WSUIPluginMessages.LABEL_RESOURCE_FILTER);
            this.filterLabel_.setToolTipText(WSUIPluginMessages.TOOLTIP_DRES_COMBO_RESOURCE_TYPE);
            this.filterCombo_ = new Combo(f, 12);
            gd = new GridData(768);
            this.filterCombo_.setLayoutData((Object)gd);
            this.filterCombo_.addListener(13, (Listener)this);
            this.filterCombo_.setToolTipText(WSUIPluginMessages.TOOLTIP_DRES_COMBO_RESOURCE_TYPE);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.filterCombo_, INFOPOP_DRES_COMBO_RESOURCE_TYPE);
        }
        this.resourceTree_ = this.multipleSelectionEnabled_ ? new Tree(composite, 2818) : new Tree(composite, 2820);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        this.resourceTree_.setLayoutData((Object)gd);
        this.resourceTree_.setToolTipText(WSUIPluginMessages.TOOLTIP_DRES_TREE_RESOURCE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.resourceTree_, INFOPOP_DRES_TREE_RESOURCE);
        this.fileViewer_ = new TreeViewer(this.resourceTree_);
        this.fileViewer_.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fileViewer_.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), WebServiceUIPlugin.getInstance().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fileViewer_.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentObject, Object object) {
                return object instanceof IResource && ((IResource)object).getType() != 1 || ResourceSelectionDialog.this.currentFilter_.accepts(object);
            }
        });
        this.fileViewer_.setInput((Object)this.root_);
        this.fileViewer_.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        if (this.initialSelection_ != null) {
            this.fileViewer_.setSelection((ISelection)new StructuredSelection((Object)this.initialSelection_), true);
        }
        return composite;
    }

    public void handleEvent(Event event) {
    }
}

