/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.autagent.commands;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jubula.autagent.AutStarter;
import org.eclipse.jubula.autagent.commands.AbstractStartPseudoJavaAUT;
import org.eclipse.jubula.autagent.commands.AbstractStartToolkitAut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartHtmlAutServerCommand
extends AbstractStartPseudoJavaAUT {
    private static final String DEFAULT_AUT_ID_ATTRIBUTE_NAME = "id";
    private static Logger log = LoggerFactory.getLogger(StartHtmlAutServerCommand.class);
    private static final Map<String, String> BROWSER_TO_CMD_MAP = new HashMap<String, String>();

    static {
        BROWSER_TO_CMD_MAP.put("Firefox", "*firefox");
        BROWSER_TO_CMD_MAP.put("FirefoxOver47", "*firefox");
        BROWSER_TO_CMD_MAP.put("InternetExplorer", "*iexplore");
        BROWSER_TO_CMD_MAP.put("Safari", "*safari");
        BROWSER_TO_CMD_MAP.put("Chrome", "*googlechrome");
    }

    @Override
    protected String[] createCmdArray(String baseCmd, Map<String, String> parameters) {
        String[] bundlesToAddToClasspath;
        Vector<String> commands = new Vector<String>();
        commands.add(baseCmd);
        this.addDebugParams(commands, false);
        String webdriverMode = parameters.get("WEBDRIVER_MODE");
        Boolean useWebdriver = String.valueOf(webdriverMode).equals(Boolean.TRUE.toString());
        StringBuilder serverClasspath = new StringBuilder();
        String[] stringArray = bundlesToAddToClasspath = this.getBundlesForClasspath(useWebdriver);
        int n = bundlesToAddToClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            String bundleId = stringArray[n2];
            String classpathForBundleId = AbstractStartToolkitAut.getClasspathForBundleId(bundleId);
            if (!StringUtils.isEmpty((String)classpathForBundleId)) {
                serverClasspath.append(classpathForBundleId);
                serverClasspath.append(PATH_SEPARATOR);
            } else {
                log.warn("Bundle not found: " + bundleId);
            }
            ++n2;
        }
        commands.add("-classpath");
        commands.add(serverClasspath.toString());
        commands.add("com.bredexsw.jubula.rc.html.WebAUTServer");
        commands.add(String.valueOf(AutStarter.getInstance().getAutCommunicator().getLocalPort()));
        commands.add(String.valueOf(parameters.get("AUT_ARGUMENTS")));
        if (useWebdriver.booleanValue()) {
            commands.add(String.valueOf(parameters.get("BROWSER")));
        } else {
            commands.add(this.getBrowserString(parameters.get("BROWSER_PATH"), parameters.get("BROWSER"), useWebdriver));
        }
        if (useWebdriver.booleanValue()) {
            commands.add(String.valueOf(parameters.get("BROWSER_SIZE")));
        } else {
            commands.add("AUT");
        }
        this.fillRegistrationParameters(parameters, commands);
        String idAttribute = parameters.get("WEB_ID_TAG");
        if (idAttribute != null) {
            commands.add(String.valueOf(idAttribute));
        } else {
            commands.add(DEFAULT_AUT_ID_ATTRIBUTE_NAME);
        }
        if (useWebdriver.booleanValue()) {
            commands.add(String.valueOf(parameters.get("BROWSER_PATH")));
            commands.add(String.valueOf(parameters.get("DRIVER_PATH")));
        } else {
            String singleWindowMode = parameters.get("SINGLE_WINDOW_MODE");
            if (singleWindowMode != null) {
                commands.add(String.valueOf(singleWindowMode));
            } else {
                commands.add(String.valueOf(true));
            }
        }
        return commands.toArray(new String[commands.size()]);
    }

    private void fillRegistrationParameters(Map parameters, AbstractList<String> commands) {
        commands.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentHost")));
        commands.add(String.valueOf(parameters.get("com.bredexsw.guidancer.aut.register.autAgentPort")));
        commands.add(String.valueOf(parameters.get("AUT_ID")));
    }

    protected String[] getBundlesForClasspath(boolean useWebdriver) {
        String rcHtmlDriverBundleId = useWebdriver ? "com.bredexsw.jubula.rc.html.webdriver" : "com.bredexsw.jubula.rc.html.selenium2";
        return new String[]{"com.bredexsw.jubula.rc.html", rcHtmlDriverBundleId, "org.eclipse.jubula.toolkit.html", "org.eclipse.jubula.tools", "org.eclipse.jubula.tools.exec", "org.eclipse.jubula.communication", "org.eclipse.jubula.rc.common", "org.eclipse.jubula.toolkit.api", "com.bredexsw.jubula.rc.common", "org.slf4j.jcl", "org.slf4j.jul", "org.slf4j.api", "ch.qos.logback.classic", "ch.qos.logback.core", "ch.qos.logback.slf4j", "org.apache.commons.lang", "org.apache.commons.io", "org.apache.commons.exec", "org.apache.oro", "org.apache.commons.collections"};
    }

    private String getBrowserString(Object browserPath, Object browserType, boolean useWebdriver) {
        String browserString;
        if (useWebdriver) {
            if (browserType == null) {
                throw new IllegalArgumentException("Unsupported browser type: " + browserType);
            }
            browserString = String.valueOf(browserType);
        } else {
            String browser = BROWSER_TO_CMD_MAP.get(browserType);
            if (browser == null) {
                throw new IllegalArgumentException("Unsupported browser type: " + browserType);
            }
            browserString = String.valueOf(browser);
        }
        if (browserPath != null) {
            browserString = String.valueOf(browserString) + " " + String.valueOf(browserPath);
        }
        return "\"" + browserString + "\"";
    }

    @Override
    public String getRcBundleId() {
        return "com.bredexsw.jubula.rc.html";
    }
}

