/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.archive;

import com.thoughtworks.xstream.converters.ConversionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.locale.converters.DateLocaleConverter;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jubula.client.archive.ImportExportUtil;
import org.eclipse.jubula.client.archive.converter.AbstractXmlConverter;
import org.eclipse.jubula.client.archive.converter.AutIdGenerationConverter;
import org.eclipse.jubula.client.archive.converter.HTMLTechnicalComponentIndexConverter;
import org.eclipse.jubula.client.archive.converter.IXmlConverter;
import org.eclipse.jubula.client.archive.converter.ObjectMappingAssoziationConverter;
import org.eclipse.jubula.client.archive.converter.RefTSNameConverter;
import org.eclipse.jubula.client.archive.converter.TreeDirectionConverter;
import org.eclipse.jubula.client.archive.converter.V4C001;
import org.eclipse.jubula.client.archive.i18n.Messages;
import org.eclipse.jubula.client.archive.schema.Aut;
import org.eclipse.jubula.client.archive.schema.AutConfig;
import org.eclipse.jubula.client.archive.schema.Cap;
import org.eclipse.jubula.client.archive.schema.Category;
import org.eclipse.jubula.client.archive.schema.CheckActivatedContext;
import org.eclipse.jubula.client.archive.schema.CheckAttribute;
import org.eclipse.jubula.client.archive.schema.CheckConfiguration;
import org.eclipse.jubula.client.archive.schema.Comment;
import org.eclipse.jubula.client.archive.schema.CompNames;
import org.eclipse.jubula.client.archive.schema.ComponentName;
import org.eclipse.jubula.client.archive.schema.EventHandler;
import org.eclipse.jubula.client.archive.schema.EventTestCase;
import org.eclipse.jubula.client.archive.schema.ExecCategory;
import org.eclipse.jubula.client.archive.schema.I18NString;
import org.eclipse.jubula.client.archive.schema.MapEntry;
import org.eclipse.jubula.client.archive.schema.MonitoringValues;
import org.eclipse.jubula.client.archive.schema.NamedTestData;
import org.eclipse.jubula.client.archive.schema.Node;
import org.eclipse.jubula.client.archive.schema.ObjectMapping;
import org.eclipse.jubula.client.archive.schema.ObjectMappingProfile;
import org.eclipse.jubula.client.archive.schema.OmCategory;
import org.eclipse.jubula.client.archive.schema.OmEntry;
import org.eclipse.jubula.client.archive.schema.ParamDescription;
import org.eclipse.jubula.client.archive.schema.Project;
import org.eclipse.jubula.client.archive.schema.RefTestCase;
import org.eclipse.jubula.client.archive.schema.RefTestSuite;
import org.eclipse.jubula.client.archive.schema.ReportingRule;
import org.eclipse.jubula.client.archive.schema.ReusedProject;
import org.eclipse.jubula.client.archive.schema.SummaryAttribute;
import org.eclipse.jubula.client.archive.schema.TechnicalName;
import org.eclipse.jubula.client.archive.schema.TestCase;
import org.eclipse.jubula.client.archive.schema.TestData;
import org.eclipse.jubula.client.archive.schema.TestDataCategory;
import org.eclipse.jubula.client.archive.schema.TestDataCell;
import org.eclipse.jubula.client.archive.schema.TestDataRow;
import org.eclipse.jubula.client.archive.schema.TestJobs;
import org.eclipse.jubula.client.archive.schema.TestSuite;
import org.eclipse.jubula.client.archive.schema.TestresultSummaries;
import org.eclipse.jubula.client.archive.schema.TestresultSummary;
import org.eclipse.jubula.client.archive.schema.UsedToolkit;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.businessprocess.ProjectNameBP;
import org.eclipse.jubula.client.core.businessprocess.TestDataCubeBP;
import org.eclipse.jubula.client.core.businessprocess.UsedToolkitBP;
import org.eclipse.jubula.client.core.model.IALMReportingRulePO;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.model.IArchivableTestResultSummary;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.ICheckConfContPO;
import org.eclipse.jubula.client.core.model.ICheckConfPO;
import org.eclipse.jubula.client.core.model.ICommentPO;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IObjectMappingAssoziationPO;
import org.eclipse.jubula.client.core.model.IObjectMappingCategoryPO;
import org.eclipse.jubula.client.core.model.IObjectMappingPO;
import org.eclipse.jubula.client.core.model.IObjectMappingProfilePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNodePO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IProjectPropertiesPO;
import org.eclipse.jubula.client.core.model.IRefTestSuitePO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITDManager;
import org.eclipse.jubula.client.core.model.ITestDataCategoryPO;
import org.eclipse.jubula.client.core.model.ITestDataCubePO;
import org.eclipse.jubula.client.core.model.ITestJobPO;
import org.eclipse.jubula.client.core.model.ITestResultSummaryPO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.model.IUsedToolkitPO;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.core.model.PoMaker;
import org.eclipse.jubula.client.core.model.ProjectVersion;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;
import org.eclipse.jubula.client.core.persistence.PersistenceUtil;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.TestResultSummaryPM;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.utils.LocaleUtil;
import org.eclipse.jubula.client.core.utils.ModelParamValueConverter;
import org.eclipse.jubula.client.core.utils.ReportRuleType;
import org.eclipse.jubula.client.core.utils.TrackingUnit;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.toolkit.common.xml.businessprocess.ComponentBuilder;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.jubula.tools.internal.exception.JBVersionException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.objects.ComponentIdentifier;
import org.eclipse.jubula.tools.internal.objects.MonitoringValue;
import org.eclipse.jubula.tools.internal.version.IVersion;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Component;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ConcreteComponent;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Profile;
import org.eclipse.jubula.tools.internal.xml.businessmodell.ToolkitDescriptor;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XmlImporter {
    public static final String DATE_PATTERN = "yyyy-MM-dd hh:mm:ss.S";
    public static final BeanUtilsBean BEAN_UTILS = new BeanUtilsBean();
    private static Logger log;
    private Map<String, IAUTConfigPO> m_autConfRef = new HashMap<String, IAUTConfigPO>();
    private Map<String, IAUTMainPO> m_autRef = new HashMap<String, IAUTMainPO>();
    private Map<String, ISpecTestCasePO> m_tcRef = new HashMap<String, ISpecTestCasePO>();
    private Map<String, ICategoryPO> m_execCategoryCache = new HashMap<String, ICategoryPO>();
    private Map<String, String> m_oldToNewGuids = new HashMap<String, String>();
    private IProgressMonitor m_monitor;
    private IProgressConsole m_io;
    private List<String> m_unparseableParameters = new ArrayList<String>();
    private boolean m_skipTrackingInformation = false;
    private Locale m_oldDefaultLanguage = null;

    static {
        DateLocaleConverter converter = new DateLocaleConverter(Locale.getDefault(), DATE_PATTERN);
        converter.setLenient(true);
        final SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_PATTERN);
        Converter stringConverter = new Converter(){

            protected Class getDefaultType() {
                return String.class;
            }

            protected Object convertToType(Class type, Object value) throws Throwable {
                return value.toString();
            }

            protected String convertToString(Object value) throws Throwable {
                if (value instanceof Date) {
                    return dateFormatter.format((Date)value);
                }
                return value.toString();
            }

            public Object convert(Class arg0, Object arg1) {
                if (arg0.isAssignableFrom(String.class)) {
                    try {
                        return this.convertToString(arg1);
                    }
                    catch (Throwable e) {
                        throw new ConversionException(e);
                    }
                }
                if (arg0.isAssignableFrom(ITestResultSummaryPO.AlmReportStatus.class)) {
                    try {
                        return ITestResultSummaryPO.AlmReportStatus.valueOf((String)String.valueOf(arg1));
                    }
                    catch (Throwable e) {
                        throw new ConversionException(e);
                    }
                }
                throw new ConversionException("Type " + arg0.getCanonicalName() + " not supported for conversion.");
            }
        };
        ConvertUtilsBean convertUtils = BEAN_UTILS.getConvertUtils();
        convertUtils.register(stringConverter, String.class);
        convertUtils.register((Converter)converter, Date.class);
        log = LoggerFactory.getLogger(XmlImporter.class);
    }

    public XmlImporter(IProgressMonitor monitor, IProgressConsole io, boolean skipTrackingInformation) {
        this.m_monitor = monitor;
        this.m_io = io;
        this.m_skipTrackingInformation = skipTrackingInformation;
    }

    public IProjectPO createProject(Project xml, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache) throws InvalidDataException, JBVersionException, InterruptedException, ToolkitPluginException {
        return this.createProject(xml, false, paramNameMapper, compNameCache);
    }

    public IProjectPO createProject(Project xml, Integer majorVersion, Integer minorVersion, Integer microVersion, String versionQualifier, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache) throws InvalidDataException, JBVersionException, InterruptedException, ToolkitPluginException {
        if (majorVersion != null) {
            xml.setMajorProjectVersion(majorVersion);
        } else {
            xml.setNilMajorProjectVersion();
        }
        if (minorVersion != null) {
            xml.setMinorProjectVersion(minorVersion);
        } else {
            xml.setNilMinorProjectVersion();
        }
        if (microVersion != null) {
            xml.setMicroProjectVersion(microVersion);
        } else {
            xml.setNilMicroProjectVersion();
        }
        xml.setProjectVersionQualifier(versionQualifier);
        return this.createProject(xml, paramNameMapper, compNameCache);
    }

    public IProjectPO createProject(Project xml, boolean assignNewGuid, IParamNameMapper paramNameMapper, IWritableComponentNameCache compNameCache) throws InvalidDataException, InterruptedException, JBVersionException, ToolkitPluginException {
        this.checkMinimumRequiredXMLVersion(xml);
        this.documentRequiredProjects(xml);
        this.checkUsedToolkits(xml);
        this.checkSupportedToolkits(xml.getUsedToolkitList());
        LinkedList<AbstractXmlConverter> listOfConverter = new LinkedList<AbstractXmlConverter>();
        listOfConverter.add(new AutIdGenerationConverter());
        listOfConverter.add(new V4C001());
        listOfConverter.add(new HTMLTechnicalComponentIndexConverter());
        listOfConverter.add(new TreeDirectionConverter());
        listOfConverter.add(new RefTSNameConverter());
        listOfConverter.add(new ObjectMappingAssoziationConverter());
        for (IXmlConverter iXmlConverter : listOfConverter) {
            iXmlConverter.convert(xml);
        }
        IProjectPO iProjectPO = this.create(xml, assignNewGuid, paramNameMapper, compNameCache);
        if (!this.m_unparseableParameters.isEmpty()) {
            this.m_io.writeErrorLine(Messages.UnparseableParameters);
            for (String param : this.m_unparseableParameters) {
                this.m_io.writeErrorLine(param);
            }
            this.m_io.writeLine("");
        }
        return iProjectPO;
    }

    private void checkSupportedToolkits(List<UsedToolkit> usedToolkits) throws ToolkitPluginException {
        List toolkitIds = ComponentBuilder.getInstance().getLevelToolkitIds();
        StringBuilder errorMsg = new StringBuilder();
        for (UsedToolkit usedToolkit : usedToolkits) {
            if (ComponentBuilder.getInstance().getLevelToolkitIds().contains(usedToolkit.getName())) continue;
            try {
                "toolkit".equals(ToolkitSupportBP.getToolkitLevel((String)usedToolkit.getName()));
            }
            catch (ToolkitPluginException e) {
                errorMsg.append("\n");
                errorMsg.append("\t");
                errorMsg.append(usedToolkit.getName());
            }
        }
        if (StringUtils.isNotBlank((String)errorMsg.toString())) {
            throw new ToolkitPluginException(NLS.bind((String)Messages.UnsupportedToolkits, (Object)errorMsg.toString()));
        }
    }

    private void checkMinimumRequiredXMLVersion(Project xml) throws JBVersionException {
        if (!xml.isSetMetaDataVersion() || xml.getMetaDataVersion() < IVersion.JB_CLIENT_MIN_XML_METADATA_VERSION) {
            ArrayList<String> errorMsgs = new ArrayList<String>();
            errorMsgs.add(Messages.XmlImporterProjectXMLTooOld);
            throw new JBVersionException(Messages.XmlImporterProjectXMLTooOld, MessageIDs.E_LOAD_PROJECT_XML_VERSION_ERROR, errorMsgs);
        }
    }

    private void checkUsedToolkits(Project xml) throws JBVersionException {
        HashSet<IUsedToolkitPO> usedTK = new HashSet<IUsedToolkitPO>();
        for (UsedToolkit usedToolkit : xml.getUsedToolkitList()) {
            usedTK.add(PoMaker.createUsedToolkitsPO((String)usedToolkit.getName(), (int)usedToolkit.getMajorVersion(), (int)usedToolkit.getMinorVersion(), null));
        }
        ArrayList<String> errorMsgs = new ArrayList<String>();
        if (!this.validateToolkitVersion(usedTK, xml.getName(), errorMsgs)) {
            throw new JBVersionException(Messages.IncompatibleToolkitVersion, MessageIDs.E_LOAD_PROJECT_TOOLKIT_MAJOR_VERSION_ERROR, errorMsgs);
        }
    }

    private void documentRequiredProjects(Project xml) {
        if (xml.getReusedProjectsList().size() > 0) {
            this.m_io.writeLine(NLS.bind((String)Messages.XmlImporterProjectDependency, (Object[])new Object[]{xml.getName(), this.getProjectVersion(xml.isNilMajorProjectVersion() || !xml.isSetMajorProjectVersion() ? null : Integer.valueOf(xml.getMajorProjectVersion()), xml.isNilMinorProjectVersion() || !xml.isSetMinorProjectVersion() ? null : Integer.valueOf(xml.getMinorProjectVersion()), xml.isNilMicroProjectVersion() || !xml.isSetMicroProjectVersion() ? null : Integer.valueOf(xml.getMicroProjectVersion()), xml.getProjectVersionQualifier())}));
            for (ReusedProject rp : xml.getReusedProjectsList()) {
                ProjectVersion version = this.getProjectVersion(rp.isNilMajorProjectVersion() || !rp.isSetMajorProjectVersion() ? null : Integer.valueOf(rp.getMajorProjectVersion()), rp.isNilMinorProjectVersion() || !rp.isSetMinorProjectVersion() ? null : Integer.valueOf(rp.getMinorProjectVersion()), rp.isNilMicroProjectVersion() || !rp.isSetMicroProjectVersion() ? null : Integer.valueOf(rp.getMicroProjectVersion()), rp.getProjectVersionQualifier());
                String requiredProjectString = rp.getProjectName() != null ? NLS.bind((String)Messages.XmlImporterRequiredProject, (Object[])new Object[]{rp.getProjectName(), version}) : NLS.bind((String)Messages.XmlImporterRequiredProjectWithoutName, (Object[])new Object[]{rp.getProjectGUID(), version});
                this.m_io.writeLine(requiredProjectString);
            }
        }
    }

    private ProjectVersion getProjectVersion(Integer major, Integer minor, Integer micro, String versionQualifier) {
        return new ProjectVersion(major, minor, micro, versionQualifier);
    }

    private void createComponentNames(Project xmlProj, IProjectPO proj, IWritableComponentNameCache compNameCache, boolean assignNewGuid) {
        List<ComponentName> componentNamesList = xmlProj.getComponentNamesList();
        HashMap<String, String> oldToNewGUID = new HashMap<String, String>(componentNamesList.size());
        HashSet<IComponentNamePO> createdCompNames = new HashSet<IComponentNamePO>();
        for (ComponentName compName : componentNamesList) {
            String guid = compName.getGUID();
            if (assignNewGuid) {
                String newGuid = PersistenceUtil.generateUUID();
                oldToNewGUID.put(guid, newGuid);
                guid = newGuid;
            }
            String name = compName.getCompName();
            String type = compName.getCompType();
            if (this.componentHasDefaultMapping(type)) continue;
            String creationContext = compName.getCreationContext();
            ComponentNamesBP.CompNameCreationContext ctx = ComponentNamesBP.CompNameCreationContext.forName((String)creationContext);
            IComponentNamePO componentNamePO = PoMaker.createComponentNamePO((String)guid, (String)name, (String)type, (ComponentNamesBP.CompNameCreationContext)ctx, (Long)proj.getId());
            componentNamePO.setReferencedGuid(compName.getRefGuid());
            createdCompNames.add(componentNamePO);
            compNameCache.addCompNamePO(componentNamePO);
        }
        if (assignNewGuid) {
            for (IComponentNamePO createdName : createdCompNames) {
                String newGuid = (String)oldToNewGUID.get(createdName.getReferencedGuid());
                if (newGuid == null) continue;
                createdName.setReferencedGuid(newGuid);
            }
            ImportExportUtil.switchCompNamesGuids(proj, oldToNewGUID);
        }
    }

    private boolean validateToolkitVersion(Set<IUsedToolkitPO> usedTK, String projName, List<String> errorMsgs) {
        List errors = UsedToolkitBP.getInstance().checkUsedToolkitPluginVersions(usedTK);
        if (errors.isEmpty()) {
            return true;
        }
        boolean loadProject = true;
        for (UsedToolkitBP.ToolkitPluginError error : errors) {
            StringBuilder strBuilder = new StringBuilder();
            String toolkitId = error.getToolkitId();
            ToolkitDescriptor desc = ComponentBuilder.getInstance().getCompSystem().getToolkitDescriptor(toolkitId);
            String toolkitName = desc != null ? desc.getName() : toolkitId;
            strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict2).append(toolkitName).append(Messages.XmlImporterToolkitVersionConflict3a).append(projName).append(Messages.XmlImporterToolkitVersionConflict3b);
            UsedToolkitBP.ToolkitPluginError.ERROR errorType = error.getError();
            String descr = Messages.OpenProjectActionToolkitVersionConflict5;
            switch (errorType) {
                case MAJOR_VERSION_ERROR: {
                    strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict4a);
                    strBuilder.append(descr);
                    errorMsgs.add(strBuilder.toString());
                    loadProject = false;
                    break;
                }
                case MINOR_VERSION_HIGHER: {
                    strBuilder.append(Messages.OpenProjectActionToolkitVersionConflict4b);
                    strBuilder.append(descr);
                    errorMsgs.add(strBuilder.toString());
                    loadProject = false;
                    break;
                }
                case MINOR_VERSION_LOWER: {
                    break;
                }
                default: {
                    Assert.notReached((String)(String.valueOf(Messages.UnknownErrorType) + String.valueOf(errorType)));
                }
            }
        }
        return loadProject;
    }

    private IProjectPO create(Project xml, boolean assignNewGuid, IParamNameMapper mapper, IWritableComponentNameCache cNC) throws InvalidDataException, InterruptedException {
        IProjectPO proj = this.initProject(xml, assignNewGuid);
        EntityManager attrDescSession = Persistor.instance().openSession();
        try {
            this.fillProject(proj, xml, attrDescSession, assignNewGuid, mapper, cNC);
        }
        finally {
            Persistor.instance().dropSession(attrDescSession);
        }
        return proj;
    }

    private void fillProject(IProjectPO proj, Project xml, EntityManager attrDescSession, boolean assignNewGuid, IParamNameMapper mapper, IWritableComponentNameCache cNC) throws InvalidDataException, InterruptedException {
        IProjectPropertiesPO projectProperties = this.fillProjectProperties(proj, xml);
        if (xml.isSetTestResultDetailsCleanupInterval()) {
            proj.setTestResultCleanupInterval(xml.getTestResultDetailsCleanupInterval());
        } else {
            proj.setTestResultCleanupInterval(5);
        }
        for (ReusedProject reusedProj : xml.getReusedProjectsList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            proj.addUsedProject(this.createReusedProject(reusedProj));
        }
        if (xml.isSetDefaultLanguage()) {
            this.m_oldDefaultLanguage = LocaleUtil.convertStrToLocale((String)xml.getDefaultLanguage());
            this.m_io.writeStatus((IStatus)new Status(2, "org.eclipse.jubula.client.core", NLS.bind((String)Messages.ImportOfDefaultLanguage, (Object)this.m_oldDefaultLanguage)));
        }
        for (Aut autXml : xml.getAutList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            proj.addAUTMain(this.createAUTMain(autXml, assignNewGuid));
        }
        for (TestDataCategory testDataCategory : xml.getTestDataCategoryList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            proj.getTestDataCubeCont().addCategory(this.createTestDataCategory(testDataCategory, assignNewGuid, mapper));
        }
        for (NamedTestData testDataCube : xml.getNamedTestDataList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            proj.getTestDataCubeCont().addTestData(this.createTestDataCube(testDataCube, assignNewGuid, mapper));
        }
        for (Category catXml : xml.getCategoryList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            proj.getSpecObjCont().addSpecObject(this.createCategory(proj, catXml, assignNewGuid, mapper));
        }
        for (TestCase tcXml : xml.getTestcaseList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            this.initTestCase(assignNewGuid, mapper, proj, tcXml);
        }
        for (Category catXml : xml.getCategoryList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            this.rerunCategories(proj, catXml, assignNewGuid, attrDescSession);
        }
        for (TestCase tcXml : xml.getTestcaseList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            this.completeTestCase(proj, tcXml, assignNewGuid, attrDescSession);
        }
        this.handleOldTestSuitesAndTestJobs(proj, xml, attrDescSession, assignNewGuid);
        this.handleTestSuitesAndTestJobsAndCategories(proj, xml, assignNewGuid);
        for (CheckConfiguration xmlConf : xml.getCheckConfigurationList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            this.initCheckConf(xmlConf, projectProperties.getCheckConfCont());
        }
        if (xml.getTestresultSummaries() != null) {
            this.initTestResultSummaries(xml.getTestresultSummaries(), proj);
        }
        this.createComponentNames(xml, proj, cNC, assignNewGuid);
    }

    public IProjectPropertiesPO fillProjectProperties(IProjectPO proj, Project xml) {
        proj.setComment(xml.getComment());
        proj.setMarkupLanguage(xml.getMarkupLanguage());
        proj.setToolkit(xml.getAutToolKit());
        proj.setIsReusable(xml.getIsReusable());
        proj.setIsProtected(xml.getIsProtected());
        IProjectPropertiesPO projProperties = proj.getProjectProperties();
        projProperties.setALMRepositoryName(xml.getAlmRepositoryName());
        projProperties.setIsReportOnSuccess(xml.getIsReportOnSuccess());
        projProperties.setIsReportOnFailure(xml.getIsReportOnFailure());
        projProperties.setDashboardURL(xml.getDashboardURL());
        projProperties.getCheckConfCont().setEnabled(xml.getTeststyleEnabled());
        projProperties.setIsTrackingActivated(xml.getTrackingEnabled());
        projProperties.setTrackChangesSignature(xml.getTrackingAttribute());
        if (xml.isSetTrackingUnit()) {
            projProperties.setTrackChangesUnit(TrackingUnit.valueOf((String)xml.getTrackingUnit()));
        }
        projProperties.setTrackChangesSpan(Integer.valueOf(xml.getTrackingSpan()));
        ArrayList<IALMReportingRulePO> reportingRules = new ArrayList<IALMReportingRulePO>();
        for (ReportingRule rule : xml.getReportingRulesList()) {
            IALMReportingRulePO newReportingRule = this.createReportingRule(rule);
            reportingRules.add(newReportingRule);
        }
        projProperties.setALMReportingRules(reportingRules);
        return projProperties;
    }

    private IALMReportingRulePO createReportingRule(ReportingRule xml) {
        String name = xml.getName();
        String fieldID = xml.getFieldID();
        String value = xml.getValue();
        String xmlType = xml.getType();
        ReportRuleType type = null;
        if (xmlType.equals(ReportRuleType.ONSUCCESS.toString())) {
            type = ReportRuleType.ONSUCCESS;
        } else if (xmlType.equals(ReportRuleType.ONFAILURE.toString())) {
            type = ReportRuleType.ONFAILURE;
        }
        IALMReportingRulePO rule = PoMaker.createALMReportingRulePO((String)name, (String)fieldID, (String)value, (ReportRuleType)type);
        return rule;
    }

    private void handleTestSuitesAndTestJobsAndCategories(IProjectPO proj, Project xml, boolean assignNewGuid) throws InterruptedException, InvalidDataException {
        for (ExecCategory catXml : xml.getExecCategoriesList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            List<IExecPersistable> tsAndCats = this.createListOfCategoriesAndTestsuites(proj, catXml, assignNewGuid);
            for (IExecPersistable exec : tsAndCats) {
                proj.getExecObjCont().addExecObject(exec);
            }
        }
        for (ExecCategory catXml : xml.getExecCategoriesList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            List<IExecPersistable> tjs = this.createListOfTestJobs(catXml, assignNewGuid);
            for (IExecPersistable exec : tjs) {
                proj.getExecObjCont().addExecObject(exec);
            }
        }
    }

    private void handleOldTestSuitesAndTestJobs(IProjectPO proj, Project xml, EntityManager attrDescSession, boolean assignNewGuid) throws InterruptedException, InvalidDataException {
        if (!xml.getTestsuiteList().isEmpty()) {
            ICategoryPO catTS = NodeMaker.createCategoryPO((String)"Test Suites");
            for (TestSuite tsXml : xml.getTestsuiteList()) {
                ImportExportUtil.checkCancel(this.m_monitor);
                ITestSuitePO tsPO = this.createTestSuite(proj, tsXml, assignNewGuid);
                catTS.addNode((INodePO)tsPO);
            }
            proj.getExecObjCont().addExecObject((IExecPersistable)catTS);
        }
        if (!xml.getTestsuiteList().isEmpty()) {
            ICategoryPO catTJ = NodeMaker.createCategoryPO((String)"Test Jobs");
            for (TestJobs tjXml : xml.getTestJobsList()) {
                ImportExportUtil.checkCancel(this.m_monitor);
                catTJ.addNode((INodePO)this.createTestJob(tjXml, assignNewGuid));
            }
            proj.getExecObjCont().addExecObject((IExecPersistable)catTJ);
        }
    }

    private void initCheckConf(CheckConfiguration xmlConf, ICheckConfContPO checkConfCont) {
        if (xmlConf.getSeverity().matches("(0|1|2|3)")) {
            return;
        }
        ICheckConfPO chkConf = checkConfCont.createCheckConf();
        chkConf.setSeverity(xmlConf.getSeverity());
        chkConf.setActive(Boolean.valueOf(xmlConf.getActivated()));
        for (CheckAttribute xmlAttr : xmlConf.getCheckAttributeList()) {
            chkConf.getAttr().put(xmlAttr.getName(), xmlAttr.getValue());
        }
        for (CheckActivatedContext xmlCxt : xmlConf.getActiveContextList()) {
            boolean active = xmlCxt.getActive();
            chkConf.getContexts().put(xmlCxt.getClass1(), active);
        }
        checkConfCont.addCheckConf(xmlConf.getCheckId(), chkConf);
    }

    private IProjectPO initProject(Project xml, boolean assignNewGuid) {
        IProjectPO proj = null;
        if (xml.getGUID() != null) {
            String postFixProjVersion;
            Integer majorProjVersion = null;
            if (!xml.isNilMajorProjectVersion() && xml.isSetMajorProjectVersion() || xml.isSetMajorNumber()) {
                majorProjVersion = xml.isSetMajorNumber() ? xml.getMajorNumber() : xml.getMajorProjectVersion();
            }
            Integer minorProjVersion = null;
            if (!xml.isNilMinorProjectVersion() && xml.isSetMinorProjectVersion() || xml.isSetMinorNumber()) {
                minorProjVersion = xml.isSetMinorNumber() ? xml.getMinorNumber() : xml.getMinorProjectVersion();
            }
            Integer microProjVersion = !xml.isSetMicroProjectVersion() || xml.isNilMicroProjectVersion() ? null : Integer.valueOf(xml.getMicroProjectVersion());
            String string = postFixProjVersion = !xml.isSetProjectVersionQualifier() || xml.isNilProjectVersionQualifier() ? null : xml.getProjectVersionQualifier();
            if (!assignNewGuid) {
                proj = NodeMaker.createProjectPO((Integer)IVersion.JB_CLIENT_METADATA_VERSION, (Integer)majorProjVersion, (Integer)minorProjVersion, (Integer)microProjVersion, (String)postFixProjVersion, (String)xml.getGUID());
            } else {
                proj = NodeMaker.createProjectPO((Integer)IVersion.JB_CLIENT_METADATA_VERSION, (Integer)majorProjVersion, (Integer)minorProjVersion, (Integer)microProjVersion, (String)postFixProjVersion);
                this.m_oldToNewGuids.put(xml.getGUID(), proj.getGuid());
            }
            ProjectNameBP.getInstance().setName(proj.getGuid(), xml.getName(), false);
        } else {
            proj = NodeMaker.createProjectPO((String)xml.getName(), (Integer)IVersion.JB_CLIENT_METADATA_VERSION);
            if (assignNewGuid) {
                this.m_oldToNewGuids.put(xml.getGUID(), proj.getGuid());
            }
        }
        return proj;
    }

    private void initTestResultSummaries(TestresultSummaries trsListXml, IProjectPO proj) {
        PropertyDescriptor[] propertiesToImport = BEAN_UTILS.getPropertyUtils().getPropertyDescriptors(IArchivableTestResultSummary.class);
        for (TestresultSummary trsXml : trsListXml.getTestresultSummaryList()) {
            ITestResultSummaryPO summary = PoMaker.createTestResultSummaryPO();
            summary.setInternalProjectGuid(proj.getGuid());
            PropertyDescriptor[] propertyDescriptorArray = propertiesToImport;
            int n = propertiesToImport.length;
            int n2 = 0;
            while (n2 < n) {
                PropertyDescriptor pd = propertyDescriptorArray[n2];
                List<SummaryAttribute> entries = trsXml.getAttributeList();
                String propertyNameToSet = pd.getName();
                boolean found = false;
                int pos = 0;
                for (SummaryAttribute me : entries) {
                    if (me.getKey().equals(propertyNameToSet)) {
                        found = true;
                        break;
                    }
                    ++pos;
                }
                if (found) {
                    SummaryAttribute sa = entries.get(pos);
                    if (!sa.isNilValue()) {
                        try {
                            BEAN_UTILS.setProperty((Object)summary, propertyNameToSet, (Object)sa.getValue());
                        }
                        catch (IllegalAccessException e) {
                            log.warn(e.getLocalizedMessage(), (Throwable)e);
                        }
                        catch (InvocationTargetException e) {
                            log.warn(e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                } else {
                    log.warn(String.valueOf(Messages.Property) + " " + propertyNameToSet + " " + Messages.NotFound + ".");
                }
                ++n2;
            }
            List<MonitoringValues> tmpList = trsXml.getMonitoringValueList();
            HashMap<String, MonitoringValue> tmpMap = new HashMap<String, MonitoringValue>();
            int i = 0;
            while (i < tmpList.size()) {
                MonitoringValues tmpMon = tmpList.get(i);
                MonitoringValue tmp = new MonitoringValue();
                tmp.setCategory(tmpMon.getCategory());
                tmp.setSignificant(Boolean.valueOf(tmpMon.getIsSignificant()));
                tmp.setType(tmpMon.getType());
                tmp.setValue(tmpMon.getValue());
                tmpMap.put(tmpMon.getKey(), tmp);
                ++i;
            }
            summary.setMonitoringValues(tmpMap);
            if (TestResultSummaryPM.doesTestResultSummaryExist((ITestResultSummaryPO)summary)) continue;
            TestResultSummaryPM.storeTestResultSummaryInDB((ITestResultSummaryPO)summary);
        }
    }

    private void initTestCase(boolean assignNewGuid, IParamNameMapper mapper, IProjectPO proj, TestCase tcXml) {
        ISpecTestCasePO tcPO = this.createTestCaseBase(proj, tcXml, assignNewGuid, mapper);
        proj.getSpecObjCont().addSpecObject((ISpecPersistable)tcPO);
    }

    private ISpecTestCasePO completeTestCase(IProjectPO proj, TestCase xml, boolean assignNewGuid, EntityManager attrDescSession) throws InvalidDataException {
        ISpecTestCasePO tc = xml.getId() != null ? this.m_tcRef.get(xml.getId()) : (assignNewGuid ? this.m_tcRef.get(this.m_oldToNewGuids.get(xml.getGUID())) : this.m_tcRef.get(xml.getGUID()));
        for (TestCase.Teststep stepXml : xml.getTeststepList()) {
            if (stepXml.getCap() != null) {
                tc.addNode((INodePO)this.createCap(proj, stepXml.getCap(), assignNewGuid));
                continue;
            }
            if (stepXml.getUsedTestcase() != null) {
                tc.addNode((INodePO)this.createExecTestCase(proj, stepXml.getUsedTestcase(), assignNewGuid));
                continue;
            }
            if (stepXml.getComment() == null) continue;
            tc.addNode((INodePO)this.createComment(stepXml.getComment(), assignNewGuid));
        }
        for (EventTestCase evTcXml : xml.getEventTestcaseList()) {
            tc.addEventTestCase(this.createEventExecTestCase(proj, tc, evTcXml, assignNewGuid));
        }
        return tc;
    }

    private IAUTConfigPO createAUTConfig(AutConfig xml, boolean assignNewGuid) {
        IAUTConfigPO conf = null;
        conf = xml.getGUID() != null && !assignNewGuid ? PoMaker.createAUTConfigPO((String)xml.getGUID()) : PoMaker.createAUTConfigPO();
        this.m_autConfRef.put(xml.getId(), conf);
        List<MapEntry> confAttrMapList = xml.getConfAttrMapEntryList();
        for (MapEntry entry : confAttrMapList) {
            String key = entry.getKey();
            String value = entry.getValue();
            conf.setValue(key, value);
        }
        return conf;
    }

    private IAUTMainPO createAUTMain(Aut xml, boolean assignNewGuid) {
        IAUTMainPO aut = null;
        aut = xml.getGUID() != null && !assignNewGuid ? PoMaker.createAUTMainPO((String)xml.getName(), (String)xml.getGUID()) : PoMaker.createAUTMainPO((String)xml.getName());
        aut.setToolkit(xml.getAutToolkit());
        aut.setGenerateNames(xml.getGenerateNames());
        this.m_autRef.put(xml.getId(), aut);
        aut.setObjMap(this.createOM(xml));
        for (AutConfig confXml : xml.getConfigList()) {
            aut.addAutConfigToSet(this.createAUTConfig(confXml, assignNewGuid));
        }
        for (String autId : xml.getAutIdList()) {
            aut.getAutIds().add(autId);
        }
        List<MapEntry> props = xml.getPropertiesList();
        for (MapEntry prop : props) {
            aut.getPropertyMap().put(prop.getKey(), prop.getValue());
        }
        return aut;
    }

    private IReusedProjectPO createReusedProject(ReusedProject xml) {
        Integer majorProjVersion = null;
        if (xml.isSetMajorProjectVersion()) {
            majorProjVersion = xml.isNilMajorProjectVersion() ? null : Integer.valueOf(xml.getMajorProjectVersion());
        } else if (xml.isSetMajorNumber()) {
            majorProjVersion = xml.isNilMajorNumber() ? null : Integer.valueOf(xml.getMajorNumber());
        }
        Integer minorProjVersion = null;
        if (xml.isSetMinorProjectVersion()) {
            minorProjVersion = xml.isNilMinorProjectVersion() ? null : Integer.valueOf(xml.getMinorProjectVersion());
        } else if (xml.isSetMinorNumber()) {
            minorProjVersion = xml.isNilMinorNumber() ? null : Integer.valueOf(xml.getMinorNumber());
        }
        Integer microProjVersion = !xml.isSetMicroProjectVersion() || xml.isNilMicroProjectVersion() ? null : Integer.valueOf(xml.getMicroProjectVersion());
        String versionQualifier = !xml.isSetProjectVersionQualifier() || xml.isNilProjectVersionQualifier() ? null : xml.getProjectVersionQualifier();
        IReusedProjectPO reusedProject = PoMaker.createReusedProjectPO((String)xml.getProjectGUID(), (Integer)majorProjVersion, (Integer)minorProjVersion, (Integer)microProjVersion, (String)versionQualifier);
        return reusedProject;
    }

    private ICapPO createCap(IProjectPO proj, Cap xml, boolean assignNewGuid) {
        String componentname = xml.getComponentName();
        if (this.componentHasDefaultMapping(xml.getComponentType())) {
            componentname = null;
        }
        ICapPO cap = xml.getGUID() != null && !assignNewGuid ? NodeMaker.createCapPO((String)xml.getName(), (String)componentname, (String)xml.getComponentType(), (String)xml.getActionName(), (IProjectPO)proj, (String)xml.getGUID()) : NodeMaker.createCapPO((String)xml.getName(), (String)componentname, (String)xml.getComponentType(), (String)xml.getActionName(), (IProjectPO)proj);
        cap.setDataFile(xml.getDatafile());
        if (xml.isSetActive()) {
            cap.setActive(xml.getActive());
        } else {
            cap.setActive(true);
        }
        if (xml.getComment() != null) {
            cap.setComment(xml.getComment());
        }
        if (xml.getTestdata() != null) {
            ITDManager tdman = this.fillTDManager((IParamNodePO)cap, xml);
            cap.setDataManager(tdman);
        }
        return cap;
    }

    private ISpecPersistable createCategory(IProjectPO proj, Category xml, boolean assignNewGuid, IParamNameMapper mapper) throws InvalidDataException {
        ICategoryPO cat = xml.getGUID() != null && !assignNewGuid ? NodeMaker.createCategoryPO((String)xml.getName(), (String)xml.getGUID()) : NodeMaker.createCategoryPO((String)xml.getName());
        cat.setGenerated(xml.getGenerated());
        cat.setComment(xml.getComment());
        cat.setTaskId(xml.getTaskId());
        for (Category catXml : xml.getCategoryList()) {
            cat.addNode((INodePO)this.createCategory(proj, catXml, assignNewGuid, mapper));
        }
        for (TestCase tcXml : xml.getTestcaseList()) {
            cat.addNode((INodePO)this.createTestCaseBase(proj, tcXml, assignNewGuid, mapper));
        }
        return cat;
    }

    private ICommentPO createComment(Comment xml, boolean assignNewGuid) {
        ICommentPO cat = !assignNewGuid && xml.getGUID() != null ? NodeMaker.createCommentPO((String)xml.getName(), (String)xml.getGUID()) : NodeMaker.createCommentPO((String)xml.getName());
        return cat;
    }

    private List<IExecPersistable> createListOfCategoriesAndTestsuites(IProjectPO proj, ExecCategory xml, boolean assignNewGuid) throws InvalidDataException {
        ArrayList<IExecPersistable> execNodes = new ArrayList<IExecPersistable>();
        for (ExecCategory catXml : xml.getCategoryList()) {
            execNodes.add(this.createExecObjects(proj, catXml, assignNewGuid));
        }
        for (TestSuite tsXml : xml.getTestsuiteList()) {
            execNodes.add((IExecPersistable)this.createTestSuite(proj, tsXml, assignNewGuid));
        }
        return execNodes;
    }

    private List<IExecPersistable> createListOfTestJobs(ExecCategory xml, boolean assignNewGuid) throws InvalidDataException {
        ArrayList<IExecPersistable> execNodes = new ArrayList<IExecPersistable>();
        for (ExecCategory catXml : xml.getCategoryList()) {
            this.createTestJobs(catXml, assignNewGuid);
        }
        for (TestJobs tjXml : xml.getTestjobList()) {
            execNodes.add((IExecPersistable)this.createTestJob(tjXml, assignNewGuid));
        }
        return execNodes;
    }

    private void createTestJobs(ExecCategory xml, boolean assignNewGuid) throws InvalidDataException {
        for (ExecCategory catXml : xml.getCategoryList()) {
            this.createTestJobs(catXml, assignNewGuid);
        }
        String guid = xml.getGUID();
        if (assignNewGuid) {
            guid = this.m_oldToNewGuids.get(guid);
        }
        ICategoryPO cat = this.m_execCategoryCache.get(guid);
        for (TestJobs tjXml : xml.getTestjobList()) {
            cat.addNode((INodePO)this.createTestJob(tjXml, assignNewGuid));
        }
    }

    private IExecPersistable createExecObjects(IProjectPO proj, ExecCategory xml, boolean assignNewGuid) throws InvalidDataException {
        ICategoryPO cat;
        if (xml.getGUID() != null && !assignNewGuid) {
            cat = NodeMaker.createCategoryPO((String)xml.getName(), (String)xml.getGUID());
            this.m_execCategoryCache.put(xml.getGUID(), cat);
        } else {
            cat = NodeMaker.createCategoryPO((String)xml.getName());
            this.m_execCategoryCache.put(cat.getGuid(), cat);
            this.m_oldToNewGuids.put(xml.getGUID(), cat.getGuid());
        }
        cat.setGenerated(xml.getGenerated());
        cat.setComment(xml.getComment());
        cat.setDescription(xml.getDescription());
        cat.setTaskId(xml.getTaskId());
        for (ExecCategory catXml : xml.getCategoryList()) {
            cat.addNode((INodePO)this.createExecObjects(proj, catXml, assignNewGuid));
        }
        for (TestSuite tsXml : xml.getTestsuiteList()) {
            cat.addNode((INodePO)this.createTestSuite(proj, tsXml, assignNewGuid));
        }
        return cat;
    }

    private IEventExecTestCasePO createEventExecTestCase(IProjectPO proj, ISpecTestCasePO tc, EventTestCase xml, boolean assignNewGuid) throws InvalidDataException {
        ISpecTestCasePO refTc = xml.getTestcaseRef() != null ? this.findReferencedTC(xml.getTestcaseRef()) : ImportExportUtil.findReferencedTCByGuid(xml.getTestcaseGuid(), xml.getProjectGuid(), proj, assignNewGuid, this.m_oldToNewGuids, this.m_tcRef);
        IEventExecTestCasePO evTc = refTc == null ? (assignNewGuid ? NodeMaker.createEventExecTestCasePO((String)xml.getTestcaseGuid(), (String)xml.getProjectGuid(), (INodePO)tc) : NodeMaker.createEventExecTestCasePO((String)xml.getTestcaseGuid(), (String)xml.getProjectGuid(), (INodePO)tc, (String)xml.getGUID())) : (xml.getGUID() != null && !assignNewGuid ? NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)refTc, (INodePO)tc, (String)xml.getGUID()) : NodeMaker.createEventExecTestCasePO((ISpecTestCasePO)refTc, (INodePO)tc));
        this.fillExecTestCase(proj, xml, (IExecTestCasePO)evTc, assignNewGuid);
        evTc.setEventType(xml.getEventType());
        ReentryProperty reentryProperty = ReentryProperty.getProperty((Integer)xml.getReentryProperty().intValue());
        evTc.setReentryProp(reentryProperty);
        if (reentryProperty == ReentryProperty.RETRY) {
            evTc.setMaxRetries(Integer.valueOf(xml.isSetMaxRetries() ? xml.getMaxRetries() : 1));
        }
        evTc.clearCachedSpecTestCase();
        return evTc;
    }

    private IExecTestCasePO createExecTestCase(IProjectPO proj, RefTestCase xml, boolean assignNewGuid) {
        ISpecTestCasePO refTc = xml.getTestcaseRef() != null ? this.findReferencedTC(xml.getTestcaseRef()) : ImportExportUtil.findReferencedTCByGuid(xml.getTestcaseGuid(), xml.getProjectGuid(), proj, assignNewGuid, this.m_oldToNewGuids, this.m_tcRef);
        IExecTestCasePO exec = refTc == null ? (!assignNewGuid ? NodeMaker.createExecTestCasePO((String)xml.getTestcaseGuid(), (String)xml.getProjectGuid(), (String)xml.getGUID()) : NodeMaker.createExecTestCasePO((String)xml.getTestcaseGuid(), (String)xml.getProjectGuid())) : (xml.getGUID() != null && !assignNewGuid ? NodeMaker.createExecTestCasePO((ISpecTestCasePO)refTc, (String)xml.getGUID()) : NodeMaker.createExecTestCasePO((ISpecTestCasePO)refTc));
        this.fillExecTestCase(proj, xml, exec, assignNewGuid);
        exec.clearCachedSpecTestCase();
        return exec;
    }

    private IObjectMappingPO createOM(Aut xml) {
        OmCategory unmappedTechnicalCategory;
        OmCategory unmappedComponentCategory;
        OmCategory mappedCategoryXml;
        IObjectMappingPO om = PoMaker.createObjectMappingPO();
        ObjectMapping omXml = xml.getObjectMapping();
        ObjectMappingProfile profileXml = omXml.getProfile();
        if (profileXml != null) {
            IObjectMappingProfilePO profilePo = PoMaker.createObjectMappingProfile();
            profilePo.setContextFactor(profileXml.getContextFactor());
            profilePo.setNameFactor(profileXml.getNameFactor());
            profilePo.setPathFactor(profileXml.getPathFactor());
            profilePo.setThreshold(profileXml.getThreshold());
            om.setProfile(profilePo);
        }
        if ((mappedCategoryXml = omXml.getMapped()) != null) {
            this.fillObjectMappingCategory(mappedCategoryXml, om.getMappedCategory());
        }
        if ((unmappedComponentCategory = omXml.getUnmappedComponent()) != null) {
            this.fillObjectMappingCategory(unmappedComponentCategory, om.getUnmappedLogicalCategory());
        }
        if ((unmappedTechnicalCategory = omXml.getUnmappedTechnical()) != null) {
            this.fillObjectMappingCategory(unmappedTechnicalCategory, om.getUnmappedTechnicalCategory());
        }
        return om;
    }

    private void fillObjectMappingCategory(OmCategory categoryXml, IObjectMappingCategoryPO category) {
        category.setName(categoryXml.getName());
        for (OmCategory subcategoryXml : categoryXml.getCategoryList()) {
            IObjectMappingCategoryPO subcategory = PoMaker.createObjectMappingCategoryPO((String)subcategoryXml.getName());
            category.addCategory(subcategory);
            this.fillObjectMappingCategory(subcategoryXml, subcategory);
        }
        for (OmEntry assocXml : categoryXml.getAssociationList()) {
            TechnicalName tecNameXml = assocXml.getTechnicalName();
            List<String> logNames = assocXml.getLogicalNameList();
            ComponentIdentifier tecName = null;
            if (tecNameXml != null && !tecNameXml.isNil()) {
                tecName = new ComponentIdentifier();
                tecName.setComponentClassName(tecNameXml.getComponentClassName());
                tecName.setSupportedClassName(tecNameXml.getSupportedClassName());
                tecName.setAlternativeDisplayName(tecNameXml.getAlternativeDisplayName());
                tecName.setNeighbours(new ArrayList<String>(tecNameXml.getNeighbourList()));
                tecName.setHierarchyNames(new ArrayList<String>(tecNameXml.getHierarchyNameList()));
                ObjectMappingProfile omp = tecNameXml.getProfile();
                if (omp != null) {
                    Profile p = new Profile(omp.getName(), omp.getNameFactor(), omp.getPathFactor(), omp.getContextFactor(), omp.getThreshold());
                    tecName.setProfile((org.eclipse.jubula.tools.Profile)p);
                }
            }
            IObjectMappingAssoziationPO assoc = PoMaker.createObjectMappingAssoziationPO(tecName, new HashSet<String>(logNames));
            assoc.setType(assocXml.getType());
            category.addAssociation(assoc);
        }
    }

    private ITDManager fillTDManager(IParamNodePO owner, Cap xmlCap) {
        ITDManager tdman = owner.getDataManager();
        List<ParamDescription> parDescList = xmlCap.getParameterDescriptionList();
        TestData testData = xmlCap.getTestdata();
        int tdRow = 0;
        for (TestDataRow rowXml : testData.getRowList()) {
            if (rowXml.getDataList().isEmpty()) continue;
            List tdList = null;
            try {
                tdList = tdman.getDataSet(tdRow).getColumnStringValues();
            }
            catch (IndexOutOfBoundsException ioobe) {
                StringBuilder msgSb = new StringBuilder();
                msgSb.append(Messages.Component);
                msgSb.append(": ");
                msgSb.append(xmlCap.getComponentType());
                msgSb.append("\n" + Messages.Action);
                msgSb.append(": ");
                msgSb.append(CompSystemI18n.getString((String)xmlCap.getActionName(), (boolean)true));
                msgSb.append("\n" + Messages.Parameter);
                msgSb.append(": ");
                msgSb.append(CompSystemI18n.getString((String)parDescList.get(tdRow).getName(), (boolean)true));
                String msg = msgSb.toString();
                log.error(msg, (Throwable)ioobe);
                continue;
            }
            int tdCell = 0;
            for (TestDataCell cellXml : rowXml.getDataList()) {
                String uniqueId = parDescList.get(tdCell).getUniqueId();
                int ownerIndex = owner.getDataManager().findColumnForParam(uniqueId);
                if (ownerIndex > -1) {
                    tdList.set(ownerIndex, this.readData(cellXml, (IParameterInterfacePO)owner));
                }
                ++tdCell;
            }
            tdman.clear();
            tdman.insertDataSet(PoMaker.createListWrapperPO((List)tdList), tdRow);
            ++tdRow;
        }
        return tdman;
    }

    private String readData(TestDataCell cellXml, IParameterInterfacePO owner) {
        String valueString;
        if (this.m_oldDefaultLanguage != null) {
            valueString = this.readOldI18nMainData(cellXml, owner);
        } else {
            valueString = cellXml.getValue();
            if (valueString != null) {
                try {
                    ModelParamValueConverter converter = new ModelParamValueConverter(valueString, owner, null);
                    if (!converter.containsErrors()) {
                        converter.replaceUuidsInReferences(this.m_oldToNewGuids);
                    } else {
                        this.m_unparseableParameters.add(valueString);
                    }
                    valueString = converter.getModelString();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return valueString;
    }

    private String readOldI18nMainData(TestDataCell cellXml, IParameterInterfacePO owner) {
        HashMap<Locale, String> localeToValue = new HashMap<Locale, String>();
        for (I18NString i18nVal : cellXml.getDataList()) {
            if (i18nVal == null || i18nVal.isNil() || i18nVal.getValue() == null || i18nVal.getValue().length() == 0) continue;
            String i18nValString = i18nVal.getValue();
            try {
                ModelParamValueConverter converter = new ModelParamValueConverter(i18nValString, owner, null);
                if (!converter.containsErrors()) {
                    converter.replaceUuidsInReferences(this.m_oldToNewGuids);
                } else {
                    this.m_unparseableParameters.add(i18nValString);
                }
                i18nValString = converter.getModelString();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            localeToValue.put(LocaleUtil.convertStrToLocale((String)i18nVal.getLanguage()), i18nValString);
        }
        return (String)localeToValue.get(this.m_oldDefaultLanguage);
    }

    private ITestDataCategoryPO createTestDataCategory(TestDataCategory xml, boolean assignNewGuids, IParamNameMapper mapper) {
        ITestDataCategoryPO testDataCategory = PoMaker.createTestDataCategoryPO((String)xml.getName());
        for (TestDataCategory subCategory : xml.getTestDataCategoryList()) {
            testDataCategory.addCategory(this.createTestDataCategory(subCategory, assignNewGuids, mapper));
        }
        for (NamedTestData testData : xml.getNamedTestDataList()) {
            testDataCategory.addTestData(this.createTestDataCube(testData, assignNewGuids, mapper));
        }
        return testDataCategory;
    }

    private ITestDataCubePO createTestDataCube(NamedTestData xml, boolean assignNewGuids, IParamNameMapper mapper) {
        ITestDataCubePO testDataCube = PoMaker.createTestDataCubePO((String)xml.getName());
        for (ParamDescription xmlParamDesc : xml.getParameterDescriptionList()) {
            if (assignNewGuids) {
                IParamDescriptionPO paramDesc = testDataCube.addParameter(xmlParamDesc.getType(), xmlParamDesc.getName(), mapper);
                this.m_oldToNewGuids.put(xmlParamDesc.getUniqueId(), paramDesc.getUniqueId());
                continue;
            }
            testDataCube.addParameter(xmlParamDesc.getType(), xmlParamDesc.getName(), xmlParamDesc.getUniqueId(), mapper);
        }
        testDataCube.setDataManager(this.createTDManager((IParameterInterfacePO)testDataCube, xml.getTestData(), assignNewGuids));
        return testDataCube;
    }

    private ITDManager createTDManager(IParameterInterfacePO owner, TestData xml, boolean assignNewGuids) {
        ArrayList<String> uniqueIds = new ArrayList<String>(xml.getUniqueIdsList());
        if (assignNewGuids) {
            ArrayList<String> newUniqueIds = new ArrayList<String>();
            for (String id : uniqueIds) {
                if (Pattern.matches("[0-9a-fA-F]{32}", id) && this.m_oldToNewGuids.containsKey(id)) {
                    newUniqueIds.add(this.m_oldToNewGuids.get(id));
                    continue;
                }
                newUniqueIds.add(id);
            }
            uniqueIds = newUniqueIds;
        }
        ITDManager tdman = uniqueIds.isEmpty() ? PoMaker.createTDManagerPO((IParameterInterfacePO)owner) : PoMaker.createTDManagerPO((IParameterInterfacePO)owner, uniqueIds);
        for (TestDataRow rowXml : xml.getRowList()) {
            ArrayList<String> td = new ArrayList<String>(rowXml.sizeOfDataArray());
            for (TestDataCell cellXml : rowXml.getDataList()) {
                td.add(this.readData(cellXml, owner));
            }
            tdman.insertDataSet(PoMaker.createListWrapperPO(td), tdman.getDataSetCount());
        }
        return tdman;
    }

    private ISpecTestCasePO createTestCaseBase(IProjectPO proj, TestCase xml, boolean assignNewGuid, IParamNameMapper mapper) {
        ISpecTestCasePO tc;
        if (xml.getId() != null) {
            tc = NodeMaker.createSpecTestCasePO((String)xml.getName());
            this.m_tcRef.put(xml.getId(), tc);
        } else if (assignNewGuid) {
            tc = NodeMaker.createSpecTestCasePO((String)xml.getName());
            this.m_tcRef.put(tc.getGuid(), tc);
            this.m_oldToNewGuids.put(xml.getGUID(), tc.getGuid());
        } else {
            tc = NodeMaker.createSpecTestCasePO((String)xml.getName(), (String)xml.getGUID());
            this.m_tcRef.put(xml.getGUID(), tc);
        }
        tc.setComment(xml.getComment());
        tc.setDescription(xml.getDescription());
        tc.setGenerated(xml.getGenerated());
        tc.setTaskId(xml.getTaskId());
        tc.setInterfaceLocked(Boolean.valueOf(xml.getInterfaceLocked()));
        tc.setDataFile(xml.getDatafile());
        this.fillTrackedChangesInformation((INodePO)tc, xml);
        if (xml.getReferencedTestData() != null) {
            String referencedDataName = xml.getReferencedTestData();
            ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)proj);
            int n = iTestDataCubePOArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestDataCubePO testDataCube = iTestDataCubePOArray[n2];
                if (referencedDataName.equals(testDataCube.getName())) {
                    tc.setReferencedDataCube((IParameterInterfacePO)testDataCube);
                    break;
                }
                ++n2;
            }
        }
        for (ParamDescription pdXml : xml.getParameterDescriptionList()) {
            String uniqueId = pdXml.getUniqueId();
            if (assignNewGuid) {
                IParamDescriptionPO paramDesc = tc.addParameter(pdXml.getType(), pdXml.getName(), mapper);
                this.m_oldToNewGuids.put(uniqueId, paramDesc.getUniqueId());
                continue;
            }
            if (uniqueId != null && Pattern.matches("[0-9a-fA-F]{32}", uniqueId)) {
                tc.addParameter(pdXml.getType(), pdXml.getName(), uniqueId, mapper);
                continue;
            }
            tc.addParameter(pdXml.getType(), pdXml.getName(), mapper);
        }
        tc.setDataManager(this.createTDManager((IParameterInterfacePO)tc, xml.getTestdata(), assignNewGuid));
        return tc;
    }

    private ITestSuitePO createTestSuite(IProjectPO proj, TestSuite xml, boolean assignNewGuid) {
        List<RefTestCase> usedTestcaseList;
        ITestSuitePO ts = xml.getGUID() != null && !assignNewGuid ? NodeMaker.createTestSuitePO((String)xml.getName(), (String)xml.getGUID()) : NodeMaker.createTestSuitePO((String)xml.getName());
        if (assignNewGuid) {
            this.m_oldToNewGuids.put(xml.getGUID(), ts.getGuid());
        }
        ts.setComment(xml.getComment());
        ts.setDescription(xml.getDescription());
        ts.setTaskId(xml.getTaskId());
        this.fillTrackedChangesInformation((INodePO)ts, xml);
        if (xml.getSelectedAut() != null) {
            ts.setAut(this.findReferencedAut(xml.getSelectedAut()));
        }
        if (!(usedTestcaseList = xml.getUsedTestcaseList()).isEmpty()) {
            for (RefTestCase refXml : usedTestcaseList) {
                ts.addNode((INodePO)this.createExecTestCase(proj, refXml, assignNewGuid));
            }
        } else {
            for (TestSuite.Testsuiteelement element : xml.getTestsuiteelementList()) {
                RefTestCase refXml = element.getUsedTestcase();
                if (refXml != null) {
                    ts.addNode((INodePO)this.createExecTestCase(proj, refXml, assignNewGuid));
                    continue;
                }
                Comment comXml = element.getComment();
                if (comXml == null) continue;
                ts.addNode((INodePO)this.createComment(comXml, assignNewGuid));
            }
        }
        HashMap<String, Integer> defaultEventHandler = new HashMap<String, Integer>();
        for (EventHandler evhXml : xml.getEventHandlerList()) {
            defaultEventHandler.put(evhXml.getEvent(), evhXml.getReentryProperty().intValue());
        }
        ts.setDefaultEventHandler(defaultEventHandler);
        ts.setStepDelay(xml.getStepDelay());
        if (!xml.isSetRelevant()) {
            ts.setRelevant(true);
        } else {
            ts.setRelevant(xml.getRelevant());
        }
        return ts;
    }

    private ITestJobPO createTestJob(TestJobs xml, boolean assignNewGuid) throws InvalidDataException {
        ITestJobPO tj = xml.getGUID() != null && !assignNewGuid ? NodeMaker.createTestJobPO((String)xml.getName(), (String)xml.getGUID()) : NodeMaker.createTestJobPO((String)xml.getName());
        tj.setComment(xml.getComment());
        tj.setDescription(xml.getDescription());
        tj.setTaskId(xml.getTaskId());
        this.fillTrackedChangesInformation((INodePO)tj, xml);
        List<RefTestSuite> refTestSuiteList = xml.getRefTestSuiteList();
        if (!refTestSuiteList.isEmpty()) {
            for (RefTestSuite xmlRts : refTestSuiteList) {
                this.processRefTestSuite(assignNewGuid, tj, xmlRts);
            }
        } else {
            for (TestJobs.Testjobelement element : xml.getTestjobelementList()) {
                RefTestSuite xmlRts = element.getRefTestSuite();
                if (xmlRts != null) {
                    this.processRefTestSuite(assignNewGuid, tj, xmlRts);
                    continue;
                }
                Comment xmlComment = element.getComment();
                tj.addNode((INodePO)this.createComment(xmlComment, false));
            }
        }
        return tj;
    }

    private void processRefTestSuite(boolean assignNewGuid, ITestJobPO tj, RefTestSuite xmlRts) throws InvalidDataException {
        if (xmlRts != null) {
            IRefTestSuitePO rts;
            if (assignNewGuid) {
                String testSuiteGuid = this.m_oldToNewGuids.get(xmlRts.getTsGuid());
                if (testSuiteGuid == null) {
                    throw new InvalidDataException("Test Suite Reference: No new GUID found for Test Suite with old GUID: " + xmlRts.getTsGuid(), MessageIDs.E_IMPORT_PROJECT_XML_FAILED);
                }
                rts = NodeMaker.createRefTestSuitePO((String)xmlRts.getName(), (String)testSuiteGuid, (String)xmlRts.getAutId());
            } else {
                rts = NodeMaker.createRefTestSuitePO((String)xmlRts.getName(), (String)xmlRts.getGUID(), (String)xmlRts.getTsGuid(), (String)xmlRts.getAutId());
            }
            rts.setComment(xmlRts.getComment());
            rts.setDescription(xmlRts.getDescription());
            tj.addNode((INodePO)rts);
        }
    }

    private void fillTrackedChangesInformation(INodePO poNode, Node xmlNode) {
        List<MapEntry> trackedModificationList = xmlNode.getTrackedModificationList();
        if (!trackedModificationList.isEmpty() && !this.m_skipTrackingInformation) {
            HashMap<Long, String> trackedChanges = new HashMap<Long, String>();
            for (MapEntry me : trackedModificationList) {
                trackedChanges.put(Long.valueOf(me.getKey()), me.getValue());
            }
            poNode.setTrackedChangesMap(trackedChanges);
        }
    }

    private void fillExecTestCase(IProjectPO proj, RefTestCase xml, IExecTestCasePO exec, boolean assignNewGuid) {
        exec.setName(xml.getName());
        exec.setComment(xml.getComment());
        exec.setDescription(xml.getDescription());
        exec.setGenerated(xml.getGenerated());
        exec.setTaskId(xml.getTaskId());
        if (xml.isSetActive()) {
            exec.setActive(xml.getActive());
        } else {
            exec.setActive(true);
        }
        exec.setDataFile(xml.getDatafile());
        if (xml.getReferencedTestData() != null) {
            String referencedDataName = xml.getReferencedTestData();
            ITestDataCubePO[] iTestDataCubePOArray = TestDataCubeBP.getAllTestDataCubesFor((IProjectPO)proj);
            int n = iTestDataCubePOArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITestDataCubePO testDataCube = iTestDataCubePOArray[n2];
                if (referencedDataName.equals(testDataCube.getName())) {
                    exec.setReferencedDataCube((IParameterInterfacePO)testDataCube);
                    break;
                }
                ++n2;
            }
        }
        if (xml.getHasOwnTestdata()) {
            exec.setDataManager(this.createTDManager((IParameterInterfacePO)exec, xml.getTestdata(), assignNewGuid));
        }
        for (CompNames overriddenXml : xml.getOverriddenNamesList()) {
            ICompNamesPairPO compName = PoMaker.createCompNamesPairPO((String)overriddenXml.getOriginalName(), (String)overriddenXml.getNewName(), null);
            compName.setPropagated(overriddenXml.getPropagated());
            exec.addCompNamesPair(compName);
        }
        this.m_monitor.worked(1);
    }

    private IAUTMainPO findReferencedAut(String selectedAut) {
        return this.m_autRef.get(selectedAut);
    }

    private ISpecTestCasePO findReferencedTC(String usedTestcase) {
        return this.m_tcRef.get(usedTestcase);
    }

    private void rerunCategories(IProjectPO proj, Category xml, boolean assignNewGuid, EntityManager attrDescSession) throws InvalidDataException, InterruptedException {
        for (Category catXml : xml.getCategoryList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            this.rerunCategories(proj, catXml, assignNewGuid, attrDescSession);
        }
        for (TestCase tcXml : xml.getTestcaseList()) {
            ImportExportUtil.checkCancel(this.m_monitor);
            this.completeTestCase(proj, tcXml, assignNewGuid, attrDescSession);
        }
    }

    private boolean componentHasDefaultMapping(String componentType) {
        Component component = ComponentBuilder.getInstance().getCompSystem().findComponent(componentType);
        if (component.isConcrete()) {
            return ((ConcreteComponent)component).hasDefaultMapping();
        }
        return false;
    }
}

