/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.warproducts.ui.editor;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.libra.warproducts.ui.editor.WebXMLModel;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.plugin.DocumentGenericNode;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.XMLSourcePage;
import org.eclipse.swt.graphics.Image;

public class WebXMLSourcePage
extends XMLSourcePage {
    private ITreeContentProvider contentProvider;
    private ILabelProvider labelProvider;

    public WebXMLSourcePage(PDEFormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    public boolean isQuickOutlineEnabled() {
        return true;
    }

    public ILabelProvider createOutlineLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new WebXmlLabelProvider();
        }
        return this.labelProvider;
    }

    public ITreeContentProvider createOutlineContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = new WebXmlContentProvider();
        }
        return this.contentProvider;
    }

    public ViewerComparator createOutlineComparator() {
        return new ViewerComparator();
    }

    public void updateSelection(Object object) {
        if (object instanceof DocumentGenericNode) {
            DocumentGenericNode node = (DocumentGenericNode)object;
            this.selectAndReveal(node.getOffset(), node.getLength());
        }
    }

    private class WebXmlContentProvider
    implements ITreeContentProvider {
        private WebXmlContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] result = new Object[]{};
            if (inputElement instanceof WebXMLModel) {
                WebXMLModel model = (WebXMLModel)((Object)inputElement);
                Object documentRoot = model.getDocumentRoot();
                result = new Object[]{documentRoot};
            }
            return result;
        }

        public Object[] getChildren(Object element) {
            Object[] result = new Object[]{};
            if (element instanceof DocumentGenericNode) {
                DocumentGenericNode node = (DocumentGenericNode)element;
                result = node.getChildNodes();
            }
            return result;
        }

        public Object getParent(Object element) {
            IDocumentElementNode result = null;
            if (element instanceof DocumentGenericNode) {
                DocumentGenericNode node = (DocumentGenericNode)element;
                result = node.getParentNode();
            }
            return result;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }
    }

    private static final class WebXmlLabelProvider
    extends LabelProvider {
        private PDELabelProvider pdeLabelProvider = PDEPlugin.getDefault().getLabelProvider();

        private WebXmlLabelProvider() {
        }

        public String getText(Object element) {
            String result = "";
            if (element instanceof DocumentGenericNode) {
                DocumentGenericNode node = (DocumentGenericNode)element;
                result = node.getXMLTagName();
            } else {
                result = super.getText(element);
            }
            return result;
        }

        public Image getImage(Object element) {
            Image result = null;
            if (element instanceof DocumentGenericNode) {
                result = this.pdeLabelProvider.get(PDEPluginImages.DESC_XML_ELEMENT_OBJ);
            }
            return result;
        }
    }
}

