/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.linuxtools.internal.rpm.ui.editor.SpecfileEditor;
import org.eclipse.linuxtools.internal.rpm.ui.editor.hyperlink.MailHyperlink;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;

public class MailHyperlinkDetector
extends AbstractHyperlinkDetector {
    private SpecfileEditor editor;

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String body;
        String mail;
        int mailOffsetInLine;
        IRegion lineInfo;
        int mailLength;
        String urlString;
        block29: {
            String line;
            if (region == null || textViewer == null) {
                return null;
            }
            if (this.editor == null) {
                this.editor = (SpecfileEditor)((Object)this.getAdapter(SpecfileEditor.class));
                if (this.editor == null) {
                    return null;
                }
            }
            IDocument document = textViewer.getDocument();
            int offset = region.getOffset();
            urlString = null;
            if (document == null) {
                return null;
            }
            mailLength = 0;
            try {
                lineInfo = document.getLineInformationOfOffset(offset);
                line = document.get(lineInfo.getOffset(), lineInfo.getLength());
            }
            catch (BadLocationException ex) {
                ex.printStackTrace();
                return null;
            }
            int startSeparator = line.indexOf(60);
            mailOffsetInLine = startSeparator + 1;
            if (startSeparator != -1) {
                int endSeparator = line.indexOf(62);
                if (endSeparator < 5) {
                    return null;
                }
                mail = line.substring(startSeparator + 1, endSeparator).trim();
                mailLength = mail.length();
                mail = mail.replaceAll("(?i) at ", "@");
                mail = mail.replaceAll("(?i) dot ", ".");
                mail = mail.replaceAll("(?i)_at_", "@");
                mail = mail.replaceAll("(?i)_dot_", ".");
                if ((mail = mail.replaceAll(" +", " ")).split(" ").length == 3 && mail.indexOf(64) == -1) {
                    mail = mail.replaceFirst(" ", "@").replaceFirst(" ", ".");
                }
                mail = mail.replaceAll(" ", "");
            } else {
                int offsetInLine = offset - lineInfo.getOffset();
                boolean startDoubleQuote = false;
                mailOffsetInLine = 0;
                int mailSeparatorOffset = line.indexOf(64);
                while (mailSeparatorOffset >= 0) {
                    char ch;
                    mailOffsetInLine = mailSeparatorOffset;
                    do {
                        ch = ' ';
                        if (--mailOffsetInLine > -1) {
                            ch = line.charAt(mailOffsetInLine);
                        }
                        boolean bl = startDoubleQuote = ch == '\"';
                    } while (Character.isLetterOrDigit(ch) || ch == 46 || ch == 95 || ch == 45);
                    if (++mailOffsetInLine == mailSeparatorOffset) {
                        return null;
                    }
                    StringTokenizer tokenizer = new StringTokenizer(line.substring(mailSeparatorOffset + 3), " \t\n\r\f<>", false);
                    if (!tokenizer.hasMoreTokens()) {
                        return null;
                    }
                    mailLength = tokenizer.nextToken().length() + 3 + mailSeparatorOffset - mailOffsetInLine;
                    if (offsetInLine >= mailOffsetInLine && offsetInLine <= mailOffsetInLine + mailLength) break;
                    mailSeparatorOffset = line.indexOf(64, mailSeparatorOffset + 1);
                }
                if (mailSeparatorOffset < 0) {
                    return null;
                }
                if (startDoubleQuote) {
                    int endOffset = -1;
                    int nextDoubleQuote = line.indexOf(34, mailOffsetInLine);
                    int nextWhitespace = line.indexOf(32, mailOffsetInLine);
                    if (nextDoubleQuote != -1 && nextWhitespace != -1) {
                        endOffset = Math.min(nextDoubleQuote, nextWhitespace);
                    } else if (nextDoubleQuote != -1) {
                        endOffset = nextDoubleQuote;
                    } else if (nextWhitespace != -1) {
                        endOffset = nextWhitespace;
                    }
                    if (endOffset != -1) {
                        mailLength = endOffset - mailOffsetInLine;
                    }
                }
                if (mailLength == 0) {
                    return null;
                }
                mail = line.substring(mailOffsetInLine, mailOffsetInLine + mailLength);
            }
            try {
                if (mail.contains("@") && mail.contains(".")) break block29;
                return null;
            }
            catch (MalformedURLException ex) {
                ex.printStackTrace();
                urlString = null;
                return null;
            }
        }
        urlString = "mailto:" + mail;
        int separator = 63;
        String subject = this.getSubject();
        if (subject != null) {
            urlString = String.valueOf(urlString) + (char)separator + "subject=" + subject;
            separator = 38;
        }
        if ((body = this.getBody()) != null) {
            urlString = String.valueOf(urlString) + (char)separator + "body=" + body;
        }
        urlString = urlString.replaceAll("\\%", "\\%25");
        new URL(urlString);
        Region urlRegion = new Region(lineInfo.getOffset() + mailOffsetInLine, mailLength);
        return new IHyperlink[]{new MailHyperlink((IRegion)urlRegion, urlString)};
    }

    private String getSubject() {
        Specfile specfile = this.editor.getSpecfile();
        return MessageFormat.format("[{0}.spec - {1}-{2}]", specfile.getName(), specfile.getVersion(), specfile.getRelease());
    }

    private String getBody() {
        String body = null;
        IDocument document = this.editor.getAdapter(IDocument.class);
        ISelection currentSelection = this.editor.getSpecfileSourceViewer().getSelection();
        if (currentSelection instanceof ITextSelection) {
            ITextSelection selection = (ITextSelection)currentSelection;
            try {
                String txt = selection.getText();
                if (txt.trim().length() > 0) {
                    int begin = document.getLineOffset(selection.getStartLine());
                    body = document.get().substring(begin, selection.getOffset() + selection.getLength());
                    body = body.replaceAll("(?m)^[ \\t]+|[ \\t]+$|^", " ");
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return body;
    }

    public void setEditor(SpecfileEditor editor) {
        this.editor = editor;
    }
}

