/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.profiler.ui.profilingdatatable;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.m2m.atl.profiler.core.util.ProfilingModelUtils;
import org.eclipse.m2m.atl.profiler.model.ATLOperation;
import org.eclipse.m2m.atl.profiler.model.ProfilingOperation;

public class TotalInstructionComparator
extends ViewerComparator {
    private boolean asc;

    public TotalInstructionComparator() {
        this.asc = true;
    }

    public TotalInstructionComparator(boolean asc) {
        this.asc = asc;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (e1 instanceof ATLOperation) {
            ATLOperation op1 = (ATLOperation)e1;
            ATLOperation op2 = (ATLOperation)e2;
            int iop1 = ProfilingModelUtils.getTotalInstruction((ATLOperation)op1);
            int iop2 = ProfilingModelUtils.getTotalInstruction((ATLOperation)op2);
            if (this.asc) {
                return iop1 - iop2;
            }
            return iop2 - iop1;
        }
        if (e1 instanceof ProfilingOperation) {
            ProfilingOperation pop1 = (ProfilingOperation)e1;
            ProfilingOperation pop2 = (ProfilingOperation)e2;
            int iop1 = pop1.getTotalExecutedInstructions();
            int iop2 = pop2.getTotalExecutedInstructions();
            if (this.asc) {
                return iop1 - iop2;
            }
            return iop2 - iop1;
        }
        return 0;
    }
}

