/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.report;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.report.ITestResult;
import org.eclipse.mat.report.Spec;
import org.eclipse.mat.report.SpecFactory;
import org.eclipse.mat.report.internal.AbstractPart;
import org.eclipse.mat.report.internal.PartsFactory;
import org.eclipse.mat.report.internal.ResultRenderer;
import org.eclipse.mat.util.FileUtils;
import org.eclipse.mat.util.IProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestSuite {
    private final Spec spec;
    private final IQueryContext queryContext;
    private File output;
    private final List<File> results = new ArrayList<File>();

    private TestSuite(Spec spec, IQueryContext queryContext) {
        this.spec = spec;
        this.queryContext = queryContext;
    }

    public ITestResult.Status execute(IProgressListener listener) throws IOException, SnapshotException {
        PartsFactory factory = new PartsFactory();
        AbstractPart part = factory.createRoot(this.spec);
        ResultRenderer renderer = new ResultRenderer();
        renderer.beginSuite(this, part);
        part = part.execute(this.queryContext, renderer, listener);
        renderer.endSuite(part);
        return part.getStatus();
    }

    public Spec spec() {
        return this.spec;
    }

    public IQueryContext getQueryContext() {
        return this.queryContext;
    }

    public File getOutput() {
        return this.output != null ? this.output : this.queryContext.getPrimaryFile().getParentFile();
    }

    public List<File> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public void addResult(File result) {
        this.results.add(result);
    }

    /* synthetic */ TestSuite(Spec spec, IQueryContext iQueryContext, TestSuite testSuite) {
        this(spec, iQueryContext);
    }

    public static class Builder {
        private Spec template;
        private File output;

        public Builder(String identifier) throws SnapshotException {
            try {
                SpecFactory factory = SpecFactory.instance();
                this.template = factory.create(identifier);
                factory.resolve(this.template);
            }
            catch (Exception e) {
                throw new SnapshotException(e);
            }
        }

        public Builder(File specFile) throws SnapshotException {
            try {
                SpecFactory factory = SpecFactory.instance();
                this.template = factory.create(specFile);
                factory.resolve(this.template);
            }
            catch (Exception e) {
                throw new SnapshotException(e);
            }
        }

        public Builder(Spec spec) {
            this.template = spec;
        }

        public Builder output(File file) {
            this.output = file;
            return this;
        }

        public TestSuite build(IQueryContext queryContext) {
            this.template.set("timestamp", String.valueOf(System.currentTimeMillis()));
            if (this.output == null) {
                String suffix;
                String prefix = queryContext.getPrefix();
                int p = prefix.lastIndexOf(46);
                if (p == prefix.length() - 1) {
                    prefix = prefix.substring(0, p);
                }
                if ((suffix = this.template.getParams().get("filename_suffix")) == null) {
                    suffix = this.template.getName();
                }
                this.output = new File(String.valueOf(prefix) + "_" + FileUtils.toFilename(suffix, "zip"));
            }
            TestSuite testSuite = new TestSuite(this.template, queryContext, null);
            testSuite.output = this.output;
            return testSuite;
        }
    }
}

