/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui.pr;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.github.core.PullRequest;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestComposite;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestConnector;
import org.eclipse.mylyn.internal.github.core.pr.PullRequestUtils;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.TaskDataHandler;
import org.eclipse.mylyn.internal.github.ui.pr.Messages;
import org.eclipse.mylyn.internal.github.ui.pr.PullRequestConnectorUi;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class FetchPullRequestHandler
extends TaskDataHandler {
    public static final String ID = "org.eclipse.mylyn.github.ui.command.fetchPullRequest";

    public Object execute(final ExecutionEvent event) throws ExecutionException {
        final TaskData data = this.getTaskData(event);
        if (data == null) {
            return null;
        }
        Job job = new Job(MessageFormat.format(Messages.FetchPullRequestHandler_JobName, data.getTaskId())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    PullRequestComposite prComp = PullRequestConnector.getPullRequest((TaskData)data);
                    if (prComp == null) {
                        return Status.CANCEL_STATUS;
                    }
                    PullRequest request = prComp.getRequest();
                    Repository repo = PullRequestUtils.getRepository((PullRequest)request);
                    if (repo == null) {
                        PullRequestConnectorUi.showNoRepositoryDialog(request);
                        return Status.CANCEL_STATUS;
                    }
                    RemoteConfig remote = PullRequestUtils.addRemote((Repository)repo, (PullRequest)request);
                    new FetchOperationUI(repo, remote, Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout"), false).execute(monitor);
                    FetchPullRequestHandler.this.executeCallback(event);
                }
                catch (IOException e) {
                    GitHubUi.logError(e);
                }
                catch (URISyntaxException e) {
                    GitHubUi.logError(e);
                }
                catch (CoreException e) {
                    GitHubUi.logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        this.schedule(job, event);
        return null;
    }
}

