/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.connector;

import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.net4j.util.security.INegotiatorAware;
import org.eclipse.net4j.util.security.IPasswordCredentialsProvider;
import org.eclipse.net4j.util.security.ResponseNegotiator;
import org.eclipse.net4j.util.security.ResponseNegotiatorInjector;

public class ConnectorCredentialsInjector
extends ResponseNegotiatorInjector {
    private String connectorDescription;

    public ConnectorCredentialsInjector(String connectorDescription, IPasswordCredentialsProvider credentialsProvider, String algorithmName) {
        super((INegotiator)ConnectorCredentialsInjector.createNegotiator(credentialsProvider, algorithmName));
        this.connectorDescription = connectorDescription;
    }

    public ConnectorCredentialsInjector(String connectorDescription, IPasswordCredentialsProvider credentialsProvider) {
        this(connectorDescription, credentialsProvider, "PBEWithMD5AndDES");
    }

    protected boolean filterElement(String productGroup, String factoryType, String description, INegotiatorAware negotiatorAware) {
        IConnector connector;
        if (negotiatorAware instanceof IConnector && (connector = (IConnector)negotiatorAware).isClient()) {
            return this.filterConnectorDescription(description);
        }
        return false;
    }

    protected boolean filterConnectorDescription(String description) {
        if (this.connectorDescription == null) {
            return true;
        }
        return this.connectorDescription.equals(description);
    }

    private static ResponseNegotiator createNegotiator(IPasswordCredentialsProvider credentialsProvider, String algorithmName) {
        ResponseNegotiator negotiator = new ResponseNegotiator();
        negotiator.setCredentialsProvider(credentialsProvider);
        negotiator.setEncryptionAlgorithmName(algorithmName);
        return negotiator;
    }
}

