/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.ReconnectRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionAnchorsCommand;
import org.eclipse.gmf.runtime.diagram.core.commands.SetConnectionEndsCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.INodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.commands.SetConnectionBendpointsCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IAnchorableFigure;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.Routing;
import org.eclipse.gmf.runtime.notation.RoutingStyle;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.LinkLFShapeNodeAnchorDelegate;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.SlidableSnapToGridAnchor;
import org.eclipse.papyrus.infra.gmfdiag.tooling.runtime.linklf.policies.SetAbsoluteBendpointsCommand;

public class LinksLFGraphicalNodeEditPolicy
extends GraphicalNodeEditPolicy {
    private static final String PARAM_SOURCE_ANCHOR = String.valueOf(LinksLFGraphicalNodeEditPolicy.class.getName()) + ":SourceAnchor";

    protected Command getReconnectTargetCommand(ReconnectRequest request) {
        Command cmdRouter;
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        GetTargetAnchorAndBendpoints anchorAndBendpoints = new GetTargetAnchorAndBendpoints();
        ConnectionAnchor targetAnchor = anchorAndBendpoints.getAnchorAndBendpoints((Request)request);
        INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
        if (targetEP == null) {
            return null;
        }
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        sceCommand.setNewTargetAdaptor((IAdaptable)targetEP);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
        scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(targetAnchor));
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_SetConnectionEndsCommand_Target);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        if (anchorAndBendpoints.getBendpointsHint() != null) {
            SetAbsoluteBendpointsCommand scbCommand = new SetAbsoluteBendpointsCommand(editingDomain);
            scbCommand.setEdgeAdapter((IAdaptable)new EObjectAdapter((EObject)request.getConnectionEditPart().getModel()));
            scbCommand.setNewPointList(anchorAndBendpoints.getBendpointsHint().getCopy());
            cc.compose((IUndoableOperation)scbCommand);
        }
        ICommandProxy cmd = new ICommandProxy((ICommand)cc);
        org.eclipse.gef.ConnectionEditPart cep = request.getConnectionEditPart();
        RoutingStyle style = (RoutingStyle)((View)cep.getModel()).getStyle(NotationPackage.eINSTANCE.getRoutingStyle());
        Routing currentRouter = Routing.MANUAL_LITERAL;
        if (style != null) {
            currentRouter = style.getRouting();
        }
        if ((cmdRouter = this.getRoutingAdjustment((IAdaptable)request.getConnectionEditPart(), this.getSemanticHint((Request)request), currentRouter, request.getTarget())) != null) {
            cmd = cmd == null ? cmdRouter : cmd.chain(cmdRouter);
            ConnectionAnchor sourceAnchor = node.getSourceConnectionAnchor((Request)request);
            PointList pointList = new PointList();
            pointList.addPoint(sourceAnchor.getLocation(targetAnchor.getReferencePoint()));
            pointList.addPoint(targetAnchor.getLocation(sourceAnchor.getReferencePoint()));
            SetAbsoluteBendpointsCommand sbbCommand = new SetAbsoluteBendpointsCommand(editingDomain);
            sbbCommand.setEdgeAdapter((IAdaptable)request.getConnectionEditPart());
            sbbCommand.setNewPointList(pointList, sourceAnchor.getReferencePoint(), targetAnchor.getReferencePoint());
            ICommandProxy cmdBP = new ICommandProxy((ICommand)sbbCommand);
            if (cmdBP != null) {
                cmd = cmd == null ? cmdBP : cmd.chain((Command)cmdBP);
            }
        }
        return cmd;
    }

    protected Command getReconnectSourceCommand(ReconnectRequest request) {
        INodeEditPart node = this.getConnectableEditPart();
        if (node == null) {
            return null;
        }
        GetSourceAnchorAndBendpoints anchorAndBendpoints = new GetSourceAnchorAndBendpoints();
        anchorAndBendpoints.getAnchorAndBendpoints((Request)request);
        Command result = super.getReconnectSourceCommand(request);
        if (anchorAndBendpoints.getBendpointsHint() != null && result != null && result.canExecute()) {
            ICommand iCommand = ((ICommandProxy)result).getICommand();
            CompositeCommand cc = (CompositeCommand)iCommand;
            SetAbsoluteBendpointsCommand sbcCommand = new SetAbsoluteBendpointsCommand(this.getEditingDomain());
            sbcCommand.setEdge((ConnectionEditPart)request.getConnectionEditPart());
            sbcCommand.setNewPointList(anchorAndBendpoints.getBendpointsHint());
            cc.compose((IUndoableOperation)sbcCommand);
        }
        return result;
    }

    protected Command getConnectionCompleteCommand(CreateConnectionRequest request) {
        Command result = super.getConnectionCompleteCommand(request);
        if (result == null) {
            return result;
        }
        ICommandProxy proxy = (ICommandProxy)request.getStartCommand();
        if (proxy == null) {
            return null;
        }
        CompositeCommand cc = (CompositeCommand)proxy.getICommand();
        Iterator commandItr = cc.iterator();
        commandItr.next();
        commandItr.next();
        SetConnectionAnchorsCommand scaCommand = (SetConnectionAnchorsCommand)commandItr.next();
        SetConnectionBendpointsCommand sbpCommand = (SetConnectionBendpointsCommand)commandItr.next();
        ConnectionAnchor targetAnchor = this.getConnectionCompleteEditPart((Request)request).getTargetConnectionAnchor((Request)request);
        ConnectionAnchor sourceAnchor = (ConnectionAnchor)request.getExtendedData().get(PARAM_SOURCE_ANCHOR);
        PointList points = sbpCommand.getNewPointList();
        if (points != null) {
            points = points.getCopy();
        }
        if (targetAnchor instanceof SlidableSnapToGridAnchor && sourceAnchor instanceof SlidableSnapToGridAnchor) {
            SlidableSnapToGridAnchor sourceAnchorImpl = (SlidableSnapToGridAnchor)sourceAnchor;
            SlidableSnapToGridAnchor targetAnchorImpl = (SlidableSnapToGridAnchor)targetAnchor;
            Point updatedSourceLoc = sourceAnchorImpl.getLocation(targetAnchorImpl.getReferencePoint());
            Point updatedTargetLoc = targetAnchorImpl.getLocation(updatedSourceLoc);
            INodeEditPart targetEP = this.getConnectionCompleteEditPart((Request)request);
            INodeEditPart sourceEP = (INodeEditPart)request.getSourceEditPart();
            IAnchorableFigure sourceFigure = (IAnchorableFigure)sourceEP.getFigure();
            IAnchorableFigure targetFigure = (IAnchorableFigure)targetEP.getFigure();
            ConnectionAnchor updatedSourceAnchor = sourceFigure.getSourceConnectionAnchorAt(updatedSourceLoc);
            ConnectionAnchor updatedTargetAnchor = targetFigure.getTargetConnectionAnchorAt(updatedTargetLoc);
            scaCommand.setNewSourceTerminal(sourceEP.mapConnectionAnchorToTerminal(updatedSourceAnchor));
            scaCommand.setNewTargetTerminal(targetEP.mapConnectionAnchorToTerminal(updatedTargetAnchor));
            points = new PointList();
            points.addPoint(updatedSourceAnchor.getReferencePoint());
            points.addPoint(updatedTargetAnchor.getReferencePoint());
        }
        if (points != null) {
            GraphicalEditPart diagramEP = (GraphicalEditPart)this.getHost().getViewer().getContents();
            diagramEP.getContentPane().translateToRelative((Translatable)points);
            sbpCommand.setNewPointList(points, sourceAnchor, targetAnchor);
        }
        return result;
    }

    protected Command getConnectionCreateCommand(CreateConnectionRequest request) {
        if (!(request instanceof CreateConnectionViewRequest)) {
            return null;
        }
        CreateConnectionViewRequest req = (CreateConnectionViewRequest)request;
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.Commands_CreateCommand_Connection_Label);
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        CreateCommand createCommand = this.createCreateConnectionViewCommand(req);
        this.setViewAdapter((IAdaptable)createCommand.getCommandResult().getReturnValue());
        SetConnectionEndsCommand sceCommand = new SetConnectionEndsCommand(editingDomain, "");
        sceCommand.setEdgeAdaptor(this.getViewAdapter());
        sceCommand.setNewSourceAdaptor((IAdaptable)new EObjectAdapter((EObject)this.getView()));
        ConnectionAnchor sourceAnchor = this.getConnectableEditPart().getSourceConnectionAnchor((Request)request);
        SetConnectionAnchorsCommand scaCommand = new SetConnectionAnchorsCommand(editingDomain, "");
        scaCommand.setEdgeAdaptor(this.getViewAdapter());
        scaCommand.setNewSourceTerminal(this.getConnectableEditPart().mapConnectionAnchorToTerminal(sourceAnchor));
        SetAbsoluteBendpointsCommand sbbCommand = new SetAbsoluteBendpointsCommand(editingDomain);
        sbbCommand.setEdgeAdapter(this.getViewAdapter());
        cc.compose((IUndoableOperation)createCommand);
        cc.compose((IUndoableOperation)sceCommand);
        cc.compose((IUndoableOperation)scaCommand);
        cc.compose((IUndoableOperation)sbbCommand);
        ICommandProxy c = new ICommandProxy((ICommand)cc);
        request.setStartCommand((Command)c);
        request.getExtendedData().put(PARAM_SOURCE_ANCHOR, sourceAnchor);
        return c;
    }

    protected TransactionalEditingDomain getEditingDomain() {
        return ((IGraphicalEditPart)this.getHost()).getEditingDomain();
    }

    protected CreateCommand createCreateConnectionViewCommand(CreateConnectionViewRequest req) {
        Diagram diagramView = ((View)this.getHost().getModel()).getDiagram();
        CreateCommand createCommand = new CreateCommand(this.getEditingDomain(), (CreateViewRequest.ViewDescriptor)req.getConnectionViewDescriptor(), (View)diagramView.getDiagram());
        return createCommand;
    }

    private static abstract class GetAnchorAndBendpoints {
        private PointList myBendpointsHint;

        private GetAnchorAndBendpoints() {
        }

        protected abstract ConnectionAnchor doGetConnectionAnchor(Request var1);

        public ConnectionAnchor getAnchorAndBendpoints(Request request) {
            ConnectionAnchor result;
            PointList oldHint = (PointList)GetAnchorAndBendpoints.getExtendedData(request).get(LinkLFShapeNodeAnchorDelegate.KEY_ROUTED_LINK_POINTS);
            try {
                result = this.doGetConnectionAnchor(request);
                this.myBendpointsHint = (PointList)GetAnchorAndBendpoints.getExtendedData(request).get(LinkLFShapeNodeAnchorDelegate.KEY_ROUTED_LINK_POINTS);
            }
            finally {
                GetAnchorAndBendpoints.getExtendedData(request).put(LinkLFShapeNodeAnchorDelegate.KEY_ROUTED_LINK_POINTS, oldHint);
            }
            return result;
        }

        public PointList getBendpointsHint() {
            return this.myBendpointsHint;
        }

        private static Map<String, Object> getExtendedData(Request req) {
            return req.getExtendedData();
        }
    }

    private class GetSourceAnchorAndBendpoints
    extends GetAnchorAndBendpoints {
        private GetSourceAnchorAndBendpoints() {
        }

        @Override
        protected ConnectionAnchor doGetConnectionAnchor(Request request) {
            return LinksLFGraphicalNodeEditPolicy.this.getConnectableEditPart().getSourceConnectionAnchor(request);
        }
    }

    private class GetTargetAnchorAndBendpoints
    extends GetAnchorAndBendpoints {
        private GetTargetAnchorAndBendpoints() {
        }

        @Override
        protected ConnectionAnchor doGetConnectionAnchor(Request request) {
            return LinksLFGraphicalNodeEditPolicy.this.getConnectionTargetAnchor(request);
        }
    }
}

