/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.common.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.nattable.common.helper.TableViewPrototype;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.representation.PapyrusTable;
import org.eclipse.papyrus.infra.nattable.representation.RepresentationPackage;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;

public class TableCommandHelper
implements IViewTypeHelper {
    private Map<PapyrusRepresentationKind, TableViewPrototype> cache;

    public ViewPrototype getPrototypeFor(PapyrusRepresentationKind configuration) {
        if (!(configuration instanceof PapyrusTable)) {
            return null;
        }
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusRepresentationKind, TableViewPrototype>();
        }
        if (this.cache.containsKey(configuration)) {
            return this.cache.get(configuration);
        }
        TableViewPrototype proto = new TableViewPrototype((PapyrusTable)configuration);
        this.cache.put(configuration, proto);
        return proto;
    }

    public boolean isSupported(EClass type) {
        return type == RepresentationPackage.eINSTANCE.getPapyrusTable();
    }

    public boolean isSupported(EObject view) {
        if (!(view instanceof Table)) {
            return false;
        }
        Table table = (Table)view;
        return table.getTableKindId() != null || table.getTableConfiguration() != null;
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        if (!this.isSupported(view)) {
            return null;
        }
        PolicyChecker checker = PolicyChecker.getFor((EObject)view);
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        PapyrusTable repKind = (PapyrusTable)manager.getRepresentationKindById(((Table)view).getTableKindId());
        if (repKind != null && checker.isInViewpoint((PapyrusRepresentationKind)repKind)) {
            return this.getPrototypeFor((PapyrusRepresentationKind)repKind);
        }
        return ViewPrototype.UNAVAILABLE_VIEW;
    }
}

