/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.filter.configuration;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.validate.IDataValidator;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.papyrus.infra.nattable.comparator.IntegerFilterComparator;
import org.eclipse.papyrus.infra.nattable.filter.configuration.AbstractNumericEditorFilterConfiguration;
import org.eclipse.papyrus.infra.nattable.filter.validator.IntegerFilterDataValidator;
import org.eclipse.papyrus.infra.tools.util.TypeUtils;

public abstract class AbstractIntegerEditorFilterConfiguration
extends AbstractNumericEditorFilterConfiguration {
    @Override
    public void configureFilter(IConfigRegistry configRegistry, Object columnElement, String configLabel) {
        super.configureFilter(configRegistry, columnElement, configLabel);
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, (Object)IntegerFilterComparator.getInstance(), "NORMAL", configLabel);
        configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)new IntegerToStringConverter(), "NORMAL", configLabel);
    }

    @Override
    protected IDataValidator getDataValidator(IConfigRegistry configRegistry) {
        return new IntegerFilterDataValidator((String)configRegistry.getConfigAttribute(FilterRowConfigAttributes.TEXT_DELIMITER, "NORMAL", new String[0]), TextMatchingMode.REGULAR_EXPRESSION);
    }

    @Override
    public String getConfigurationDescription() {
        return "This editor allows to filter on integer value, using >, >=, <, <=, =, <>";
    }

    private static final class IntegerToStringConverter
    implements IDisplayConverter {
        private IntegerToStringConverter() {
        }

        public Object canonicalToDisplayValue(Object canonicalValue) {
            return null;
        }

        public Object displayToCanonicalValue(Object displayValue) {
            Assert.isTrue((boolean)(displayValue instanceof String));
            Assert.isTrue((boolean)TypeUtils.isIntegerValue((String)((String)displayValue)));
            return Integer.valueOf((String)displayValue);
        }

        public Object canonicalToDisplayValue(ILayerCell cell, IConfigRegistry configRegistry, Object canonicalValue) {
            ArrayList<String> values = new ArrayList<String>();
            if (canonicalValue instanceof Collection) {
                Collection col = (Collection)canonicalValue;
                for (Object object : col) {
                    values.add(object.toString());
                }
            } else {
                values.add(canonicalValue.toString());
            }
            return values;
        }

        public Object displayToCanonicalValue(ILayerCell cell, IConfigRegistry configRegistry, Object displayValue) {
            return null;
        }
    }
}

