/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.decoration.util;

import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.services.decoration.DecorationService;
import org.eclipse.papyrus.infra.services.decoration.util.IPapyrusDecoration;

public class Decoration
implements IPapyrusDecoration {
    private final String id;
    private String message;
    private EObject element;
    private ImageDescriptor decorationImageForGE;
    private ImageDescriptor decorationImageForME;
    private String type;
    private PreferedPosition position;
    private int priority;

    public Decoration(String id, String type, ImageDescriptor decorationImageForGE, ImageDescriptor decorationImageForME, String message, EObject element, int priority) {
        this.id = id;
        this.decorationImageForGE = decorationImageForGE;
        this.decorationImageForME = decorationImageForME;
        this.message = message;
        this.element = element;
        this.type = type;
        this.position = PreferedPosition.SOUTH_EAST;
        this.priority = priority;
    }

    public String getId() {
        return this.id;
    }

    public String getType() {
        return this.type;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public EObject getElement() {
        return this.element;
    }

    public void setElement(EObject element) {
        this.element = element;
    }

    public ImageDescriptor getDecorationImageForGE() {
        return this.decorationImageForGE;
    }

    public void setDecorationImageForGE(ImageDescriptor decorationImageForGE) {
        this.decorationImageForGE = decorationImageForGE;
    }

    public ImageDescriptor getDecorationImageForME() {
        return this.decorationImageForME;
    }

    public void setDecorationImageForME(ImageDescriptor decorationImageForME) {
        this.decorationImageForME = decorationImageForME;
    }

    public PreferedPosition getPosition() {
        return this.position;
    }

    public void setPosition(PreferedPosition position) {
        this.position = position;
    }

    public int getPositionForJFace() {
        switch (this.position) {
            case NORTH_WEST: 
            case NORTH: {
                return 0;
            }
            case NORTH_EAST: {
                return 1;
            }
            case SOUTH_WEST: 
            case WEST: {
                return 2;
            }
            default: {
                return 3;
            }
            case SOUTH: 
            case CENTER: 
        }
        return 4;
    }

    public static String getMessageFromDecorations(DecorationService decorationService, Object element) {
        if (decorationService == null) {
            return null;
        }
        List<IPapyrusDecoration> decorations = decorationService.getDecorations(element, true);
        EObject eObject = EMFHelper.getEObject((Object)element);
        String message = decorationService.initialMessage(eObject);
        if (decorations != null) {
            for (IPapyrusDecoration decoration : decorations) {
                if (message == null) {
                    message = "";
                }
                if (message.length() > 0) {
                    message = String.valueOf(message) + "\n";
                }
                if (decoration.getMessage() == null) continue;
                message = String.valueOf(message) + WordUtils.wrap((String)decoration.getMessage(), (int)100, (String)"\n  ", (boolean)true);
            }
        }
        if (message != null && message.length() > 0) {
            return message;
        }
        return null;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PreferedPosition {
        NORTH_WEST,
        NORTH,
        NORTH_EAST,
        EAST,
        SOUTH_EAST,
        SOUTH,
        SOUTH_WEST,
        WEST,
        CENTER,
        DEFAULT;

    }
}

