/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.services.semantic.service.impl;

import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.infra.core.language.ILanguageService;
import org.eclipse.papyrus.infra.core.resource.IEMFModel;
import org.eclipse.papyrus.infra.core.resource.IModel;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.infra.core.utils.ServiceUtils;
import org.eclipse.papyrus.infra.services.semantic.Activator;
import org.eclipse.papyrus.infra.services.semantic.service.SemanticService;

public class SemanticServiceImpl
implements SemanticService {
    private ServicesRegistry registry;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.registry = servicesRegistry;
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
        this.registry = null;
    }

    @Override
    public EObject[] getSemanticRoots() {
        EObject[] result;
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)this.registry);
            Collection<IEMFModel> emfModels = this.getEMFModels();
            if (emfModels.isEmpty()) {
                LinkedList rootElements = new LinkedList();
                for (Resource resource : modelSet.getResources()) {
                    rootElements.addAll(resource.getContents());
                }
                result = rootElements.toArray(new EObject[rootElements.size()]);
            } else {
                result = (EObject[])emfModels.stream().flatMap(m -> StreamSupport.stream(m.getRootElements().spliterator(), false)).toArray(EObject[]::new);
            }
        }
        catch (Exception ex) {
            Activator.log.error((Throwable)ex);
            result = new EObject[]{};
        }
        return result;
    }

    @Override
    public IModel[] getSemanticIModels() {
        IModel[] result;
        try {
            ModelSet modelSet = ServiceUtils.getInstance().getModelSet((Object)this.registry);
            result = (IModel[])ILanguageService.getLanguageModels((ModelSet)modelSet).stream().toArray(IModel[]::new);
        }
        catch (Exception e) {
            Activator.log.error((Throwable)e);
            result = new IModel[]{};
        }
        return result;
    }

    protected Collection<IEMFModel> getEMFModels() {
        return Stream.of(this.getSemanticIModels()).filter(IEMFModel.class::isInstance).map(IEMFModel.class::cast).distinct().collect(Collectors.toList());
    }
}

