/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.intermediateactions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.uml.diagram.activity.edit.utils.updater.AbstractActionPinUpdater;
import org.eclipse.uml2.uml.AcceptEventAction;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.OutputPin;
import org.eclipse.uml2.uml.Pin;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;

public class AcceptEventActionPinUpdater
extends AbstractActionPinUpdater<AcceptEventAction> {
    @Override
    public void updatePins(AcceptEventAction node) {
        if (node != null) {
            Iterator outputPin;
            Iterator outputPin2;
            EList originPins = node.getResults();
            ArrayList keepOutputPins = new ArrayList();
            if (node.isUnmarshall()) {
                if (node.getTriggers().size() == 1) {
                    Event event = ((Trigger)node.getTriggers().get(0)).getEvent();
                    if (event instanceof SignalEvent) {
                        for (Property property : ((SignalEvent)event).getSignal().getAllAttributes()) {
                            outputPin2 = node.getResult(property.getName(), property.getType(), true, true);
                            if (property.getType() == null) {
                                outputPin2.setType(null);
                            }
                            outputPin2.setLower(property.getLower());
                            outputPin2.setUpper(property.getUpper());
                            keepOutputPins.add(outputPin2);
                        }
                    } else if (event instanceof TimeEvent) {
                        OutputPin outputPin3 = node.getResult("time", (Type)this.getUMLPrimitiveType("Real", node.getModel()), true, true);
                        outputPin3.setLower(1);
                        outputPin3.setUpper(1);
                        keepOutputPins.add(outputPin3);
                    }
                } else if (!node.getTriggers().isEmpty()) {
                    boolean isOnlySignalEvent = true;
                    for (Trigger trigger : node.getTriggers()) {
                        if (trigger.getEvent() instanceof SignalEvent) continue;
                        isOnlySignalEvent = false;
                        break;
                    }
                    if (isOnlySignalEvent) {
                        Classifier comonAncestor = this.getTypeForMultipleTriggers((List<Trigger>)node.getTriggers());
                        if (comonAncestor != null) {
                            for (Property property : comonAncestor.getAllAttributes()) {
                                OutputPin outputPin4 = node.getResult(property.getName(), property.getType(), true, true);
                                if (property.getType() == null) {
                                    outputPin4.setType(null);
                                }
                                outputPin4.setLower(property.getLower());
                                outputPin4.setUpper(property.getUpper());
                                keepOutputPins.add(outputPin4);
                            }
                        }
                    } else {
                        boolean onlyTimeEvent = true;
                        for (Trigger trigger : node.getTriggers()) {
                            if (trigger.getEvent() instanceof TimeEvent) continue;
                            onlyTimeEvent = false;
                            break;
                        }
                        if (onlyTimeEvent) {
                            outputPin = node.getResult("time", null, true, true);
                            outputPin.setType(null);
                            outputPin.setLower(1);
                            outputPin.setUpper(1);
                            keepOutputPins.add(outputPin);
                        }
                    }
                }
            } else if (node.getTriggers().size() == 1) {
                Trigger trigger = (Trigger)node.getTriggers().get(0);
                Event event = trigger.getEvent();
                if (event instanceof SignalEvent) {
                    outputPin = node.getResult("result", (Type)((SignalEvent)event).getSignal(), true, true);
                    if (((SignalEvent)event).getSignal() == null) {
                        outputPin.setType(null);
                    }
                    outputPin.setLower(1);
                    outputPin.setUpper(1);
                    keepOutputPins.add(outputPin);
                } else if (event instanceof TimeEvent) {
                    outputPin = node.getResult("time", (Type)this.getUMLPrimitiveType("Real", node.getModel()), true, true);
                    outputPin.setLower(1);
                    outputPin.setUpper(1);
                    keepOutputPins.add(outputPin);
                }
            } else if (node.getTriggers().size() != 0) {
                boolean isOnlySignalEvent = true;
                for (Trigger trigger : node.getTriggers()) {
                    if (trigger.getEvent() instanceof SignalEvent) continue;
                    isOnlySignalEvent = false;
                    break;
                }
                if (isOnlySignalEvent) {
                    EList triggers = node.getTriggers();
                    Classifier type = this.getTypeForMultipleTriggers((List<Trigger>)triggers);
                    outputPin2 = node.getResult("result", (Type)type, true, true);
                    if (type == null) {
                        outputPin2.setType(null);
                    }
                    outputPin2.setLower(1);
                    outputPin2.setUpper(1);
                    keepOutputPins.add(outputPin2);
                } else {
                    OutputPin outputPin5 = node.getResult("result", null, true, true);
                    outputPin5.setType(null);
                    outputPin5.setLower(1);
                    outputPin5.setUpper(1);
                    keepOutputPins.add(outputPin5);
                }
            }
            for (OutputPin pin : originPins) {
                if (keepOutputPins.contains(pin)) continue;
                AcceptEventActionPinUpdater.deleteEdges((Pin)pin);
            }
            originPins.clear();
            originPins.addAll(keepOutputPins);
        }
    }

    private Classifier getTypeForMultipleTriggers(List<Trigger> triggers) {
        ArrayList<Classifier> listOfClassifier = new ArrayList<Classifier>();
        if (!triggers.isEmpty()) {
            for (Trigger t : triggers) {
                if (!(t.getEvent() instanceof SignalEvent)) continue;
                listOfClassifier.add((Classifier)((SignalEvent)t.getEvent()).getSignal());
            }
            return AcceptEventActionPinUpdater.getFirstCommonSuperClassifier(listOfClassifier);
        }
        return null;
    }
}

