/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.draw2d;

import java.util.List;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Transposer;

public class LeftToolbarLayout
extends AbstractHintLayout {
    protected int spacing;
    protected boolean matchWidth;
    protected boolean horizontal = false;
    protected int minorAlignment;
    public static final int ALIGN_CENTER = 0;
    public static final int ALIGN_TOPLEFT = 1;
    public static final int ALIGN_BOTTOMRIGHT = 2;
    public static final boolean HORIZONTAL = true;
    public static final boolean VERTICAL = false;
    protected Transposer transposer = new Transposer();

    public LeftToolbarLayout() {
        this.transposer.setEnabled(this.horizontal);
        this.spacing = 0;
        this.matchWidth = true;
        this.minorAlignment = 1;
        this.horizontal = false;
    }

    public LeftToolbarLayout(boolean isHorizontal) {
        this.transposer.setEnabled(this.horizontal);
        this.horizontal = isHorizontal;
        this.transposer.setEnabled(this.horizontal);
        this.spacing = 0;
        this.matchWidth = false;
        this.minorAlignment = 1;
    }

    private Dimension calculateChildrenSize(List children, int wHint, int hHint, boolean preferred) {
        int height = 0;
        int width = 0;
        int i = 0;
        while (i < children.size()) {
            IFigure child = (IFigure)children.get(i);
            Dimension childSize = this.transposer.t(preferred ? child.getPreferredSize(wHint, hHint) : child.getMinimumSize(wHint, hHint));
            height += childSize.height;
            width = Math.max(width, childSize.width);
            ++i;
        }
        return new Dimension(width, height);
    }

    protected Dimension calculateMinimumSize(IFigure container, int wHint, int hHint) {
        Insets insets = container.getInsets();
        if (this.isHorizontal()) {
            wHint = -1;
            if (hHint >= 0) {
                hHint = Math.max(0, hHint - insets.getHeight());
            }
        } else {
            hHint = -1;
            if (wHint >= 0) {
                wHint = Math.max(0, wHint - insets.getWidth());
            }
        }
        List children = container.getChildren();
        Dimension minSize = this.calculateChildrenSize(children, wHint, hHint, false);
        if (wHint >= 0 && minSize.width > wHint) {
            minSize = this.calculateChildrenSize(children, minSize.width, hHint, false);
        } else if (hHint >= 0 && minSize.width > hHint) {
            minSize = this.calculateChildrenSize(children, wHint, minSize.width, false);
        }
        minSize.height += Math.max(0, children.size() - 1) * this.spacing;
        return this.transposer.t(minSize).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        Insets insets = container.getInsets();
        if (this.isHorizontal()) {
            wHint = -1;
            if (hHint >= 0) {
                hHint = Math.max(0, hHint - insets.getHeight());
            }
        } else {
            hHint = -1;
            if (wHint >= 0) {
                wHint = Math.max(0, wHint - insets.getWidth());
            }
        }
        List children = container.getChildren();
        Dimension prefSize = this.calculateChildrenSize(children, wHint, hHint, true);
        if (wHint >= 0 && prefSize.width > wHint) {
            prefSize = this.calculateChildrenSize(children, prefSize.width, hHint, true);
        } else if (hHint >= 0 && prefSize.width > hHint) {
            prefSize = this.calculateChildrenSize(children, wHint, prefSize.width, true);
        }
        prefSize.height += Math.max(0, children.size() - 1) * this.spacing;
        return this.transposer.t(prefSize).expand(insets.getWidth(), insets.getHeight()).union(this.getBorderPreferredSize(container));
    }

    public int getMinorAlignment() {
        return this.minorAlignment;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public boolean getStretchMinorAxis() {
        return this.matchWidth;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    protected boolean isSensitiveHorizontally(IFigure parent) {
        return !this.isHorizontal();
    }

    protected boolean isSensitiveVertically(IFigure parent) {
        return this.isHorizontal();
    }

    public void layout(IFigure parent) {
        IFigure child;
        List children = parent.getChildren();
        int numChildren = children.size();
        Rectangle clientArea = this.transposer.t(parent.getClientArea());
        int x = clientArea.x;
        int y = clientArea.y;
        int availableHeight = clientArea.height;
        Dimension[] prefSizes = new Dimension[numChildren];
        Dimension[] minSizes = new Dimension[numChildren];
        int wHint = -1;
        int hHint = -1;
        if (this.isHorizontal()) {
            hHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).height;
        } else {
            wHint = parent.getClientArea((Rectangle)Rectangle.SINGLETON).width;
        }
        int totalHeight = 0;
        int totalMinHeight = 0;
        int prefMinSumHeight = 0;
        int i = 0;
        while (i < numChildren) {
            child = (IFigure)children.get(i);
            prefSizes[i] = this.transposer.t(child.getPreferredSize(wHint, hHint));
            minSizes[i] = this.transposer.t(child.getMinimumSize(wHint, hHint));
            totalHeight += prefSizes[i].height;
            totalMinHeight += minSizes[i].height;
            ++i;
        }
        prefMinSumHeight = (totalHeight += (numChildren - 1) * this.spacing) - (totalMinHeight += (numChildren - 1) * this.spacing);
        int amntShrinkHeight = totalHeight - Math.max(availableHeight, totalMinHeight);
        if (amntShrinkHeight < 0) {
            amntShrinkHeight = 0;
        }
        int i2 = 0;
        while (i2 < numChildren) {
            int amntShrinkCurrentHeight = 0;
            int prefHeight = prefSizes[i2].height;
            int minHeight = minSizes[i2].height;
            int prefWidth = prefSizes[i2].width;
            int minWidth = minSizes[i2].width;
            Rectangle newBounds = new Rectangle(x, y, prefWidth, prefHeight);
            child = (IFigure)children.get(i2);
            if (prefMinSumHeight != 0) {
                amntShrinkCurrentHeight = (prefHeight - minHeight) * amntShrinkHeight / prefMinSumHeight;
            }
            int width = Math.min(prefWidth, this.transposer.t((Dimension)child.getMaximumSize()).width);
            if (this.matchWidth) {
                width = this.transposer.t((Dimension)child.getMaximumSize()).width;
            }
            newBounds.width = width = Math.max(minWidth, Math.min(clientArea.width, width));
            int adjust = clientArea.width - width;
            switch (this.minorAlignment) {
                case 1: {
                    adjust = 0;
                    break;
                }
                case 0: {
                    adjust /= 2;
                    break;
                }
            }
            newBounds.x += adjust;
            newBounds.height -= amntShrinkCurrentHeight;
            child.setBounds(this.transposer.t(newBounds));
            amntShrinkHeight -= amntShrinkCurrentHeight;
            prefMinSumHeight -= prefHeight - minHeight;
            y += newBounds.height + this.spacing;
            ++i2;
        }
    }

    public void setMinorAlignment(int align) {
        this.minorAlignment = align;
    }

    public void setSpacing(int space) {
        this.spacing = space;
    }

    @Deprecated
    public void setMatchWidth(boolean match) {
        this.matchWidth = match;
    }

    public void setStretchMinorAxis(boolean stretch) {
        this.matchWidth = stretch;
    }

    public void setVertical(boolean flag) {
        if (this.horizontal != flag) {
            return;
        }
        this.invalidate();
        this.horizontal = !flag;
        this.transposer.setEnabled(this.horizontal);
    }

    public void setConstraint(IFigure child, Object constraint) {
        this.invalidate(child);
        child.setBorder(null);
    }
}

