/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.locator;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.papyrus.uml.diagram.common.locator.PortPositionLocator;

public class TemplateBorderItemLocator
extends PortPositionLocator {
    public TemplateBorderItemLocator(IFigure parentFigure, int preferredSide) {
        super(parentFigure, preferredSide);
    }

    @Override
    public Rectangle getPreferredLocation(Rectangle proposedLocation) {
        Rectangle realLocation = new Rectangle(proposedLocation);
        Rectangle parentRec = this.getParentFigure().getBounds().getCopy();
        int xMin = parentRec.x - this.borderItemOffset + parentRec.width / 2;
        int xMax = parentRec.x - this.borderItemOffset + parentRec.width;
        int yMin = parentRec.y - this.borderItemOffset;
        int yMax = parentRec.y - this.borderItemOffset + parentRec.height / 2;
        if (realLocation.x < xMin) {
            realLocation.x = xMin;
        }
        if (realLocation.x > xMax) {
            realLocation.x = xMax;
        }
        if (realLocation.y < yMin) {
            realLocation.y = yMin;
        }
        if (realLocation.y > yMax) {
            realLocation.y = yMax;
        }
        if (realLocation.y != yMin && realLocation.y != yMax && realLocation.x != xMin && realLocation.x != xMax) {
            realLocation.x = realLocation.x <= xMin + parentRec.width / 2 ? xMin : xMax;
        }
        if (realLocation.x == xMin && yMin < realLocation.y && realLocation.y <= yMax) {
            realLocation.x = xMax;
        }
        if (xMin <= realLocation.x && realLocation.x < xMax && realLocation.y == yMax) {
            realLocation.y = yMin;
        }
        return realLocation;
    }
}

