/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pmf.emf.ui.popup.actions;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pmf.emf.ui.popup.actions.DataFormContent;
import org.eclipse.pmf.pim.Application;
import org.eclipse.pmf.pim.DataElement;
import org.eclipse.pmf.pim.DataForm;
import org.eclipse.pmf.pim.DataItem;
import org.eclipse.pmf.pim.ElementalDataForm;
import org.eclipse.pmf.pim.data.DataType;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;

public class DataFormListHandler {
    private Map<Object, Control> controls = new HashMap<Object, Control>();
    private ListViewer datatypes;
    private Composite parent;
    private Button insert;
    private Button cancel;
    private Button save;
    private Button up;
    private Button down;
    private Button delete;
    private TreeViewer dataforms;
    private TreeViewer dataformTests;
    private ListViewer datafields;
    private ListViewer content;
    private ElementalDataForm dataContext;
    private Widget widget;
    private Label dataFormListViewerLabel;
    private Map<DataFormContent, DataElement> map;
    private Set<DataElement> addedElement;
    private Set<DataFormContent> insertedList;

    private void init(Widget widget) {
        if (this.datatypes == null) {
            this.datatypes = (ListViewer)XWT.findElementByName((Object)widget, (String)"datatypes");
        }
        if (this.parent == null) {
            this.parent = (Composite)XWT.findElementByName((Object)widget, (String)"dataforms");
        }
        if (this.insert == null) {
            this.insert = (Button)XWT.findElementByName((Object)widget, (String)"Insert");
        }
        if (this.save == null) {
            this.save = (Button)XWT.findElementByName((Object)widget, (String)"Save");
        }
        this.save.setEnabled(false);
        if (this.up == null) {
            this.up = (Button)XWT.findElementByName((Object)widget, (String)"Up");
        }
        if (this.down == null) {
            this.down = (Button)XWT.findElementByName((Object)widget, (String)"Down");
        }
        if (this.delete == null) {
            this.delete = (Button)XWT.findElementByName((Object)widget, (String)"Delete");
        }
        if (this.cancel == null) {
            this.cancel = (Button)XWT.findElementByName((Object)widget, (String)"Cancel");
        }
        if (this.dataforms == null) {
            this.dataforms = (TreeViewer)XWT.findElementByName((Object)widget, (String)"TreeViewerTest");
        }
        if (this.dataformTests == null) {
            this.dataformTests = (TreeViewer)XWT.findElementByName((Object)widget, (String)"TreeViewerTest");
        }
        if (this.dataFormListViewerLabel == null) {
            this.dataFormListViewerLabel = (Label)XWT.findElementByName((Object)widget, (String)"labelDataforms");
        }
        if (this.content == null) {
            this.content = (ListViewer)XWT.findElementByName((Object)widget, (String)"content");
        }
        this.dataContext = (ElementalDataForm)XWT.getDataContext((Object)widget);
        if (widget == null) {
            this.widget = widget;
        }
        this.addedElement = new HashSet<DataElement>();
        this.insertedList = new HashSet<DataFormContent>();
    }

    protected void insert(Event event) {
        Object[] selections;
        if (this.dataforms == null || this.dataforms.getSelection().isEmpty()) {
            MessageDialog.openInformation((Shell)this.widget.getDisplay().getActiveShell(), (String)"Information", (String)"you have to select an available Dataform from the dataform list");
            return;
        }
        Object[] objectArray = selections = ((IStructuredSelection)this.dataforms.getSelection()).toArray();
        int n = selections.length;
        int n2 = 0;
        while (n2 < n) {
            Object selection = objectArray[n2];
            DataFormContent element = (DataFormContent)selection;
            if (!this.insertedList.contains(element)) {
                this.insertedList.add(element);
                DataElement dataElement = this.map.get(element);
                if (dataElement instanceof ElementalDataForm) {
                    ElementalDataForm data = (ElementalDataForm)dataElement;
                    for (DataElement d : data.getChildren()) {
                        DataElement clonedElement = (DataElement)EcoreUtil.copy((EObject)d);
                        clonedElement.setDataContextType(this.dataContext.getDataContextType());
                        this.addedElement.add(clonedElement);
                        this.content.add((Object)clonedElement);
                    }
                } else {
                    DataElement clonedElement = (DataElement)EcoreUtil.copy((EObject)dataElement);
                    clonedElement.setDataContextType(this.dataContext.getDataContextType());
                    this.addedElement.add(clonedElement);
                    this.content.add((Object)clonedElement);
                }
            }
            ++n2;
        }
        if (this.addedElement != null || !this.addedElement.isEmpty()) {
            this.save.setEnabled(true);
        }
    }

    protected void updateDataforms(Event event) {
        this.init(event.widget);
        this.perform();
    }

    protected void selection(Event event) {
    }

    private void dataformSelection(Event event) {
    }

    private void perform() {
        if (this.datatypes.getSelection().isEmpty()) {
            this.dataFormListViewerLabel.setText("Select a data type to view its coresspond dataforms");
            this.save.setEnabled(false);
            return;
        }
        Object selection = ((IStructuredSelection)this.datatypes.getSelection()).getFirstElement();
        DataType dataType = null;
        if (!(selection instanceof DataType)) {
            return;
        }
        dataType = (DataType)selection;
        this.map = new HashMap<DataFormContent, DataElement>();
        this.dataFormListViewerLabel.setText("Dataforms : ");
        Application application = (Application)dataType.eContainer();
        EList listDataForm = application.getDataFormFolder(dataType).getDataForms();
        DataFormContent root = new DataFormContent("root");
        for (DataForm dataForm : listDataForm) {
            DataFormContent child = new DataFormContent(dataForm.getName(), dataForm.getId());
            this.map.put(child, (DataElement)dataForm);
            root.getChildren().add(child);
        }
        Control control = this.controls.get(this.computeKey(selection));
        if (control == null) {
            try {
                this.dataformTests.setInput((Object)root);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void findChildren(DataFormContent child, ElementalDataForm dataForm) {
        for (DataItem item : dataForm.getChildren()) {
            DataFormContent next = new DataFormContent(item.getName(), item.getId());
            this.map.put(next, (DataElement)item);
            child.getChildren().add(next);
        }
    }

    public void treeSelection() {
    }

    private Object computeKey(Object selection) {
        return selection.toString();
    }

    public void cancel(Event event) {
        if (!this.addedElement.isEmpty()) {
            for (DataElement data : this.addedElement) {
                EList l = this.dataContext.getChildren();
                boolean bl = this.dataContext.getChildren().remove((Object)data);
            }
        }
        this.save.setEnabled(true);
    }

    public void up(Event event) {
        if (this.content == null || this.content.getSelection().isEmpty()) {
            MessageDialog.openInformation((Shell)this.widget.getDisplay().getActiveShell(), (String)"Information", (String)"you have to select an element from the content list");
            return;
        }
        int index = this.content.getList().getSelectionIndex();
        Object selection = ((IStructuredSelection)this.content.getSelection()).getFirstElement();
        List list = this.content.getList();
        if (index > 0) {
            this.content.remove(((IStructuredSelection)this.content.getSelection()).getFirstElement());
            this.content.insert(selection, index - 1);
        }
    }

    public void down(Event event) {
        if (this.content == null || this.content.getSelection().isEmpty()) {
            MessageDialog.openInformation((Shell)this.widget.getDisplay().getActiveShell(), (String)"Information", (String)"you have to select an element from the content list");
            return;
        }
        int index = this.content.getList().getSelectionIndex();
        Object selection = ((IStructuredSelection)this.content.getSelection()).getFirstElement();
        if (index < this.content.getList().getItems().length - 1) {
            this.content.remove(((IStructuredSelection)this.content.getSelection()).getFirstElement());
            this.content.insert(selection, index + 1);
        }
    }

    public void delete(Event event) {
        if (this.content == null || this.content.getSelection().isEmpty()) {
            MessageDialog.openInformation((Shell)this.widget.getDisplay().getActiveShell(), (String)"Information", (String)"you have to select an element from the content list");
            return;
        }
        DataElement element = (DataElement)((IStructuredSelection)this.content.getSelection()).getFirstElement();
        DataFormContent dataFromContent = DataFormListHandler.getKeyByValue(this.map, element);
        this.insertedList.remove(dataFromContent);
        this.content.remove(((IStructuredSelection)this.content.getSelection()).getFirstElement());
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!value.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public void save(Event event) {
        Resource resource = this.dataContext.eResource();
        ResourceSet resourceSet = resource.getResourceSet();
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(resourceSet);
        TransactionalCommandStack tstack = (TransactionalCommandStack)domain.getCommandStack();
        domain.getCommandStack().execute((Command)new RecordingCommand(domain){

            protected void doExecute() {
                int i = 0;
                while (i <= DataFormListHandler.this.content.getList().getItems().length - 1) {
                    Object insertion = DataFormListHandler.this.content.getElementAt(i);
                    DataItem dataItem = (DataItem)insertion;
                    if (!DataFormListHandler.this.dataContext.getChildren().contains((Object)dataItem)) {
                        DataFormListHandler.this.dataContext.getChildren().add((Object)dataItem);
                    }
                    ++i;
                }
            }
        });
        int i = 0;
        while (i <= this.content.getList().getItems().length - 1) {
            Object insertion = this.content.getElementAt(i);
            DataItem dataItem = (DataItem)insertion;
            if (!this.dataContext.getChildren().contains((Object)dataItem)) {
                this.dataContext.getChildren().add((Object)dataItem);
            }
            ++i;
        }
        this.save.setEnabled(false);
        this.cancel.setEnabled(true);
    }
}

