/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.gem.views;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ptp.internal.gem.GemPlugin;
import org.eclipse.ptp.internal.gem.messages.Messages;
import org.eclipse.ptp.internal.gem.util.Envelope;
import org.eclipse.ptp.internal.gem.util.GemUtilities;
import org.eclipse.ptp.internal.gem.util.InternalIssueOrderSorter;
import org.eclipse.ptp.internal.gem.util.ListElement;
import org.eclipse.ptp.internal.gem.util.ProgramOrderSorter;
import org.eclipse.ptp.internal.gem.util.Transitions;
import org.eclipse.ptp.internal.gem.views.GemBrowser;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.ViewPart;

public class GemAnalyzer
extends ViewPart {
    public static final String ID = "org.eclipse.ptp.gem.views.GemAnalyzer";
    private Transitions transitions;
    private LinkedList<Shell> activeShells;
    private Composite parent;
    private ListViewer leftViewer;
    private ListViewer rightViewer;
    private Action getHelp;
    private Action terminateButton;
    private int numRanks;
    private int lockedRank = -1;
    private IFile currLeftFile;
    private IFile currRightFile;
    private Button firstTransitionButton;
    private Button previousTransitionButton;
    private Button nextTransitionButton;
    private Button lastTransitionButton;
    private Button firstInterleavingButton;
    private Button previousInterleavingButton;
    private Button nextInterleavingButton;
    private Button lastInterleavingButton;
    private Button deadlockInterleavingButton;
    private Button internalIssueOrderButton;
    private Button programOrderButton;
    private Button launchHpvButton;
    private Button browseCallsButton;
    private Button runGemButton;
    private Combo lockRanksComboList;
    private Combo setNumProcsComboList;
    private Group interleavingsGroup;
    private Group transitionsGroup;
    private Group stepOrderGroup;
    private Label errorMessageLabel;
    private Label leftCodeWindowLabel;
    private Label rightCodeWindowLabel;
    private CLabel leftCodeWindowExplenationLabel;
    private CLabel rightCodeWindowExplenationLabel;
    private int transitionLabelIndex;
    private int transitionLabelCount;
    private int leftIndex;
    private int rightIndex;
    private int previousLeftIndex;
    private SelectionListener singleListener;
    private DoubleClickListener doubleListener;
    private IFile activeFile;
    private Thread analyzerUpdateThread;
    private Thread clearAnalyzerThread;
    private Thread disableTerminateButtonThread;
    private int leftLines;
    private int rightLines;
    private boolean aborted = false;

    public void activate() {
        Thread activationThread = new Thread(){

            public void run() {
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    page.activate((IWorkbenchPart)GemAnalyzer.this);
                }
            }
        };
        Display.getDefault().syncExec((Runnable)activationThread);
    }

    public void clear() {
        Display.getDefault().syncExec((Runnable)this.clearAnalyzerThread);
        this.aborted = false;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void createCodeWindowsGroup(Composite parent) {
        Image sourceCallImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/source-call.gif"));
        Image matchCallImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/match-call.gif"));
        Group codeWindowsGroup = new Group(parent, 4);
        codeWindowsGroup.setText(Messages.GemAnalyzer_0);
        GridLayout codeWindowsLayout = new GridLayout();
        codeWindowsLayout.numColumns = 2;
        codeWindowsLayout.marginHeight = 10;
        codeWindowsLayout.marginWidth = 10;
        codeWindowsLayout.horizontalSpacing = 15;
        codeWindowsGroup.setLayout((Layout)codeWindowsLayout);
        codeWindowsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        String newline = System.getProperty("line.separator");
        this.leftCodeWindowLabel = new Label((Composite)codeWindowsGroup, 64);
        this.leftCodeWindowLabel.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Font leftCodeWindowLabelFont = this.setFontSize(this.leftCodeWindowLabel.getFont(), 9);
        this.leftCodeWindowLabel.setFont(leftCodeWindowLabelFont);
        this.leftCodeWindowLabel.setText(newline);
        this.rightCodeWindowLabel = new Label((Composite)codeWindowsGroup, 64);
        this.rightCodeWindowLabel.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        Font rightCodeWindowLabelFont = this.setFontSize(this.rightCodeWindowLabel.getFont(), 9);
        this.rightCodeWindowLabel.setFont(rightCodeWindowLabelFont);
        this.rightCodeWindowLabel.setText(newline);
        this.leftCodeWindowExplenationLabel = new CLabel((Composite)codeWindowsGroup, 64);
        this.rightCodeWindowExplenationLabel = new CLabel((Composite)codeWindowsGroup, 64);
        this.leftCodeWindowExplenationLabel.setImage(sourceCallImage);
        this.rightCodeWindowExplenationLabel.setImage(matchCallImage);
        this.leftCodeWindowExplenationLabel.setText(Messages.GemAnalyzer_1);
        this.rightCodeWindowExplenationLabel.setText(Messages.GemAnalyzer_2);
        this.leftViewer = new ListViewer((Composite)codeWindowsGroup, 2818);
        this.rightViewer = new ListViewer((Composite)codeWindowsGroup, 2818);
        Font leftViewerFont = this.setFontSize(this.leftViewer.getControl().getFont(), 8);
        Font rightViewerFont = this.setFontSize(this.rightViewer.getControl().getFont(), 8);
        this.leftViewer.getControl().setFont(leftViewerFont);
        this.rightViewer.getControl().setFont(rightViewerFont);
        this.leftViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.rightViewer.getList().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.singleListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                org.eclipse.swt.widgets.List list = (org.eclipse.swt.widgets.List)e.getSource();
                String entry = list.getItem(0).toString();
                if (!entry.contains(Messages.GemAnalyzer_3) || !entry.contains(Messages.GemAnalyzer_4)) {
                    GemAnalyzer.this.updateSelectedLine(false);
                }
            }
        };
        this.doubleListener = new DoubleClickListener();
        this.leftViewer.getList().addSelectionListener(this.singleListener);
        this.rightViewer.getList().addSelectionListener(this.singleListener);
        this.leftViewer.addDoubleClickListener((IDoubleClickListener)this.doubleListener);
        this.rightViewer.addDoubleClickListener((IDoubleClickListener)this.doubleListener);
    }

    private void createInterleavingsGroup(Composite parent) {
        Image firstItemImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/first-item.gif"));
        Image lastItemImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/last-item.gif"));
        Image prevItemImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/prev-item.gif"));
        Image nextItemImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/next-item.gif"));
        Image deadlockImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/deadlock.gif"));
        this.interleavingsGroup = new Group(parent, 4);
        this.interleavingsGroup.setText(Messages.GemAnalyzer_5);
        this.interleavingsGroup.setToolTipText(Messages.GemAnalyzer_6);
        FormData interleavingsFormData = new FormData();
        interleavingsFormData.bottom = new FormAttachment(100, -5);
        interleavingsFormData.left = new FormAttachment(44, 0);
        this.interleavingsGroup.setLayoutData((Object)interleavingsFormData);
        this.interleavingsGroup.setLayout((Layout)new FormLayout());
        this.firstInterleavingButton = new Button((Composite)this.interleavingsGroup, 8);
        this.firstInterleavingButton.setImage(firstItemImage);
        this.firstInterleavingButton.setToolTipText(Messages.GemAnalyzer_7);
        this.firstInterleavingButton.setEnabled(false);
        FormData ifirstFormData = new FormData();
        ifirstFormData.left = new FormAttachment(0, 5);
        ifirstFormData.bottom = new FormAttachment(100, -5);
        this.firstInterleavingButton.setLayoutData((Object)ifirstFormData);
        this.previousInterleavingButton = new Button((Composite)this.interleavingsGroup, 8);
        this.previousInterleavingButton.setImage(prevItemImage);
        this.previousInterleavingButton.setToolTipText(Messages.GemAnalyzer_8);
        this.previousInterleavingButton.setEnabled(false);
        FormData iprevFormData = new FormData();
        iprevFormData.left = new FormAttachment((Control)this.firstInterleavingButton, 3);
        iprevFormData.bottom = new FormAttachment(100, -5);
        this.previousInterleavingButton.setLayoutData((Object)iprevFormData);
        this.nextInterleavingButton = new Button((Composite)this.interleavingsGroup, 8);
        this.nextInterleavingButton.setImage(nextItemImage);
        this.nextInterleavingButton.setToolTipText(Messages.GemAnalyzer_9);
        this.nextInterleavingButton.setEnabled(false);
        FormData inextFormData = new FormData();
        inextFormData.left = new FormAttachment((Control)this.previousInterleavingButton, 3);
        inextFormData.bottom = new FormAttachment(100, -5);
        this.nextInterleavingButton.setLayoutData((Object)inextFormData);
        this.lastInterleavingButton = new Button((Composite)this.interleavingsGroup, 8);
        this.lastInterleavingButton.setImage(lastItemImage);
        this.lastInterleavingButton.setToolTipText(Messages.GemAnalyzer_10);
        this.lastInterleavingButton.setEnabled(false);
        FormData ilastFormData = new FormData();
        ilastFormData.left = new FormAttachment((Control)this.nextInterleavingButton, 3);
        ilastFormData.bottom = new FormAttachment(100, -5);
        this.lastInterleavingButton.setLayoutData((Object)ilastFormData);
        this.deadlockInterleavingButton = new Button((Composite)this.interleavingsGroup, 8);
        this.deadlockInterleavingButton.setImage(deadlockImage);
        this.deadlockInterleavingButton.setToolTipText(Messages.GemAnalyzer_11);
        this.deadlockInterleavingButton.setEnabled(false);
        FormData deadlockButtonFormData = new FormData();
        deadlockButtonFormData.left = new FormAttachment((Control)this.lastInterleavingButton, 3);
        deadlockButtonFormData.bottom = new FormAttachment(100, -5);
        deadlockButtonFormData.right = new FormAttachment(100, -5);
        this.deadlockInterleavingButton.setLayoutData((Object)deadlockButtonFormData);
    }

    public void createPartControl(Composite parent) {
        this.parent = parent;
        GridLayout parentLayout = new GridLayout();
        parentLayout.numColumns = 1;
        parentLayout.marginHeight = 10;
        parentLayout.marginWidth = 10;
        parent.setLayout((Layout)parentLayout);
        Composite runtimeComposite = new Composite(parent, 0);
        runtimeComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        runtimeComposite.setLayout((Layout)new FormLayout());
        Composite buttonGroupsComposite = new Composite(parent, 0);
        buttonGroupsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        buttonGroupsComposite.setLayout((Layout)new FormLayout());
        this.createRuntimeGroup(runtimeComposite);
        this.createTransitionsGroup(buttonGroupsComposite);
        this.createInterleavingsGroup(buttonGroupsComposite);
        this.createStepOrderGroup(buttonGroupsComposite);
        this.createCodeWindowsGroup(parent);
        this.createSelectionListeners();
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
    }

    private void createRuntimeGroup(Composite parent) {
        Image noErrorImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/no-error.gif"));
        Image hbvImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/hbv-trident.gif"));
        Image trident = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/trident.gif"));
        Group runtimeInfoGroup = new Group(parent, 4);
        runtimeInfoGroup.setText(Messages.GemAnalyzer_12);
        FormData grid = new FormData();
        grid.left = new FormAttachment(0, 0);
        grid.right = new FormAttachment(100, -5);
        grid.bottom = new FormAttachment(100, -5);
        runtimeInfoGroup.setLayoutData((Object)grid);
        runtimeInfoGroup.setLayout((Layout)new FormLayout());
        this.errorMessageLabel = new Label((Composite)runtimeInfoGroup, 0);
        FormData deadlockMessageFormData = new FormData();
        deadlockMessageFormData.left = new FormAttachment(0, 5);
        deadlockMessageFormData.top = new FormAttachment(0, 5);
        deadlockMessageFormData.width = 300;
        this.errorMessageLabel.setLayoutData((Object)deadlockMessageFormData);
        Font errorMessageLabelFont = this.setFontSize(this.errorMessageLabel.getFont(), 10);
        this.errorMessageLabel.setFont(errorMessageLabelFont);
        this.browseCallsButton = new Button((Composite)runtimeInfoGroup, 8);
        this.browseCallsButton.setImage(noErrorImage);
        this.browseCallsButton.setText(Messages.GemAnalyzer_79);
        this.browseCallsButton.setToolTipText(Messages.GemAnalyzer_14);
        this.browseCallsButton.setEnabled(false);
        FormData browseCallsFormData = new FormData();
        browseCallsFormData.right = new FormAttachment(100, -5);
        browseCallsFormData.bottom = new FormAttachment(100, -5);
        this.browseCallsButton.setLayoutData((Object)browseCallsFormData);
        this.launchHpvButton = new Button((Composite)runtimeInfoGroup, 8);
        this.launchHpvButton.setImage(hbvImage);
        this.launchHpvButton.setText(Messages.GemAnalyzer_15);
        this.launchHpvButton.setToolTipText(Messages.GemAnalyzer_16);
        this.launchHpvButton.setEnabled(false);
        FormData launchIspUIFormData = new FormData();
        launchIspUIFormData.right = new FormAttachment((Control)this.browseCallsButton, -5);
        launchIspUIFormData.bottom = new FormAttachment(100, -5);
        this.launchHpvButton.setLayoutData((Object)launchIspUIFormData);
        this.runGemButton = new Button((Composite)runtimeInfoGroup, 8);
        this.runGemButton.setImage(trident);
        this.runGemButton.setToolTipText(Messages.GemAnalyzer_17);
        FormData runGemFormData = new FormData();
        runGemFormData.right = new FormAttachment((Control)this.launchHpvButton, -20);
        runGemFormData.bottom = new FormAttachment(100, -5);
        this.runGemButton.setLayoutData((Object)runGemFormData);
        this.runGemButton.setEnabled(true);
        this.setNumProcsComboList = new Combo((Composite)runtimeInfoGroup, 4);
        Font setRankComboFont = this.setFontSize(this.setNumProcsComboList.getFont(), 9);
        this.setNumProcsComboList.setFont(setRankComboFont);
        String[] items = new String[]{};
        this.setNumProcsComboList.setItems(items);
        this.setNumProcsComboList.setText(" ");
        this.setNumProcsComboList.setToolTipText(Messages.GemAnalyzer_18);
        FormData setRankFormData = new FormData();
        setRankFormData.width = 50;
        setRankFormData.right = new FormAttachment((Control)this.runGemButton, -5);
        setRankFormData.bottom = new FormAttachment(100, -5);
        this.setNumProcsComboList.setLayoutData((Object)setRankFormData);
        this.setNumProcsComboList.setEnabled(true);
        this.setNumProcItems();
        this.updateDropDown();
        Font buttonFont = this.setFontSize(this.errorMessageLabel.getFont(), 8);
        this.launchHpvButton.setFont(buttonFont);
        this.browseCallsButton.setFont(buttonFont);
        this.setNumProcsComboList.setFont(buttonFont);
    }

    private void createSelectionListeners() {
        this.firstTransitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GemAnalyzer.this.updateFirstTransition(true);
            }
        });
        this.previousTransitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GemAnalyzer.this.updatePreviousTransition();
            }
        });
        this.nextTransitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GemAnalyzer.this.updateNextTransition(true);
            }
        });
        this.lastTransitionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GemAnalyzer.this.updateLastTransition();
            }
        });
        this.lockRanksComboList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (GemAnalyzer.this.lockRanksComboList.getText() == null) {
                    return;
                }
                try {
                    int selectionIndex = GemAnalyzer.this.lockRanksComboList.getSelectionIndex();
                    String selectionText = GemAnalyzer.this.lockRanksComboList.getItems()[selectionIndex];
                    Pattern rankPattern = Pattern.compile("^([a-zA-Z]+?)\\s+([0-9]+?)\\s+([a-zA-Z]+?)$");
                    Matcher rankPatternMatcher = rankPattern.matcher(selectionText);
                    if (rankPatternMatcher.matches()) {
                        String rankStr = rankPatternMatcher.group(2);
                        GemAnalyzer.this.lockedRank = Integer.parseInt(rankStr);
                    } else {
                        GemAnalyzer.this.lockedRank = -1;
                    }
                    GemAnalyzer.this.updateTransitionLabels(true);
                }
                catch (Exception e) {
                    GemUtilities.logExceptionDetail(e);
                    GemAnalyzer.this.lockedRank = -1;
                }
            }
        });
        this.firstInterleavingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GemAnalyzer.this.transitions.hasPreviousInterleaving()) {
                    while (GemAnalyzer.this.transitions.setPreviousInterleaving()) {
                    }
                    GemAnalyzer.this.updateTransitionLabels(true);
                } else {
                    GemUtilities.showInformationDialog(Messages.GemAnalyzer_19);
                }
            }
        });
        this.previousInterleavingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GemAnalyzer.this.transitions.hasPreviousInterleaving()) {
                    GemAnalyzer.this.transitions.setPreviousInterleaving();
                    GemAnalyzer.this.updateTransitionLabels(true);
                } else {
                    GemUtilities.showInformationDialog(Messages.GemAnalyzer_20);
                }
            }
        });
        this.nextInterleavingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GemAnalyzer.this.transitions.hasNextInterleaving()) {
                    GemAnalyzer.this.transitions.setNextInterleaving();
                    GemAnalyzer.this.updateTransitionLabels(true);
                } else {
                    GemUtilities.showInformationDialog(Messages.GemAnalyzer_21);
                }
            }
        });
        this.lastInterleavingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                while (GemAnalyzer.this.transitions.hasNextInterleaving()) {
                    GemAnalyzer.this.transitions.setNextInterleaving();
                }
                GemAnalyzer.this.updateTransitionLabels(true);
            }
        });
        this.deadlockInterleavingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GemAnalyzer.this.transitions.deadlockInterleaving();
                GemAnalyzer.this.updateTransitionLabels(true);
            }
        });
        this.internalIssueOrderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GemAnalyzer.this.internalIssueOrderButton.getSelection()) {
                    if (GemAnalyzer.this.transitions != null) {
                        ArrayList<ArrayList<Envelope>> tlists = GemAnalyzer.this.transitions.getTransitionList();
                        int size = tlists.size();
                        int i = 0;
                        while (i < size) {
                            Collections.sort((List)tlists.get(i), new InternalIssueOrderSorter());
                            ++i;
                        }
                    }
                    GemPlugin.getDefault().getPreferenceStore().setValue("stepOrderPreference", "issueOrder");
                    GemAnalyzer.this.reset();
                }
            }
        });
        this.programOrderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GemAnalyzer.this.programOrderButton.getSelection()) {
                    if (GemAnalyzer.this.transitions != null) {
                        ArrayList<ArrayList<Envelope>> tlists = GemAnalyzer.this.transitions.getTransitionList();
                        int size = tlists.size();
                        int i = 0;
                        while (i < size) {
                            Collections.sort((List)tlists.get(i), new ProgramOrderSorter());
                            ++i;
                        }
                    }
                    GemPlugin.getDefault().getPreferenceStore().setValue("stepOrderPreference", "programOrder");
                    GemAnalyzer.this.reset();
                }
            }
        });
        this.runGemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IPreferenceStore pstore = GemPlugin.getDefault().getPreferenceStore();
                URI inputLocation = null;
                Path path = null;
                try {
                    inputLocation = new URI(pstore.getString("mostRecentFile"));
                }
                catch (URISyntaxException e) {
                    GemUtilities.logExceptionDetail(e);
                }
                if (inputLocation != null) {
                    path = new Path(inputLocation.getPath());
                }
                if (GemAnalyzer.this.activeFile == null) {
                    GemUtilities.setTaskStatus(GemUtilities.TaskStatus.ABORTED);
                    return;
                }
                IFile file = GemUtilities.getCurrentProject((IResource)GemAnalyzer.this.activeFile).getFile(path.lastSegment());
                path = file.getFullPath();
                String extension = file.getFileExtension();
                boolean isSourceFile = false;
                if (extension != null) {
                    isSourceFile = extension.equals("c") || extension.equals("cpp") || extension.equals("c++") || extension.equals("cc") || extension.equals("cp");
                }
                GemUtilities.setCommandLineArgs();
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow window = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                try {
                    String activeView = pstore.getString("activeViewPreference");
                    if (activeView.equals("analyzer")) {
                        page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                        page.showView(GemAnalyzer.ID);
                    } else {
                        page.showView(GemAnalyzer.ID);
                        page.showView("org.eclipse.ptp.gem.views.GemBrowser");
                    }
                    GemUtilities.initGemViews((IResource)file, isSourceFile, true);
                }
                catch (PartInitException e) {
                    GemUtilities.logExceptionDetail((Exception)((Object)e));
                }
            }
        });
        this.setNumProcsComboList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (GemAnalyzer.this.setNumProcsComboList.getText() == null) {
                    return;
                }
                int selectionIndex = GemAnalyzer.this.setNumProcsComboList.getSelectionIndex();
                String nprocsStr = GemAnalyzer.this.setNumProcsComboList.getItems()[selectionIndex];
                int newNumProcs = Integer.parseInt(nprocsStr);
                GemPlugin.getDefault().getPreferenceStore().setValue("numprocsPreference", newNumProcs);
                try {
                    IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    IViewPart browserPart = window.getActivePage().findView("org.eclipse.ptp.gem.views.GemBrowser");
                    GemBrowser browser = (GemBrowser)browserPart;
                    browser.updateDropDown();
                }
                catch (Exception e) {
                    GemUtilities.logExceptionDetail(e);
                }
            }
        });
        this.launchHpvButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                URI uri = GemUtilities.getMostRecentURI();
                Path sourceFilePath = null;
                IFile sourceFile = null;
                if (uri != null) {
                    sourceFilePath = new Path(uri.getPath());
                }
                IProject currentProject = GemUtilities.getProjectLogFile().getProject();
                String currentProjectPath = currentProject.getLocationURI().getPath();
                if (sourceFilePath != null) {
                    sourceFilePath = sourceFilePath.makeRelativeTo((IPath)new Path(currentProjectPath));
                    sourceFile = currentProject.getFile((IPath)sourceFilePath);
                }
                if (sourceFile != null) {
                    if (GemUtilities.isRemoteProject((IResource)GemAnalyzer.this.activeFile) || GemUtilities.isSynchronizedProject((IResource)GemAnalyzer.this.activeFile)) {
                        GemUtilities.showInformationDialog(Messages.GemAnalyzer_23);
                        return;
                    }
                    GemUtilities.doHbv(sourceFile);
                } else {
                    String string = Messages.GemAnalyzer_13;
                }
            }
        });
        this.browseCallsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GemAnalyzer.this.transitions == null) {
                    String message = Messages.GemAnalyzer_24;
                    GemUtilities.showErrorDialog(message);
                    return;
                }
                final class CallBrowserDisplay
                implements Runnable {
                    CallBrowserDisplay() {
                    }

                    public void run() {
                        IWorkbench wb = PlatformUI.getWorkbench();
                        Display display = wb.getDisplay();
                        Shell shell = new Shell();
                        shell.setText(Messages.GemAnalyzer_68);
                        shell.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/magnified-trident.gif")));
                        shell.setLayout((Layout)new GridLayout());
                        CLabel fileNameLabel = new CLabel((Composite)shell, 1);
                        fileNameLabel.setLayoutData((Object)new GridData(768));
                        CLabel numProcsLabel = new CLabel((Composite)shell, 1);
                        numProcsLabel.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/processes.gif")));
                        numProcsLabel.setText(String.valueOf(Messages.GemAnalyzer_69) + GemAnalyzer.this.numRanks);
                        numProcsLabel.setLayoutData((Object)new GridData(768));
                        Tree tree = new Tree((Composite)shell, 2048);
                        tree.setLinesVisible(true);
                        tree.setLayoutData((Object)new GridData(1808));
                        tree.setFont(GemAnalyzer.this.setFontSize(tree.getFont(), 8));
                        TreeItem interleavingItem = null;
                        TreeItem callItem = null;
                        int currentInter = GemAnalyzer.this.transitions.getCurrentInterleaving();
                        int numInterleavings = GemAnalyzer.this.transitions.getTotalInterleavings() + 1;
                        int currentInterleaving = 1;
                        while (currentInterleaving < numInterleavings) {
                            interleavingItem = new TreeItem(tree, 0);
                            interleavingItem.setText(String.valueOf(Messages.GemAnalyzer_70) + currentInterleaving);
                            ArrayList<Envelope> envelopes = GemAnalyzer.this.transitions.getInterleavingEnvelopes(currentInterleaving);
                            int listSize = envelopes.size();
                            Envelope env = null;
                            String functionName = null;
                            String fileName = null;
                            int lineNumber = -1;
                            int envRank = -1;
                            try {
                                int envIndex = 0;
                                while (envIndex < listSize) {
                                    env = envelopes.get(envIndex);
                                    if (!env.isLeak()) {
                                        callItem = new TreeItem(interleavingItem, 0);
                                        functionName = env.getFunctionName();
                                        fileName = new Path(env.getFilePath()).lastSegment().toString();
                                        lineNumber = env.getLinenumber();
                                        envRank = env.getRank();
                                        while (functionName.length() < 12) {
                                            functionName = String.valueOf(functionName) + " ";
                                        }
                                        StringBuffer stringBuffer = new StringBuffer();
                                        stringBuffer.append("Rank: ");
                                        stringBuffer.append(envRank);
                                        stringBuffer.append("\t\t");
                                        stringBuffer.append(functionName);
                                        stringBuffer.append("\t\t");
                                        stringBuffer.append(fileName);
                                        stringBuffer.append(":");
                                        stringBuffer.append(lineNumber);
                                        String callItemText = stringBuffer.toString();
                                        callItem.setText(callItemText);
                                        if (env.getIssueIndex() == -1) {
                                            callItem.setForeground(new Color(null, 255, 0, 0));
                                        }
                                        String currentFile = null;
                                        int currentLine = -1;
                                        if (GemAnalyzer.this.transitions.getCurrentTransition() != null) {
                                            currentFile = GemAnalyzer.this.transitions.getCurrentTransition().getFilePath();
                                            currentLine = GemAnalyzer.this.transitions.getCurrentTransition().getLinenumber();
                                        }
                                        if (currentFile != null && currentLine == env.getLinenumber() && currentFile.equals(env.getFilePath()) && currentInter == env.getInterleaving()) {
                                            callItem.setForeground(new Color(null, 0, 0, 255));
                                            GemAnalyzer.this.revealTreeItem(callItem);
                                        }
                                    }
                                    ++envIndex;
                                }
                            }
                            catch (Exception e) {
                                GemUtilities.logExceptionDetail(e);
                            }
                            ++currentInterleaving;
                        }
                        shell.setSize(550, 550);
                        shell.open();
                        if (GemAnalyzer.this.activeShells == null) {
                            GemAnalyzer.this.activeShells = new LinkedList();
                        }
                        GemAnalyzer.this.activeShells.add(shell);
                        while (!shell.isDisposed()) {
                            if (display.readAndDispatch()) continue;
                            display.sleep();
                        }
                    }
                }
                CallBrowserDisplay browser = new CallBrowserDisplay();
                Display.getDefault().syncExec((Runnable)browser);
            }
        });
    }

    private void createStepOrderGroup(Composite parent) {
        this.stepOrderGroup = new Group(parent, 4);
        this.stepOrderGroup.setText(Messages.GemAnalyzer_25);
        this.stepOrderGroup.setToolTipText(Messages.GemAnalyzer_26);
        FormData stepOrderFormData = new FormData();
        stepOrderFormData.right = new FormAttachment(100, -5);
        stepOrderFormData.bottom = new FormAttachment(100, -5);
        this.stepOrderGroup.setLayoutData((Object)stepOrderFormData);
        this.stepOrderGroup.setLayout((Layout)new GridLayout(3, false));
        this.internalIssueOrderButton = new Button((Composite)this.stepOrderGroup, 16);
        this.internalIssueOrderButton.setText(Messages.GemAnalyzer_27);
        this.internalIssueOrderButton.setToolTipText(Messages.GemAnalyzer_28);
        this.programOrderButton = new Button((Composite)this.stepOrderGroup, 16);
        this.programOrderButton.setText(Messages.GemAnalyzer_29);
        this.programOrderButton.setToolTipText(Messages.GemAnalyzer_30);
        String stepOrder = GemPlugin.getDefault().getPreferenceStore().getString("stepOrderPreference");
        if (stepOrder.equals("issueOrder")) {
            this.internalIssueOrderButton.setSelection(true);
        } else {
            this.programOrderButton.setSelection(true);
        }
        Font buttonFont = this.setFontSize(this.programOrderButton.getFont(), 8);
        this.internalIssueOrderButton.setFont(buttonFont);
        this.programOrderButton.setFont(buttonFont);
    }

    private void createTransitionsGroup(Composite parent) {
        Image firstItemImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/first-item.gif"));
        Image lastItemImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/last-item.gif"));
        Image prevItemImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/prev-item.gif"));
        Image nextItemImage = GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/next-item.gif"));
        this.transitionsGroup = new Group(parent, 4);
        this.transitionsGroup.setText(Messages.GemAnalyzer_32);
        this.transitionsGroup.setToolTipText(Messages.GemAnalyzer_33);
        FormData transitionsFormData = new FormData();
        transitionsFormData.left = new FormAttachment(0, 0);
        transitionsFormData.bottom = new FormAttachment(100, -5);
        this.transitionsGroup.setLayoutData((Object)transitionsFormData);
        this.transitionsGroup.setLayout((Layout)new FormLayout());
        this.firstTransitionButton = new Button((Composite)this.transitionsGroup, 8);
        this.firstTransitionButton.setImage(firstItemImage);
        this.firstTransitionButton.setToolTipText(Messages.GemAnalyzer_34);
        this.firstTransitionButton.setEnabled(false);
        FormData tfirstFormData = new FormData();
        tfirstFormData.left = new FormAttachment(0, 5);
        tfirstFormData.bottom = new FormAttachment(100, -5);
        this.firstTransitionButton.setLayoutData((Object)tfirstFormData);
        this.previousTransitionButton = new Button((Composite)this.transitionsGroup, 8);
        this.previousTransitionButton.setImage(prevItemImage);
        this.previousTransitionButton.setToolTipText(Messages.GemAnalyzer_35);
        this.previousTransitionButton.setEnabled(false);
        FormData tprevFormData = new FormData();
        tprevFormData.left = new FormAttachment((Control)this.firstTransitionButton, 3);
        tprevFormData.bottom = new FormAttachment(100, -5);
        this.previousTransitionButton.setLayoutData((Object)tprevFormData);
        this.nextTransitionButton = new Button((Composite)this.transitionsGroup, 8);
        this.nextTransitionButton.setImage(nextItemImage);
        this.nextTransitionButton.setToolTipText(Messages.GemAnalyzer_36);
        this.nextTransitionButton.setEnabled(false);
        FormData tnextFormData = new FormData();
        tnextFormData.left = new FormAttachment((Control)this.previousTransitionButton, 3);
        tnextFormData.bottom = new FormAttachment(100, -5);
        this.nextTransitionButton.setLayoutData((Object)tnextFormData);
        this.lastTransitionButton = new Button((Composite)this.transitionsGroup, 8);
        this.lastTransitionButton.setImage(lastItemImage);
        this.lastTransitionButton.setToolTipText(Messages.GemAnalyzer_37);
        this.lastTransitionButton.setEnabled(false);
        FormData tlastFormData = new FormData();
        tlastFormData.left = new FormAttachment((Control)this.nextTransitionButton, 3);
        tlastFormData.bottom = new FormAttachment(100, -5);
        this.lastTransitionButton.setLayoutData((Object)tlastFormData);
        this.lockRanksComboList = new Combo((Composite)this.transitionsGroup, 12);
        Font lockRanksComboFont = this.setFontSize(this.lockRanksComboList.getFont(), 8);
        this.lockRanksComboList.setFont(lockRanksComboFont);
        String[] items = new String[]{Messages.GemAnalyzer_83};
        this.lockRanksComboList.setItems(items);
        this.lockRanksComboList.setToolTipText(Messages.GemAnalyzer_39);
        FormData lockRanksFormData = new FormData();
        lockRanksFormData.left = new FormAttachment((Control)this.lastTransitionButton, 10);
        lockRanksFormData.right = new FormAttachment(100, -5);
        lockRanksFormData.bottom = new FormAttachment(100, -5);
        this.lockRanksComboList.setLayoutData((Object)lockRanksFormData);
    }

    private void displayCollectiveInfo() {
        Envelope env = this.transitions.getCurrentTransition();
        ArrayList<Envelope> matches = env.getCommunicator_matches();
        if (matches != null) {
            int listSize = matches.size();
            int i = 0;
            while (i < listSize) {
                Envelope currentMatchEnvelope = matches.get(i);
                String matchFilePathString = currentMatchEnvelope.getFilePath();
                IFile sourceFile = GemUtilities.getSourceFile(matchFilePathString, (IResource)this.activeFile);
                this.rightViewer.add((Object)new ListElement(sourceFile, String.valueOf(sourceFile.getName()) + Messages.GemAnalyzer_40 + currentMatchEnvelope.getLinenumber() + Messages.GemAnalyzer_41 + currentMatchEnvelope.getRank(), currentMatchEnvelope.getLinenumber(), false));
                ++i;
            }
        }
    }

    private void displayEnvelopes(Envelope env) {
        if (env == null) {
            return;
        }
        this.leftIndex = env.getLinenumber();
        boolean hasMatch = true;
        try {
            Envelope match = env.getMatch_envelope();
            if (match != null) {
                this.rightIndex = match.getLinenumber();
            } else {
                hasMatch = false;
            }
        }
        catch (Exception e) {
            GemUtilities.logExceptionDetail(e);
        }
        Color textColor = new Color((Device)this.parent.getShell().getDisplay(), new RGB(0, 0, 255));
        this.leftCodeWindowLabel.setForeground(textColor);
        this.rightCodeWindowLabel.setForeground(textColor);
        String leftResult = this.getCallText(env, true);
        this.leftCodeWindowLabel.setText(leftResult);
        if (hasMatch) {
            Envelope match = env.getMatch_envelope();
            String rightResult = this.getCallText(match, false);
            this.rightCodeWindowLabel.setText(rightResult);
        } else {
            this.rightIndex = -1;
            this.rightViewer.getList().deselectAll();
            this.rightCodeWindowLabel.setText("");
        }
        if (env.getIssueIndex() == -1) {
            textColor = new Color((Device)this.parent.getShell().getDisplay(), new RGB(255, 0, 0));
            this.rightCodeWindowLabel.setForeground(textColor);
            if (env.getFunctionName().equals("MPI_Abort")) {
                this.rightCodeWindowLabel.setText("");
            } else if (this.transitions.hasDeadlock()) {
                this.rightCodeWindowLabel.setText(Messages.GemAnalyzer_46);
            } else {
                this.rightCodeWindowLabel.setText(Messages.GemAnalyzer_47);
            }
        }
    }

    public void dispose() {
        if (this.activeShells != null) {
            for (Shell s : this.activeShells) {
                if (s == null) continue;
                s.dispose();
            }
        }
        super.dispose();
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.terminateButton);
        this.terminateButton.setText(Messages.GemAnalyzer_48);
        manager.add((IAction)this.getHelp);
        this.getHelp.setText(Messages.GemAnalyzer_49);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.terminateButton);
        this.terminateButton.setText(Messages.GemAnalyzer_50);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.getHelp);
        this.getHelp.setText(Messages.GemAnalyzer_51);
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.terminateButton);
        manager.add((IAction)this.getHelp);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private String getCallText(Envelope env, boolean isLeft) {
        String newline = System.getProperty("line.separator");
        String sourceFilePathString = env.getFilePath();
        IFile sourceFile = GemUtilities.getSourceFile(sourceFilePathString, (IResource)this.activeFile);
        String fileName = sourceFile.getName();
        StringBuffer stringBuffer = new StringBuffer();
        String ranks = String.valueOf(Messages.GemAnalyzer_53) + env.getRank() + (System.getProperty("os.name").contains("Windows") ? "\t" : newline);
        if (env.isCollective() && this.lockedRank == -1) {
            int[] numRanksInvolved = new int[1];
            if (this.lockedRank == -1) {
                ranks = this.transitions.getRanksInvolved(numRanksInvolved);
            }
            int MAX = 16;
            if (numRanksInvolved[0] > 16) {
                String tempRanks = ranks;
                int total = 0;
                int i = 0;
                while (i < 16) {
                    total += tempRanks.indexOf(",") + 1;
                    tempRanks = tempRanks.substring(tempRanks.indexOf(",") + 1);
                    ++i;
                }
                stringBuffer.append(Messages.GemAnalyzer_22);
                stringBuffer.append(ranks.substring(0, total - 1));
                stringBuffer.append("...");
                stringBuffer.append(newline);
            } else {
                stringBuffer.append(Messages.GemAnalyzer_55);
                stringBuffer.append(ranks);
                stringBuffer.append(newline);
            }
            int ranksCommunicatedTo = 0;
            String communicator = env.getCommunicator_ranks_string();
            while (communicator != null && communicator.contains(":")) {
                communicator = communicator.substring(communicator.indexOf(":") + 1);
                ++ranksCommunicatedTo;
            }
            if (ranksCommunicatedTo != 0 && numRanksInvolved[0] / ranksCommunicatedTo > 1) {
                stringBuffer.append(Messages.GemAnalyzer_56);
                stringBuffer.append(numRanksInvolved[0] / ranksCommunicatedTo);
                stringBuffer.append(Messages.GemAnalyzer_57);
                stringBuffer.append(ranksCommunicatedTo);
                stringBuffer.append(Messages.GemAnalyzer_58);
            }
        }
        if (!env.isCollective()) {
            stringBuffer.append(ranks);
        }
        stringBuffer.append(Messages.GemAnalyzer_60);
        stringBuffer.append(fileName);
        stringBuffer.append("\t");
        stringBuffer.append(Messages.GemAnalyzer_61);
        stringBuffer.append(isLeft ? this.leftIndex : this.rightIndex);
        return stringBuffer.toString();
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GemAnalyzer.this.fillContextMenu(manager);
            }
        });
        Menu leftMenu = menuMgr.createContextMenu(this.leftViewer.getControl());
        this.leftViewer.getControl().setMenu(leftMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.leftViewer);
        Menu rightMenu = menuMgr.createContextMenu(this.rightViewer.getControl());
        this.rightViewer.getControl().setMenu(rightMenu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.rightViewer);
    }

    public void init(IResource resource) {
        this.activeFile = GemUtilities.adaptResource(resource);
        this.analyzerUpdateThread = new Thread(){

            public void run() {
                if (GemAnalyzer.this.aborted) {
                    Display.getDefault().syncExec((Runnable)GemAnalyzer.this.disableTerminateButtonThread);
                    Display.getDefault().syncExec((Runnable)GemAnalyzer.this.clearAnalyzerThread);
                    GemAnalyzer.this.aborted = false;
                    return;
                }
                if (GemAnalyzer.this.activeFile == null) {
                    Display.getDefault().syncExec((Runnable)GemAnalyzer.this.disableTerminateButtonThread);
                    GemAnalyzer.this.clear();
                    return;
                }
                GemAnalyzer.this.reset();
                GemAnalyzer.this.parseSourceFile(GemAnalyzer.this.activeFile, GemAnalyzer.this.activeFile);
                Display.getDefault().syncExec((Runnable)GemAnalyzer.this.disableTerminateButtonThread);
            }
        };
        this.clearAnalyzerThread = new Thread(){

            public void run() {
                String emptyString = "";
                GemAnalyzer.this.transitionsGroup.setText("Transition: 0/0");
                GemAnalyzer.this.interleavingsGroup.setText("Interleaving: 0/0");
                GemAnalyzer.this.firstTransitionButton.setEnabled(false);
                GemAnalyzer.this.previousTransitionButton.setEnabled(false);
                GemAnalyzer.this.nextTransitionButton.setEnabled(false);
                GemAnalyzer.this.lastTransitionButton.setEnabled(false);
                GemAnalyzer.this.firstInterleavingButton.setEnabled(false);
                GemAnalyzer.this.previousInterleavingButton.setEnabled(false);
                GemAnalyzer.this.nextInterleavingButton.setEnabled(false);
                GemAnalyzer.this.lastInterleavingButton.setEnabled(false);
                GemAnalyzer.this.deadlockInterleavingButton.setEnabled(false);
                GemAnalyzer.this.internalIssueOrderButton.setEnabled(false);
                GemAnalyzer.this.programOrderButton.setEnabled(false);
                GemAnalyzer.this.launchHpvButton.setEnabled(false);
                GemAnalyzer.this.browseCallsButton.setEnabled(false);
                GemAnalyzer.this.terminateButton.setEnabled(false);
                GemAnalyzer.this.errorMessageLabel.setText("");
                GemAnalyzer.this.transitions = null;
                GemAnalyzer.this.leftViewer.refresh();
                GemAnalyzer.this.rightViewer.refresh();
                GemAnalyzer.this.leftCodeWindowLabel.setText("");
                GemAnalyzer.this.rightCodeWindowLabel.setText("");
                String[] items = new String[]{""};
                GemAnalyzer.this.lockRanksComboList.setItems(items);
                GemUtilities.setTaskStatus(GemUtilities.TaskStatus.IDLE);
                GemAnalyzer.this.runGemButton.setEnabled(true);
            }
        };
        this.disableTerminateButtonThread = new Thread(){

            public void run() {
                GemAnalyzer.this.terminateButton.setEnabled(false);
                GemAnalyzer.this.runGemButton.setEnabled(true);
                GemAnalyzer.this.internalIssueOrderButton.setEnabled(true);
                GemAnalyzer.this.programOrderButton.setEnabled(true);
            }
        };
        this.terminateButton.setEnabled(true);
        this.runGemButton.setEnabled(false);
    }

    private void makeActions() {
        this.getHelp = new Action(){

            public void run() {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.ptp.gem.help/html/analyzerView.html");
            }
        };
        this.getHelp.setToolTipText(Messages.GemAnalyzer_73);
        this.getHelp.setImageDescriptor(GemPlugin.getImageDescriptor("icons/help-contents.gif"));
        this.terminateButton = new Action(){

            public void run() {
                GemAnalyzer.this.aborted = true;
                GemUtilities.terminateOperation();
            }
        };
        this.terminateButton.setImageDescriptor(GemPlugin.getImageDescriptor("icons/progress_stop.gif"));
        this.terminateButton.setToolTipText(Messages.GemAnalyzer_74);
        this.terminateButton.setEnabled(false);
    }

    private void openEditor(int lineNum, IFile sourceFile) {
        try {
            IEditorPart editor = IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)sourceFile, (boolean)true);
            IMarker marker = sourceFile.createMarker("org.eclipse.core.resources.marker");
            marker.setAttribute("lineNumber", lineNum);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
        }
        catch (Exception e) {
            GemUtilities.logExceptionDetail(e);
        }
    }

    private boolean parenthesesMatched(String call) {
        int numRightParens = 0;
        int numLeftParens = 0;
        call = this.removeComments(call);
        int i = 0;
        while (i < call.length()) {
            if (call.charAt(i) == '(') {
                ++numLeftParens;
            }
            if (call.charAt(i) == ')') {
                ++numRightParens;
            }
            ++i;
        }
        return numRightParens == numLeftParens;
    }

    public void parseSourceFile(IFile leftSourceFile, IFile rightSourceFile) {
        int lineNum;
        Scanner s;
        Boolean updateLeftFile = this.currLeftFile == null || !this.currLeftFile.equals((Object)leftSourceFile);
        Boolean updateRightFile = this.currRightFile == null || rightSourceFile == null || !this.currRightFile.equals((Object)rightSourceFile);
        this.currLeftFile = leftSourceFile;
        this.currRightFile = rightSourceFile;
        if (updateLeftFile.booleanValue()) {
            this.leftViewer.getList().removeAll();
        }
        boolean isCollective = false;
        if (this.transitions != null && this.transitions.getCurrentTransition() != null) {
            isCollective = this.transitions.getCurrentTransition().isCollective();
        }
        if (isCollective || updateRightFile.booleanValue()) {
            this.rightViewer.getList().removeAll();
        }
        InputStream leftSourceFileStream = null;
        InputStream rightSourceFileStream = null;
        String line = "";
        try {
            leftSourceFileStream = leftSourceFile.getContents(true);
            s = new Scanner(leftSourceFileStream);
            lineNum = 0;
            while (updateLeftFile.booleanValue() && s.hasNext()) {
                line = s.nextLine();
                this.leftViewer.add((Object)new ListElement(leftSourceFile, line, ++lineNum, false));
            }
        }
        catch (CoreException e) {
            GemUtilities.logExceptionDetail((Exception)((Object)e));
            this.leftViewer.add((Object)new ListElement(null, Messages.GemAnalyzer_76, -1, false));
        }
        try {
            if (rightSourceFile != null) {
                rightSourceFileStream = rightSourceFile.getContents();
                s = new Scanner(rightSourceFileStream);
                lineNum = 0;
                while (s.hasNext()) {
                    line = s.nextLine();
                    this.rightViewer.add((Object)new ListElement(rightSourceFile, line, ++lineNum, false));
                }
            } else {
                Envelope env = this.transitions.getCurrentTransition();
                if (env.isCollective()) {
                    this.displayCollectiveInfo();
                } else {
                    this.rightViewer.add((Object)new ListElement(null, "", -1, false));
                }
            }
        }
        catch (Exception e) {
            GemUtilities.logExceptionDetail(e);
            this.rightViewer.add((Object)new ListElement(null, Messages.GemAnalyzer_78, -1, false));
        }
        try {
            if (leftSourceFileStream != null) {
                leftSourceFileStream.close();
            }
            if (rightSourceFileStream != null) {
                rightSourceFileStream.close();
            }
        }
        catch (IOException e) {
            GemUtilities.logExceptionDetail(e);
        }
    }

    private String removeComments(String call) {
        while (call.contains("/*")) {
            if (!call.contains("*/")) break;
            call = String.valueOf(call.substring(0, call.indexOf("/*"))) + call.substring(call.indexOf("*/") + 2);
        }
        while (call.contains("//")) {
            call = call.substring(0, call.indexOf("//"));
        }
        return call;
    }

    private void reset() {
        this.currLeftFile = null;
        this.currRightFile = null;
        this.transitions.currentInterleaving = 0;
        this.transitions.currentTransitionIndex = 0;
        this.setMessageLabelText();
        this.setLockRankItems();
        this.setNumProcItems();
        this.leftIndex = 0;
        this.rightIndex = 0;
        this.lockedRank = -1;
        this.deadlockInterleavingButton.setEnabled(this.transitions.getDeadlockInterleavings() != null);
        this.browseCallsButton.setEnabled(true);
        this.browseCallsButton.setImage(GemPlugin.getImage(GemPlugin.getImageDescriptor("icons/browse.gif")));
        this.launchHpvButton.setEnabled(true);
        this.updateTransitionLabels(false);
        this.transitionLabelIndex = 0;
        this.transitionsGroup.setText("Transition " + this.transitionLabelIndex + "/" + this.transitionLabelCount);
        this.transitions.currentTransitionIndex = -1;
        this.leftIndex = 0;
        this.rightIndex = 0;
        this.previousLeftIndex = 0;
        this.setButtonEnabledState();
        this.updateSelectedLine(true);
        this.setMessageLabelText();
        GemUtilities.setTaskStatus(GemUtilities.TaskStatus.IDLE);
    }

    private void revealTreeItem(TreeItem callItem) {
        if (callItem.getParentItem() == null) {
            callItem.setExpanded(true);
        } else {
            this.revealTreeItem(callItem.getParentItem());
            callItem.setExpanded(true);
        }
    }

    private void setButtonEnabledState() {
        this.firstTransitionButton.setEnabled(this.transitions.hasValidPreviousTransition(this.lockedRank));
        this.previousTransitionButton.setEnabled(this.transitions.hasValidPreviousTransition(this.lockedRank));
        this.nextTransitionButton.setEnabled(this.transitions.hasValidNextTransition(this.lockedRank));
        this.lastTransitionButton.setEnabled(this.transitions.hasValidNextTransition(this.lockedRank));
        this.firstInterleavingButton.setEnabled(this.transitions.hasPreviousInterleaving());
        this.previousInterleavingButton.setEnabled(this.transitions.hasPreviousInterleaving());
        this.nextInterleavingButton.setEnabled(this.transitions.hasNextInterleaving());
        this.lastInterleavingButton.setEnabled(this.transitions.hasNextInterleaving());
        this.deadlockInterleavingButton.setEnabled(this.transitions.getDeadlockInterleavings() != null);
    }

    public void setFocus() {
        this.runGemButton.setFocus();
    }

    private Font setFontSize(Font font, int size) {
        FontData[] fontData;
        FontData[] fontDataArray = fontData = font.getFontData();
        int n = fontData.length;
        int n2 = 0;
        while (n2 < n) {
            FontData element = fontDataArray[n2];
            element.setHeight(size);
            ++n2;
        }
        return new Font((Device)this.parent.getDisplay(), fontData);
    }

    private void setLockRankItems() {
        String[] ranks = new String[this.numRanks + 1];
        ranks[0] = Messages.GemAnalyzer_83;
        int i = 1;
        while (i <= this.numRanks) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(Messages.GemAnalyzer_84);
            stringBuffer.append((Object)(i - 1));
            stringBuffer.append(Messages.GemAnalyzer_85);
            ranks[i] = stringBuffer.toString();
            ++i;
        }
        this.lockRanksComboList.setItems(ranks);
        this.lockRanksComboList.setText(ranks[0]);
    }

    private void setMessageLabelText() {
        Display display = this.parent.getShell().getDisplay();
        Color RED = new Color((Device)display, new RGB(255, 0, 0));
        Color GREEN = new Color((Device)display, new RGB(0, 200, 0));
        Color BLUE = new Color((Device)display, new RGB(0, 0, 255));
        this.interleavingsGroup.setText("Interleaving: " + this.transitions.getCurrentInterleaving() + "/" + this.transitions.getTotalInterleavings());
        this.transitionsGroup.setText("Transition: " + this.transitionLabelIndex + "/" + this.transitionLabelCount);
        if (this.transitions.hasDeadlock()) {
            this.errorMessageLabel.setForeground(RED);
            ArrayList<Integer> deadlockList = this.transitions.getDeadlockInterleavings();
            String deadlocks = "";
            if (deadlockList.size() == 1) {
                deadlocks = deadlockList.get(0).toString();
            } else {
                int i = 0;
                while (i < deadlockList.size()) {
                    String num = deadlockList.get(i).toString();
                    deadlocks = String.valueOf(deadlocks) + (i != deadlockList.size() - 1 ? String.valueOf(num) + ", " : num);
                    ++i;
                }
            }
            String errorMsg = Messages.GemAnalyzer_89;
            errorMsg = String.valueOf(errorMsg) + (deadlocks.length() == 1 ? " " : "s ");
            this.errorMessageLabel.setText(String.valueOf(errorMsg) + deadlocks);
        } else if (this.transitions.hasAssertion()) {
            this.errorMessageLabel.setForeground(RED);
            this.errorMessageLabel.setText(String.valueOf(Messages.GemAnalyzer_91) + this.transitions.getTotalInterleavings());
        } else if (this.transitions.hasError()) {
            this.errorMessageLabel.setForeground(RED);
            this.errorMessageLabel.setText(Messages.GemAnalyzer_92);
        } else if (this.transitions.hasResourceLeak() || this.transitions.hasFIB()) {
            this.errorMessageLabel.setForeground(BLUE);
            this.errorMessageLabel.setText(Messages.GemAnalyzer_93);
        } else {
            this.errorMessageLabel.setForeground(GREEN);
            this.errorMessageLabel.setText(Messages.GemAnalyzer_31);
        }
    }

    private void setNumProcItems() {
        String[] ranks = new String[16];
        int i = 1;
        while (i <= 16) {
            ranks[i - 1] = Integer.valueOf(i).toString();
            ++i;
        }
        this.setNumProcsComboList.setItems(ranks);
        Integer nprocs = GemPlugin.getDefault().getPreferenceStore().getInt("numprocsPreference");
        this.setNumProcsComboList.setText(nprocs.toString());
    }

    private Envelope skipRepeats(int direction) {
        Envelope env = this.transitions.getCurrentTransition();
        while (true) {
            if (env == null) {
                return null;
            }
            if (env.getLinenumber() != this.previousLeftIndex) break;
            if (direction == 1) {
                env = this.transitions.getNextTransition(this.lockedRank);
                continue;
            }
            env = this.transitions.getPreviousTransition(this.lockedRank);
        }
        return env;
    }

    public void update(IFile sourceFile, Transitions transitions) {
        if (transitions == null) {
            this.clear();
            return;
        }
        this.transitions = transitions;
        this.numRanks = transitions.getNumRanks();
        this.activeFile = sourceFile;
        Display.getDefault().syncExec((Runnable)this.analyzerUpdateThread);
    }

    private void updateCodeViewers() {
        String emptyString = "";
        Envelope env = this.transitions.getCurrentTransition();
        if (env != null) {
            boolean updateWindowContent;
            String nextLeftFileInfo = env.getFilePath();
            String nextRightFileInfo = "";
            env = this.transitions.getCurrentTransition().getMatch_envelope();
            if (env != null) {
                nextRightFileInfo = env.getFilePath();
            }
            Path nextLeftFilePath = new Path(nextLeftFileInfo);
            String nextLeftFileName = nextLeftFilePath.lastSegment();
            String nextRightFileName = "";
            if (nextRightFileInfo.length() != 0) {
                Path nextRightFilePath = new Path(nextRightFileInfo);
                nextRightFileName = nextRightFilePath.lastSegment();
            }
            boolean bl = updateWindowContent = this.currLeftFile == null || this.currRightFile == null || !nextLeftFileName.equals(this.currLeftFile.getName()) || !nextRightFileName.equals(this.currRightFile.getName()) || nextRightFileInfo.equals("");
            if (updateWindowContent) {
                boolean isEmptyPath;
                String projectName = this.activeFile.getProject().getName();
                IProject currentProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                IFile nextLeftSourceFile = GemUtilities.getSourceFile(nextLeftFileInfo, (IResource)this.activeFile);
                if (!nextLeftSourceFile.exists()) {
                    GemUtilities.refreshProject(currentProject);
                }
                IFile nextRightSourceFile = null;
                boolean bl2 = isEmptyPath = nextRightFileInfo.length() == 0;
                if (!isEmptyPath && !(nextRightSourceFile = GemUtilities.getSourceFile(nextRightFileInfo, (IResource)this.activeFile)).exists()) {
                    GemUtilities.refreshProject(currentProject);
                }
                this.parseSourceFile(nextLeftSourceFile, isEmptyPath ? null : nextRightSourceFile);
            }
        }
    }

    public void updateDropDown() {
        Integer nprocs = GemPlugin.getDefault().getPreferenceStore().getInt("numprocsPreference");
        this.setNumProcsComboList.setText(nprocs.toString());
    }

    private void updateFirstTransition(boolean update) {
        Envelope env = this.transitions.getFirstTransition(this.lockedRank);
        env = this.transitions.getCurrentTransition();
        if (env != null) {
            this.previousLeftIndex = env.getLinenumber();
        }
        if (env == null) {
            GemUtilities.showInformationDialog(Messages.GemAnalyzer_94);
            return;
        }
        if (update) {
            this.setButtonEnabledState();
            this.updateCodeViewers();
            this.displayEnvelopes(env);
            this.updateSelectedLine(true);
            this.transitionLabelIndex = 1;
            this.setMessageLabelText();
        }
    }

    private void updateLastTransition() {
        Envelope env = this.transitions.getLastTransition(this.lockedRank);
        if (env.getFunctionName().equals("MPI_Finalize")) {
            do {
                if ((env = this.transitions.getPreviousTransition(this.lockedRank)) != null) continue;
                GemUtilities.showInformationDialog(Messages.GemAnalyzer_95);
                return;
            } while (env.getFunctionName().equals("MPI_Finalize"));
            env = this.transitions.getNextTransition(this.lockedRank);
        }
        if (env == null) {
            GemUtilities.showInformationDialog(Messages.GemAnalyzer_96);
            return;
        }
        this.previousLeftIndex = env.getLinenumber();
        this.setButtonEnabledState();
        this.updateCodeViewers();
        this.displayEnvelopes(env);
        this.updateSelectedLine(true);
        this.transitionLabelIndex = this.transitionLabelCount;
        this.setMessageLabelText();
    }

    /*
     * Unable to fully structure code
     */
    private void updateLineCount() {
        leftList = this.leftViewer.getList();
        rightList = this.rightViewer.getList();
        emptyString = "";
        curr = "";
        this.leftLines = 1;
        if (this.leftIndex > 0) ** GOTO lbl18
        this.leftLines = 0;
        return;
lbl-1000:
        // 1 sources

        {
            curr = "";
            i = this.leftLines;
            while (i > 0) {
                curr = String.valueOf(curr) + leftList.getItem(this.leftIndex - i);
                curr = this.removeComments(curr);
                --i;
            }
            if (this.parenthesesMatched(curr)) break;
            ++this.leftLines;
lbl18:
            // 2 sources

            ** while (this.leftLines < this.leftIndex + 1)
        }
lbl19:
        // 2 sources

        curr = curr.substring(0, curr.indexOf("(") - 1);
        if (curr.trim().length() == 0) {
            ++this.leftLines;
        }
        if (this.rightIndex == -1) {
            return;
        }
        this.rightLines = 1;
        while (this.rightLines < this.rightIndex + 1) {
            curr = "";
            i = this.rightLines;
            while (i > 0) {
                curr = String.valueOf(curr) + rightList.getItem(this.rightIndex - i);
                curr = this.removeComments(curr);
                --i;
            }
            if (this.parenthesesMatched(curr)) break;
            ++this.rightLines;
        }
        curr = curr.substring(0, curr.indexOf("(") - 1);
        if (curr.trim().length() == 0) {
            ++this.rightLines;
        }
    }

    private int updateNextTransition(boolean update) {
        int returnValue = 1;
        Envelope env = this.transitions.getNextTransition(this.lockedRank);
        if (env.isCollective() && this.lockedRank == -1) {
            env = this.skipRepeats(1);
        }
        if (env == null) {
            returnValue = -1;
        } else {
            this.previousLeftIndex = env.getLinenumber();
        }
        if (update) {
            this.setButtonEnabledState();
            this.updateCodeViewers();
            this.displayEnvelopes(env);
            this.updateSelectedLine(true);
            ++this.transitionLabelIndex;
            this.setMessageLabelText();
        }
        return returnValue;
    }

    private void updatePreviousTransition() {
        Envelope env = this.transitions.getPreviousTransition(this.lockedRank);
        this.previousLeftIndex = env.getLinenumber();
        if (env.isCollective() && this.lockedRank == -1) {
            do {
                if ((env = this.transitions.getPreviousTransition(this.lockedRank)) != null) continue;
                this.updateFirstTransition(true);
                return;
            } while (env.getLinenumber() == this.previousLeftIndex);
            env = this.transitions.getNextTransition(this.lockedRank);
        }
        this.previousLeftIndex = env.getLinenumber();
        this.setButtonEnabledState();
        this.updateCodeViewers();
        this.displayEnvelopes(env);
        this.updateSelectedLine(true);
        --this.transitionLabelIndex;
        this.setMessageLabelText();
    }

    private void updateScrollBars() {
        org.eclipse.swt.widgets.List leftList = this.leftViewer.getList();
        org.eclipse.swt.widgets.List rightList = this.rightViewer.getList();
        try {
            if (leftList != null && leftList.getSelection().length != 0) {
                this.leftViewer.reveal(this.leftViewer.getElementAt(0));
                this.leftViewer.reveal(this.leftViewer.getElementAt(this.leftIndex - 1));
            }
            if (rightList != null && rightList.getSelection().length != 0) {
                this.rightViewer.reveal(this.rightViewer.getElementAt(0));
                this.rightViewer.reveal(this.rightViewer.getElementAt(this.rightIndex - 1));
            }
        }
        catch (Exception e) {
            GemUtilities.logExceptionDetail(e);
        }
    }

    private void updateSelectedLine(Boolean scroll) {
        this.updateCodeViewers();
        org.eclipse.swt.widgets.List leftList = this.leftViewer.getList();
        org.eclipse.swt.widgets.List rightList = this.rightViewer.getList();
        leftList.deselectAll();
        rightList.deselectAll();
        this.updateLineCount();
        int i = 0;
        while (i < this.leftLines) {
            leftList.select(this.leftIndex - i - 1);
            ++i;
        }
        i = 0;
        while (i < this.rightLines) {
            rightList.select(this.rightIndex - i - 1);
            ++i;
        }
        if (scroll.booleanValue()) {
            this.updateScrollBars();
        }
    }

    private void updateTransitionLabels(boolean displayEnvelope) {
        this.updateFirstTransition(false);
        this.transitionLabelCount = 1;
        Envelope env = this.transitions.getCurrentTransition();
        int test = 1;
        while (test == 1 && env != null) {
            if (!this.transitions.hasValidNextTransition(this.lockedRank)) break;
            ++this.transitionLabelCount;
            test = this.updateNextTransition(false);
        }
        this.updateFirstTransition(displayEnvelope);
    }

    private class DoubleClickListener
    implements IDoubleClickListener {
        private DoubleClickListener() {
        }

        public void doubleClick(DoubleClickEvent event) {
            ISelection selection = event.getSelection();
            StructuredSelection structure = (StructuredSelection)selection;
            ListElement element = (ListElement)structure.getFirstElement();
            if (element != null) {
                IFile sourceFile = element.getFile();
                int lineNumber = element.getLineNumber();
                GemAnalyzer.this.openEditor(lineNumber, sourceFile);
            }
        }
    }
}

